/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell.blocks;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.api.smartwrench.ISmartWrenchSelector;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.infoscreen.CapabilityInformationScreenInfo;
import mcjty.rftoolsbase.api.infoscreen.IInformationScreenInfo;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellConfiguration;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellModule;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellNetwork;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellBlock;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellInformationScreenInfo;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellType;
import mcjty.rftoolspower.modules.dimensionalcell.items.PowerCellCardItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class DimensionalCellTileEntity
extends TickingTileEntity
implements ISmartWrenchSelector {
    public static final int SLOT_CARD = 0;
    public static final int SLOT_CARDCOPY = 1;
    public static final int SLOT_CHARGEITEM = 2;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(3).slot(SlotDefinition.specific((Item[])new Item[]{(Item)DimensionalCellModule.POWERCELL_CARD.get()}).in().out(), 0, 28, 8).slot(SlotDefinition.specific((Item[])new Item[]{(Item)DimensionalCellModule.POWERCELL_CARD.get()}), 1, 64, 30).slot(SlotDefinition.generic(), 2, 64, 8).playerSlots(10, 70));
    public int tooltipEnergy = 0;
    public int tooltipBlocks = 0;
    public int tooltipSimpleBlocks = 0;
    public int tooltipAdvancedBlocks = 0;
    public long tooltipInserted = 0L;
    public long tooltipExtracted = 0L;
    public int tooltipRfPerTick = 0;
    public float tooltipCostFactor = 0.0f;
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (slot == 0 && stack.m_41720_() != DimensionalCellModule.POWERCELL_CARD.get()) {
            return false;
        }
        return slot != 1 || stack.m_41720_() == DimensionalCellModule.POWERCELL_CARD.get();
    }).onUpdate(this::onUpdateSlot).build();
    private final LazyOptional<IInformationScreenInfo> infoScreenInfo = LazyOptional.of(this::createScreenInfo);
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((BlockEntity)this));
    private final LazyOptional<NullHandler> nullStorage = LazyOptional.of(() -> new NullHandler());
    private final LazyOptional<IMachineInformation> infoHandler = LazyOptional.of(this::createMachineInfo);
    private final LazyOptional<SidedHandler>[] sidedStorages = new LazyOptional[]{LazyOptional.of(() -> new SidedHandler(Direction.DOWN)), LazyOptional.of(() -> new SidedHandler(Direction.UP)), LazyOptional.of(() -> new SidedHandler(Direction.NORTH)), LazyOptional.of(() -> new SidedHandler(Direction.SOUTH)), LazyOptional.of(() -> new SidedHandler(Direction.WEST)), LazyOptional.of(() -> new SidedHandler(Direction.EAST))};
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Dimensional Cell").containerSupplier(DefaultContainerProvider.container(DimensionalCellModule.CONTAINER_DIMENSIONAL_CELL, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.MODULE)
    private final LazyOptional<IModuleSupport> moduleSupportHandler = LazyOptional.of(() -> new DefaultModuleSupport(0){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.m_41720_() instanceof PowerCellCardItem;
        }
    });
    private int networkId = -1;
    private int energy = 0;
    private long totalExtracted = 0L;
    private long totalInserted = 0L;
    private int lastRfPerTickIn = 0;
    private int lastRfPerTickOut = 0;
    private int powerIn = 0;
    private int powerOut = 0;
    private long lastTime = 0L;
    private static final EnumProperty<Mode>[] MODES = new EnumProperty[]{DimensionalCellBlock.DOWN, DimensionalCellBlock.UP, DimensionalCellBlock.NORTH, DimensionalCellBlock.SOUTH, DimensionalCellBlock.WEST, DimensionalCellBlock.EAST};
    @ServerCommand
    public static final Command<?> ACTION_CLEARSTATS = Command.create((String)"clearStats", (te, player, params) -> {
        te.totalExtracted = 0L;
        te.totalInserted = 0L;
        te.m_6596_();
    });
    @ServerCommand
    public static final Command<?> ACTION_SETOUTPUT = Command.create((String)"setOutput", (te, player, params) -> te.setAllOutput());
    @ServerCommand
    public static final Command<?> ACTION_SETINPUT = Command.create((String)"setInput", (te, player, params) -> te.setAllInput());
    @ServerCommand
    public static final Command<?> ACTION_SETNONE = Command.create((String)"setNone", (te, player, params) -> te.setAllNone());
    public static final Key<Integer> PARAM_ENERGY = new Key("energy", Type.INTEGER);
    public static final Key<Integer> PARAM_BLOCKS = new Key("block", Type.INTEGER);
    public static final Key<Integer> PARAM_SIMPLEBLOCKS = new Key("simpleblocks", Type.INTEGER);
    public static final Key<Integer> PARAM_ADVANCEDBLOCKS = new Key("advancedblocks", Type.INTEGER);
    public static final Key<Long> PARAM_TOTAL_INSERTED = new Key("totalinserted", Type.LONG);
    public static final Key<Long> PARAM_TOTAL_EXTRACTED = new Key("totalextracted", Type.LONG);
    public static final Key<Integer> PARAM_RFPERTICK = new Key("rfpertick", Type.INTEGER);
    public static final Key<Double> PARAM_COSTFACTOR = new Key("costfactor", Type.DOUBLE);
    @ServerCommand
    public static final ResultCommand<?> CMD_GET_INFO = ResultCommand.create((String)"getInfo", (te, player, params) -> te.getInfo(), (te, player, params) -> {
        te.tooltipEnergy = (Integer)params.get(PARAM_ENERGY);
        te.tooltipBlocks = (Integer)params.get(PARAM_BLOCKS);
        te.tooltipSimpleBlocks = (Integer)params.get(PARAM_SIMPLEBLOCKS);
        te.tooltipAdvancedBlocks = (Integer)params.get(PARAM_ADVANCEDBLOCKS);
        te.tooltipInserted = (Long)params.get(PARAM_TOTAL_INSERTED);
        te.tooltipExtracted = (Long)params.get(PARAM_TOTAL_EXTRACTED);
        te.tooltipRfPerTick = (Integer)params.get(PARAM_RFPERTICK);
        te.tooltipCostFactor = ((Double)params.get(PARAM_COSTFACTOR)).floatValue();
    });

    public DimensionalCellTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private void onUpdateSlot(Integer slot, ItemStack stack) {
        if (slot == 0) {
            ItemStack s = this.items.getStackInSlot(0);
            if (s.m_41619_()) {
                this.handleCardRemoval();
            } else {
                this.handleCardInsertion();
            }
        } else if (slot == 1 && !stack.m_41619_()) {
            PowerCellCardItem.setId(stack, this.networkId);
        }
    }

    public int getLastRfPerTickIn() {
        return this.lastRfPerTickIn;
    }

    public int getLastRfPerTickOut() {
        return this.lastRfPerTickOut;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(int networkId) {
        this.networkId = networkId;
        this.m_6596_();
    }

    @Nullable
    public DimensionalCellNetwork.Network getNetwork() {
        if (this.f_58857_.f_46443_) {
            return null;
        }
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return null;
        }
        DimensionalCellNetwork generatorNetwork = DimensionalCellNetwork.get(this.f_58857_);
        return generatorNetwork.getOrCreateNetwork(networkId);
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.energy = info.m_128451_("energy");
        this.totalInserted = info.m_128454_("totIns");
        this.totalExtracted = info.m_128454_("totExt");
        this.networkId = info.m_128451_("networkId");
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("energy", this.energy);
        info.m_128356_("totIns", this.totalInserted);
        info.m_128356_("totExt", this.totalExtracted);
        info.m_128405_("networkId", this.networkId);
    }

    public Mode getMode(Direction side) {
        return (Mode)((Object)this.m_58900_().m_61143_(MODES[side.ordinal()]));
    }

    public void toggleMode(Direction side) {
        Mode mode = this.getMode(side);
        switch (mode) {
            case MODE_NONE: {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(MODES[side.ordinal()], (Comparable)((Object)Mode.MODE_INPUT)), 3);
                break;
            }
            case MODE_INPUT: {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(MODES[side.ordinal()], (Comparable)((Object)Mode.MODE_OUTPUT)), 3);
                break;
            }
            case MODE_OUTPUT: {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(MODES[side.ordinal()], (Comparable)((Object)Mode.MODE_NONE)), 3);
            }
        }
    }

    protected void tickServer() {
        int energyStored;
        long time = this.f_58857_.m_46467_();
        if (this.lastTime == 0L) {
            this.lastTime = time;
        } else if (time > this.lastTime + 40L) {
            this.lastRfPerTickIn = (int)((long)this.powerIn / (time - this.lastTime));
            this.lastRfPerTickOut = (int)((long)this.powerOut / (time - this.lastTime));
            this.lastTime = time;
            this.powerIn = 0;
            this.powerOut = 0;
        }
        if (this.getDimensionalCellType().isCreative()) {
            int gain = 1000000;
            int networkId = this.getNetworkId();
            if (networkId == -1) {
                this.receiveEnergyLocal(gain, false);
            } else {
                this.receiveEnergyMulti(gain, false);
            }
        }
        if ((energyStored = this.getEnergyStored()) <= 0) {
            return;
        }
        this.handleChargingItem();
        this.sendOutEnergy();
    }

    private void handleChargingItem() {
        ItemStack stack = this.items.getStackInSlot(2);
        if (stack.m_41619_()) {
            return;
        }
        int rfToGive = Math.min((Integer)DimensionalCellConfiguration.CHARGEITEMPERTICK.get(), this.getEnergyStored());
        int received = (int)EnergyTools.receiveEnergy((ItemStack)stack, (long)rfToGive);
        if (received == 0) {
            return;
        }
        this.extractEnergyInternal(received, false, (Integer)DimensionalCellConfiguration.CHARGEITEMPERTICK.get());
    }

    private void sendOutEnergy() {
        int energyStored = this.getEnergyStored();
        for (Direction face : OrientationTools.DIRECTION_VALUES) {
            int rfToGive;
            int received;
            Direction opposite;
            BlockPos pos;
            BlockEntity te;
            if (this.getMode(face) != Mode.MODE_OUTPUT || !EnergyTools.isEnergyTE((BlockEntity)(te = this.f_58857_.m_7702_(pos = this.m_58899_().m_121945_(face))), (Direction)(opposite = face.m_122424_())) || te instanceof DimensionalCellTileEntity && this.getNetworkId() != -1 && ((DimensionalCellTileEntity)te).getNetworkId() == this.getNetworkId()) continue;
            float factor = this.getCostFactor();
            int rfPerTick = this.getRfPerTickPerSide();
            if ((energyStored -= this.extractEnergyInternal(received = (int)EnergyTools.receiveEnergy((BlockEntity)te, (Direction)opposite, (long)(rfToGive = Math.min(rfPerTick, (int)((float)energyStored / factor)))), false, Integer.MAX_VALUE)) <= 0) break;
        }
    }

    public float getCostFactor() {
        float factor;
        float infusedFactor = this.getInfusedFactor().floatValue();
        if (this.getNetworkId() == -1) {
            factor = 1.0f;
        } else {
            factor = this.getNetwork().calculateCostFactor(this.f_58857_, this.getGlobalPos());
            factor = (factor - 1.0f) * (1.0f - infusedFactor / 2.0f) + 1.0f;
        }
        return factor;
    }

    private Float getInfusedFactor() {
        return this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f));
    }

    public int getRfPerTickPerSide() {
        return (int)((double)((Integer)DimensionalCellConfiguration.rfPerTick.get() * this.getPowerFactor() / (Integer)DimensionalCellConfiguration.simpleFactor.get()) * ((double)this.getInfusedFactor().floatValue() * 0.5 + 1.0));
    }

    private void handleCardRemoval() {
        DimensionalCellNetwork.Network network;
        if (!this.f_58857_.f_46443_ && (network = this.getNetwork()) != null) {
            this.energy = network.extractEnergySingleBlock(this.getDimensionalCellType());
            network.remove(this.f_58857_, this.getGlobalPos(), this.getDimensionalCellType());
            DimensionalCellNetwork.get(this.f_58857_).save();
        }
        this.networkId = -1;
        this.m_6596_();
    }

    private void handleCardInsertion() {
        ItemStack stack = this.items.getStackInSlot(0);
        int id = PowerCellCardItem.getId(stack);
        if (!this.f_58857_.f_46443_) {
            DimensionalCellNetwork channels = DimensionalCellNetwork.get(this.f_58857_);
            if (id == -1) {
                id = channels.newChannel();
                PowerCellCardItem.setId(stack, id);
            }
            this.networkId = id;
            DimensionalCellNetwork.Network network = this.getNetwork();
            network.add(this.f_58857_, this.getGlobalPos(), this.getDimensionalCellType());
            network.receiveEnergy(this.energy);
            channels.save();
        } else {
            this.networkId = id;
        }
        this.m_6596_();
    }

    private DimensionalCellType getDimensionalCellType() {
        return DimensionalCellBlock.getType(this.f_58857_.m_8055_(this.f_58858_).m_60734_());
    }

    private int getPowerFactor() {
        if (this.getDimensionalCellType().isSimple()) {
            return 1;
        }
        return this.getDimensionalCellType().isAdvanced() ? (Integer)DimensionalCellConfiguration.advancedFactor.get() * (Integer)DimensionalCellConfiguration.simpleFactor.get() : (Integer)DimensionalCellConfiguration.simpleFactor.get();
    }

    public int getEnergy() {
        return this.energy;
    }

    public GlobalPos getGlobalPos() {
        return GlobalPos.m_122643_((ResourceKey)this.f_58857_.m_46472_(), (BlockPos)this.m_58899_());
    }

    public long getTotalExtracted() {
        return this.totalExtracted;
    }

    public long getTotalInserted() {
        return this.totalInserted;
    }

    public void resetTotalExtracted() {
        this.totalExtracted = 0L;
    }

    public void resetTotalInserted() {
        this.totalInserted = 0L;
    }

    public int receiveEnergyFacing(Direction from, int maxReceive, boolean simulate) {
        if (this.getMode(from) != Mode.MODE_INPUT) {
            return 0;
        }
        maxReceive = Math.min(maxReceive, this.getRfPerTickPerSide());
        int networkId = this.getNetworkId();
        int received = networkId == -1 ? this.receiveEnergyLocal(maxReceive, simulate) : this.receiveEnergyMulti(maxReceive, simulate);
        if (!simulate) {
            this.totalInserted += (long)received;
            this.powerIn += received;
            this.m_6596_();
        }
        return received;
    }

    private int receiveEnergyMulti(int maxReceive, boolean simulate) {
        if (this.f_58857_.f_46443_) {
            return 0;
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        int totEnergy = network.calculateMaximumEnergy();
        int maxInsert = Math.min(totEnergy - network.getEnergy(), maxReceive);
        if (maxInsert > 0 && !simulate) {
            maxInsert = network.receiveEnergy(maxInsert);
            DimensionalCellNetwork.get(this.f_58857_).save();
        }
        return this.getDimensionalCellType().isCreative() ? maxReceive : maxInsert;
    }

    private int receiveEnergyLocal(int maxReceive, boolean simulate) {
        long capacityL = (long)((Integer)DimensionalCellConfiguration.rfPerNormalCell.get()).intValue() * (long)this.getPowerFactor() / (long)((Integer)DimensionalCellConfiguration.simpleFactor.get()).intValue();
        int capacity = capacityL > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)capacityL;
        int maxInsert = Math.min(capacity - this.energy, maxReceive);
        if (maxInsert > 0 && !simulate) {
            this.energy += maxInsert;
            this.m_6596_();
        }
        return this.getDimensionalCellType().isCreative() ? maxReceive : maxInsert;
    }

    private int extractEnergyInternal(int maxExtract, boolean simulate, int maximum) {
        int networkId = this.getNetworkId();
        int extracted = networkId == -1 ? this.extractEnergyLocal(maxExtract, simulate, maximum) : this.extractEnergyMulti(maxExtract, simulate, maximum);
        if (!simulate) {
            this.totalExtracted += (long)extracted;
            this.powerOut += extracted;
            this.m_6596_();
        }
        return extracted;
    }

    private int extractEnergyMulti(int maxExtract, boolean simulate, int maximum) {
        if (this.f_58857_.f_46443_) {
            return 0;
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        if (maxExtract > maximum) {
            maxExtract = maximum;
        }
        if (!simulate) {
            maxExtract = network.extractEnergy(maxExtract);
            DimensionalCellNetwork.get(this.f_58857_).save();
        }
        return maxExtract;
    }

    private int extractEnergyLocal(int maxExtract, boolean simulate, int maximum) {
        if (maxExtract > this.energy) {
            maxExtract = this.energy;
        }
        if (maxExtract > maximum) {
            maxExtract = maximum;
        }
        if (!simulate) {
            this.energy -= maxExtract;
            this.m_6596_();
        }
        return maxExtract;
    }

    public int getEnergyStored() {
        if (this.f_58857_.f_46443_) {
            return 0;
        }
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return this.energy;
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        return network.getEnergy();
    }

    public int getMaxEnergyStored() {
        if (this.f_58857_.f_46443_) {
            return 0;
        }
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return (Integer)DimensionalCellConfiguration.rfPerNormalCell.get() * this.getPowerFactor() / (Integer)DimensionalCellConfiguration.simpleFactor.get();
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        return network.calculateMaximumEnergy();
    }

    public void setAllOutput() {
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_58900_().m_61124_(DimensionalCellBlock.DOWN, (Comparable)((Object)Mode.MODE_OUTPUT))).m_61124_(DimensionalCellBlock.UP, (Comparable)((Object)Mode.MODE_OUTPUT))).m_61124_(DimensionalCellBlock.NORTH, (Comparable)((Object)Mode.MODE_OUTPUT))).m_61124_(DimensionalCellBlock.SOUTH, (Comparable)((Object)Mode.MODE_OUTPUT))).m_61124_(DimensionalCellBlock.WEST, (Comparable)((Object)Mode.MODE_OUTPUT))).m_61124_(DimensionalCellBlock.EAST, (Comparable)((Object)Mode.MODE_OUTPUT)), 3);
    }

    private void setAllInput() {
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_58900_().m_61124_(DimensionalCellBlock.DOWN, (Comparable)((Object)Mode.MODE_INPUT))).m_61124_(DimensionalCellBlock.UP, (Comparable)((Object)Mode.MODE_INPUT))).m_61124_(DimensionalCellBlock.NORTH, (Comparable)((Object)Mode.MODE_INPUT))).m_61124_(DimensionalCellBlock.SOUTH, (Comparable)((Object)Mode.MODE_INPUT))).m_61124_(DimensionalCellBlock.WEST, (Comparable)((Object)Mode.MODE_INPUT))).m_61124_(DimensionalCellBlock.EAST, (Comparable)((Object)Mode.MODE_INPUT)), 3);
    }

    private void setAllNone() {
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_58900_().m_61124_(DimensionalCellBlock.DOWN, (Comparable)((Object)Mode.MODE_NONE))).m_61124_(DimensionalCellBlock.UP, (Comparable)((Object)Mode.MODE_NONE))).m_61124_(DimensionalCellBlock.NORTH, (Comparable)((Object)Mode.MODE_NONE))).m_61124_(DimensionalCellBlock.SOUTH, (Comparable)((Object)Mode.MODE_NONE))).m_61124_(DimensionalCellBlock.WEST, (Comparable)((Object)Mode.MODE_NONE))).m_61124_(DimensionalCellBlock.EAST, (Comparable)((Object)Mode.MODE_NONE)), 3);
    }

    public void selectBlock(Player player, BlockPos pos) {
        DimensionalCellTileEntity.dumpNetwork(player, this);
    }

    public static void dumpNetwork(Player player, DimensionalCellTileEntity dimensionalCellTileEntity) {
        DimensionalCellNetwork.Network network = dimensionalCellTileEntity.getNetwork();
        Set<GlobalPos> blocks = network.getBlocks();
        blocks.forEach(b -> {
            Object msg;
            ServerLevel w = LevelTools.getLevel((ResourceKey)b.m_122640_());
            if (w == null) {
                msg = "dimension missing!";
            } else {
                Block block = w.m_8055_(b.m_122646_()).m_60734_();
                msg = block == DimensionalCellModule.DIMENSIONAL_CELL.get() ? "normal" : (block == DimensionalCellModule.DIMENSIONAL_CELL_ADVANCED.get() ? "advanced" : (block == DimensionalCellModule.DIMENSIONAL_CELL_CREATIVE.get() ? "creative" : "not a powercell!"));
                BlockEntity te = w.m_7702_(b.m_122646_());
                if (te instanceof DimensionalCellTileEntity) {
                    DimensionalCellTileEntity power = (DimensionalCellTileEntity)te;
                    msg = (String)msg + " (+:" + power.getTotalInserted() + ", -:" + power.getTotalExtracted() + ")";
                }
            }
            Logging.message((Player)player, (String)("Block: " + BlockPosTools.toString((BlockPos)b.m_122646_()) + " (" + b.m_122640_().m_135782_().m_135815_() + "): " + (String)msg));
        });
    }

    private TypedMap getInfo() {
        if (this.networkId == -1) {
            return TypedMap.builder().put(PARAM_ENERGY, (Object)this.getEnergy()).put(PARAM_BLOCKS, (Object)1).put(PARAM_SIMPLEBLOCKS, (Object)(this.getDimensionalCellType().isSimple() ? 1 : 0)).put(PARAM_ADVANCEDBLOCKS, (Object)(this.getDimensionalCellType().isAdvanced() ? 1 : 0)).put(PARAM_TOTAL_INSERTED, (Object)this.getTotalInserted()).put(PARAM_TOTAL_EXTRACTED, (Object)this.getTotalExtracted()).put(PARAM_RFPERTICK, (Object)this.getRfPerTickPerSide()).put(PARAM_COSTFACTOR, (Object)1.0).build();
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        return TypedMap.builder().put(PARAM_ENERGY, (Object)network.getEnergy()).put(PARAM_BLOCKS, (Object)network.getBlockCount()).put(PARAM_SIMPLEBLOCKS, (Object)network.getSimpleBlockCount()).put(PARAM_ADVANCEDBLOCKS, (Object)network.getAdvancedBlockCount()).put(PARAM_TOTAL_INSERTED, (Object)this.getTotalInserted()).put(PARAM_TOTAL_EXTRACTED, (Object)this.getTotalExtracted()).put(PARAM_RFPERTICK, (Object)this.getRfPerTickPerSide()).put(PARAM_COSTFACTOR, (Object)this.getCostFactor()).build();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (facing == null) {
                return this.nullStorage.cast();
            }
            return this.sidedStorages[facing.ordinal()].cast();
        }
        if (capability == CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY) {
            return this.infoHandler.cast();
        }
        if (capability == CapabilityInformationScreenInfo.INFORMATION_SCREEN_INFO_CAPABILITY) {
            return this.infoScreenInfo.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    private IInformationScreenInfo createScreenInfo() {
        return new DimensionalCellInformationScreenInfo(this);
    }

    @Nonnull
    private IMachineInformation createMachineInfo() {
        return new IMachineInformation(){
            private final String[] TAGS = new String[]{"rfpertick_out", "rfpertick_in", "rftotal_in", "rftotal_out"};
            private final String[] TAG_DESCRIPTIONS = new String[]{"The current RF/t output given by this block (last 2 seconds)", "The current RF/t input received by this block (last 2 seconds)", "The total RF/t output given by this block", "The current RF/t input received by this block"};

            public int getTagCount() {
                return this.TAGS.length;
            }

            public String getTagName(int index) {
                return this.TAGS[index];
            }

            public String getTagDescription(int index) {
                return this.TAG_DESCRIPTIONS[index];
            }

            public String getData(int index, long millis) {
                return switch (index) {
                    case 0 -> DimensionalCellTileEntity.this.lastRfPerTickOut + "RF/t";
                    case 1 -> DimensionalCellTileEntity.this.lastRfPerTickIn + "RF/t";
                    case 2 -> DimensionalCellTileEntity.this.totalExtracted + "RF";
                    case 3 -> DimensionalCellTileEntity.this.totalInserted + "RF";
                    default -> null;
                };
            }
        };
    }

    public static enum Mode implements StringRepresentable
    {
        MODE_NONE("none", "overlay_none"),
        MODE_INPUT("input", "overlay_in"),
        MODE_OUTPUT("output", "overlay_out");

        private final String name;
        private final String overlayName;

        private Mode(String name, String overlayName) {
            this.name = name;
            this.overlayName = overlayName;
        }

        public String getOverlayName() {
            return this.overlayName;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.m_7912_();
        }
    }

    private class SidedHandler
    implements IEnergyStorage {
        private final Direction facing;

        private SidedHandler(Direction facing) {
            this.facing = facing;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return DimensionalCellTileEntity.this.receiveEnergyFacing(this.facing, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return DimensionalCellTileEntity.this.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return DimensionalCellTileEntity.this.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }

    private class NullHandler
    implements IEnergyStorage {
        private NullHandler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return DimensionalCellTileEntity.this.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return DimensionalCellTileEntity.this.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return false;
        }
    }
}

