/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.world;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.util.SupplierBlockStateProviderAE;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.world.DefaultFeatures;
import com.hollingsworth.arsnouveau.common.world.WorldEvent;
import com.hollingsworth.arsnouveau.common.world.biome.ModBiomes;
import com.hollingsworth.arsnouveau.common.world.tree.MagicTrunkPlacer;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.SoundRegistry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModWorldgen {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"ars_elemental");
    public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFG_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"ars_elemental");
    public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"ars_elemental");
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"ars_elemental");
    public static final String FLASHING_FOREST_ID = "flashing_forest";
    public static final String BLAZING_FOREST_ID = "blazing_forest";
    public static final String CASCADING_FOREST_ID = "cascading_forest";
    public static final String FLOURISHING_FOREST_ID = "flourishing_forest";
    public static final ResourceKey<Biome> FLASHING_FOREST_KEY = ModWorldgen.register("flashing_forest");
    public static final ResourceKey<Biome> BLAZING_FOREST_KEY = ModWorldgen.register("blazing_forest");
    public static final ResourceKey<Biome> CASCADING_FOREST_KEY = ModWorldgen.register("cascading_forest");
    public static final ResourceKey<Biome> FLOURISHING_FOREST_KEY = ModWorldgen.register("flourishing_forest");
    public static final RegistryObject<Biome> FLASHING_FOREST = BIOMES.register("flashing_forest", ModWorldgen::flashingArchwoodForest);
    public static final RegistryObject<Biome> BLAZING_FOREST = BIOMES.register("blazing_forest", ModWorldgen::blazingArchwoodForest);
    public static final RegistryObject<Biome> CASCADING_FOREST = BIOMES.register("cascading_forest", ModWorldgen::cascadingArchwoodForest);
    public static final RegistryObject<Biome> FLOURISHING_FOREST = BIOMES.register("flourishing_forest", ModWorldgen::flourishArchwoodForest);
    public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> FLASHING_TREE_SAPLING = CONFG_FEATURES.register("flashing_feature", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(10, 1, 0, false, "ars_elemental:flashpine_pod"), (BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.m_146622_((int)0, (int)0), (IntProvider)UniformInt.m_146622_((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68244_().m_68251_()));
    public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> NATURAL_FLASHING_TREE = CONFG_FEATURES.register("natural_flashing_feature", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(10, 2, 0, true, "ars_elemental:flashpine_pod"), (BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.m_146622_((int)0, (int)0), (IntProvider)UniformInt.m_146622_((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68251_()));
    public static final RegistryObject<PlacedFeature> SIMPLE_FLASHING_PLACED = PLACED_FEATURES.register("simple_flashing", () -> new PlacedFeature(Holder.m_205709_((Object)((ConfiguredFeature)NATURAL_FLASHING_TREE.get())), List.of(PlacementUtils.m_206493_((Block)((Block)ModItems.FLASHING_SAPLING.get())))));
    public static final RegistryObject<PlacedFeature> COMMON_FLASHING_PLACED = PLACED_FEATURES.register("common_flashing", () -> new PlacedFeature(Holder.m_205709_((Object)((ConfiguredFeature)NATURAL_FLASHING_TREE.get())), List.of(PlacementUtils.m_195364_((int)5, (float)0.01f, (int)1), PlacementUtils.f_195355_, PlacementUtils.m_206493_((Block)((Block)ModItems.FLASHING_SAPLING.get())))));
    public static final RegistryObject<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> RARE_FLASHING_TREES = CONFG_FEATURES.register("random_simple_flashing", () -> new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{(Holder)SIMPLE_FLASHING_PLACED.getHolder().get()}))));
    public static final RegistryObject<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> COMMON_FLASHING_TREES = CONFG_FEATURES.register("random_common_flashing", () -> new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{(Holder)COMMON_FLASHING_PLACED.getHolder().get()}))));
    public static final RegistryObject<PlacedFeature> RARE_FLASHING_CONFIGURED = PLACED_FEATURES.register("flashing_archwood", () -> new PlacedFeature(Holder.m_205709_((Object)((ConfiguredFeature)RARE_FLASHING_TREES.get())), VegetationPlacements.m_195479_((PlacementModifier)RarityFilter.m_191900_((int)200))));
    public static final RegistryObject<PlacedFeature> COMMON_FLASHING_CONFIGURED = PLACED_FEATURES.register("common_flashing_archwood", () -> new PlacedFeature(Holder.m_205709_((Object)((ConfiguredFeature)COMMON_FLASHING_TREES.get())), VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)2), (Block)((Block)ModItems.FLASHING_SAPLING.get()))));
    public static final RegistryObject<PlacedFeature> CLUSTER_FLASHING_CONFIGURED = PLACED_FEATURES.register("cluster_flashing_archwood", () -> new PlacedFeature(Holder.m_205709_((Object)((ConfiguredFeature)COMMON_FLASHING_TREES.get())), VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)6), (Block)((Block)ModItems.FLASHING_SAPLING.get()))));
    public static final RegistryObject<PlacedFeature> CLUSTER_BLAZING_CONFIGURED;
    public static final RegistryObject<PlacedFeature> CLUSTER_CASCADING_CONFIGURED;
    public static final RegistryObject<PlacedFeature> CLUSTER_FLOURISHING_CONFIGURED;
    public static final String SIMPLE_FLASHING_ID = "simple_flashing";
    public static final String COMMON_FLASHING_ID = "common_flashing";
    public static final String RARE_RANDOM_FLASHING_ID = "random_simple_flashing";
    public static final String COMMON_RANDOM_FLASHING_ID = "random_common_flashing";
    public static final String FINAL_RARE_FLASHING = "flashing_archwood";
    public static final String FINAL_COMMON_FLASHING = "common_flashing_archwood";
    public static final String FINAL_CLUSTER_FLASHING = "cluster_flashing_archwood";
    public static final String FINAL_CLUSTER_CASCADING = "cluster_cascading_archwood";
    public static final String FINAL_CLUSTER_BLAZING = "cluster_blazing_archwood";
    public static final String FINAL_CLUSTER_FLOURISHING = "cluster_flourishing_archwood";

    public static ResourceKey<Biome> register(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)ArsElemental.prefix(name));
    }

    public static Biome flashingArchwoodForest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.STARBUNCLE_TYPE.get(), 2, 3, 5));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ENTITY_DRYGMY.get(), 2, 1, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.WHIRLISPRIG_TYPE.get(), 2, 1, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)alexthw.ars_elemental.registry.ModEntities.FLASHING_WEALD_WALKER.get(), 3, 1, 3));
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = ModWorldgen.getArchwoodBiomeBuilder(COMMON_FLASHING_CONFIGURED.getId());
        return ModBiomes.biome((Biome.Precipitation)Biome.Precipitation.RAIN, (float)0.4f, (float)0.9f, (int)7978751, (int)329011, (int)7978751, (int)13414701, (int)13084948, (MobSpawnSettings.Builder)spawnBuilder, (BiomeGenerationSettings.Builder)biomeBuilder, () -> Musics.m_11653_((SoundEvent)((SoundEvent)SoundRegistry.ARIA_BIBLIO.get())));
    }

    private static Biome blazingArchwoodForest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.STARBUNCLE_TYPE.get(), 2, 3, 5));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ENTITY_DRYGMY.get(), 2, 1, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.WHIRLISPRIG_TYPE.get(), 2, 1, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ENTITY_BLAZING_WEALD.get(), 3, 1, 1));
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = ModWorldgen.getArchwoodBiomeBuilder(CLUSTER_BLAZING_CONFIGURED.getId());
        return ModBiomes.biome((Biome.Precipitation)Biome.Precipitation.RAIN, (float)0.9f, (float)0.4f, (int)7978751, (int)329011, (int)7978751, (int)16077890, (int)2210437, (MobSpawnSettings.Builder)spawnBuilder, (BiomeGenerationSettings.Builder)biomeBuilder, () -> Musics.m_11653_((SoundEvent)((SoundEvent)SoundRegistry.ARIA_BIBLIO.get())));
    }

    private static Biome cascadingArchwoodForest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.STARBUNCLE_TYPE.get(), 2, 3, 5));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ENTITY_DRYGMY.get(), 2, 1, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.WHIRLISPRIG_TYPE.get(), 2, 1, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ENTITY_CASCADING_WEALD.get(), 3, 1, 1));
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = ModWorldgen.getArchwoodBiomeBuilder(CLUSTER_CASCADING_CONFIGURED.getId());
        return ModBiomes.biome((Biome.Precipitation)Biome.Precipitation.RAIN, (float)0.7f, (float)0.9f, (int)7978751, (int)329011, (int)7978751, (int)1142955, (int)2210437, (MobSpawnSettings.Builder)spawnBuilder, (BiomeGenerationSettings.Builder)biomeBuilder, () -> Musics.m_11653_((SoundEvent)((SoundEvent)SoundRegistry.ARIA_BIBLIO.get())));
    }

    private static Biome flourishArchwoodForest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.STARBUNCLE_TYPE.get(), 2, 3, 5));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ENTITY_DRYGMY.get(), 2, 1, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.WHIRLISPRIG_TYPE.get(), 2, 1, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ENTITY_FLOURISHING_WEALD.get(), 3, 1, 1));
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = ModWorldgen.getArchwoodBiomeBuilder(CLUSTER_FLOURISHING_CONFIGURED.getId());
        return ModBiomes.biome((Biome.Precipitation)Biome.Precipitation.RAIN, (float)0.7f, (float)0.8f, (int)7978751, (int)329011, (int)7978751, (int)1346066, (int)2210437, (MobSpawnSettings.Builder)spawnBuilder, (BiomeGenerationSettings.Builder)biomeBuilder, () -> Musics.m_11653_((SoundEvent)((SoundEvent)SoundRegistry.ARIA_BIBLIO.get())));
    }

    @NotNull
    private static BiomeGenerationSettings.Builder getArchwoodBiomeBuilder(ResourceLocation archwoodCluster) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        ModBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126816_((BiomeGenerationSettings.Builder)biomeBuilder);
        DefaultFeatures.softDisks((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195421_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, BuiltinRegistries.f_194653_.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)new ResourceLocation("ars_nouveau", "placed_lights"))));
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, BuiltinRegistries.f_194653_.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)archwoodCluster)));
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, WorldEvent.ArtisanalMojangGrassTM);
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, WorldEvent.ArtisanalMojangFlowersTM);
        return biomeBuilder;
    }

    static {
        CLUSTER_CASCADING_CONFIGURED = PLACED_FEATURES.register(FINAL_CLUSTER_CASCADING, () -> new PlacedFeature(Holder.m_205709_((Object)((ConfiguredFeature)WorldEvent.NATURAL_CASCADE_TREE.get())), VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)6), (Block)BlockRegistry.CASCADING_SAPLING)));
        CLUSTER_BLAZING_CONFIGURED = PLACED_FEATURES.register(FINAL_CLUSTER_BLAZING, () -> new PlacedFeature(Holder.m_205709_((Object)((ConfiguredFeature)WorldEvent.NATURAL_BLAZING_TREE.get())), VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)6), (Block)BlockRegistry.BLAZING_SAPLING)));
        CLUSTER_FLOURISHING_CONFIGURED = PLACED_FEATURES.register(FINAL_CLUSTER_FLOURISHING, () -> new PlacedFeature(Holder.m_205709_((Object)((ConfiguredFeature)WorldEvent.NATURAL_FLOURISHING_TREE.get())), VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)6), (Block)BlockRegistry.FLOURISHING_SAPLING)));
    }
}

