/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.armor;

import alexthw.ars_elemental.api.item.IElementalArmor;
import alexthw.ars_elemental.client.TooltipUtils;
import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.registry.ModItems;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkProvider;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ElementalArmor
extends AnimatedMagicArmor
implements IElementalArmor {
    final SpellSchool element;
    EquipmentSlot[] OrderedSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public ElementalArmor(EquipmentSlot slot, SpellSchool element, Item.Properties builder) {
        super(IElementalArmor.schoolToMaterial(element), slot, builder);
        this.element = element;
    }

    @Override
    public SpellSchool getSchool() {
        return this.element;
    }

    @Override
    public String getTier() {
        return "medium";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        IPerkProvider perkProvider = ArsNouveauAPI.getInstance().getPerkProvider(stack.m_41720_());
        if (perkProvider != null) {
            tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{4}).m_130940_(ChatFormatting.GOLD));
            perkProvider.getPerkHolder((Object)stack).appendPerkTooltip(tooltip, (Object)stack);
        }
        TooltipUtils.addOnShift(tooltip, () -> this.addInformationAfterShift(stack, world, tooltip, flags), "armor_set");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformationAfterShift(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        Player player = ArsNouveau.proxy.getPlayer();
        if (player != null) {
            ArmorSet set = this.getArmorSetFromElement(this.element);
            ArrayList<MutableComponent> equippedList = new ArrayList<MutableComponent>();
            int equippedCounter = 0;
            for (EquipmentSlot slot : this.OrderedSlots) {
                Item armor = set.getArmorFromSlot(slot);
                MutableComponent cmp = Component.m_237113_((String)" - ").m_7220_(armor.m_7968_().m_41786_());
                if (this.hasArmorSetItem(player.m_6844_(slot), armor)) {
                    cmp.m_130940_(ChatFormatting.GREEN);
                    ++equippedCounter;
                } else {
                    cmp.m_130940_(ChatFormatting.GRAY);
                }
                equippedList.add(cmp);
            }
            list.add(this.getArmorSetTitle(set, equippedCounter));
            list.addAll(equippedList);
            this.addArmorSetDescription(set, list);
        }
    }

    private boolean hasArmorSetItem(ItemStack armor, Item armorFromSlot) {
        return armor.m_41720_() == armorFromSlot;
    }

    ArmorSet getArmorSetFromElement(SpellSchool element) {
        return switch (element.getId()) {
            case "air" -> ModItems.AIR_ARMOR;
            case "fire" -> ModItems.FIRE_ARMOR;
            case "water" -> ModItems.WATER_ARMOR;
            case "earth" -> ModItems.EARTH_ARMOR;
            default -> null;
        };
    }

    private Component getArmorSetTitle(ArmorSet set, int equipped) {
        return Component.m_237115_((String)set.getTranslationKey()).m_130946_(" (" + equipped + " / 4)").m_130940_(ChatFormatting.DARK_AQUA);
    }

    public void addArmorSetDescription(ArmorSet set, List<Component> list) {
        list.add((Component)Component.m_237115_((String)("ars_elemental.armor_set." + set.getName() + ".desc")).m_130940_(ChatFormatting.GRAY));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack) {
        ImmutableMultimap.Builder attributes = new ImmutableMultimap.Builder();
        attributes.putAll(super.m_7167_(pEquipmentSlot));
        if (this.f_40377_ == pEquipmentSlot) {
            UUID uuid = this.getModifierForSlot(this.f_40377_);
            IPerkHolder perkHolder = PerkUtil.getPerkHolder((ItemStack)stack);
            if (perkHolder != null) {
                attributes.put((Object)((Attribute)PerkAttributes.FLAT_MANA_BONUS.get()), (Object)new AttributeModifier(uuid, "max_mana_armor", 100.0, AttributeModifier.Operation.ADDITION));
                attributes.put((Object)((Attribute)PerkAttributes.MANA_REGEN_BONUS.get()), (Object)new AttributeModifier(uuid, "mana_regen_armor", 5.0, AttributeModifier.Operation.ADDITION));
                for (PerkInstance perkInstance : perkHolder.getPerkInstances()) {
                    IPerk perk = perkInstance.getPerk();
                    attributes.putAll(perk.getModifiers(this.f_40377_, stack, perkInstance.getSlot().value));
                }
            }
        }
        return attributes.build();
    }
}

