/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental;

import alexthw.ars_elemental.ArsNouveauRegistry;
import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.client.ClientEvents;
import alexthw.ars_elemental.client.SpellFocusRenderer;
import alexthw.ars_elemental.registry.ModAdvTriggers;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModLoot;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.registry.ModRegistry;
import alexthw.ars_elemental.util.CompatUtils;
import alexthw.ars_elemental.world.TerrablenderAE;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod(value="ars_elemental")
public class ArsElemental {
    public static final ResourceLocation FOCUS_SLOT = new ResourceLocation("curios:slot/an_focus_slot");
    public static final ResourceLocation BANGLE_SLOT = new ResourceLocation("curios:slot/bangle_slot");
    public static final String MODID = "ars_elemental";
    public static final CreativeModeTab TAB = new CreativeModeTab("ars_elemental"){

        @NotNull
        public ItemStack m_6976_() {
            return ((Item)ModItems.DEBUG_ICON.get()).m_7968_();
        }
    };
    public static final UUID Dev = UUID.fromString("0e918660-22bf-4bed-8426-ece3b4bbd01d");
    public static boolean terrablenderLoaded = false;

    public ArsElemental() {
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHandler.CLIENT_SPEC);
        ModRegistry.registerRegistries(modbus);
        ModLoot.init();
        ArsNouveauRegistry.init();
        modbus.addListener(this::setup);
        modbus.addListener(this::sendImc);
        modbus.addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
            modbus.addListener(this::doClientStuff);
            return new Object();
        });
        ModAdvTriggers.init();
    }

    public static ResourceLocation prefix(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModPotions.addPotionRecipes();
            ArsNouveauRegistry.postInit();
            CompatUtils.checkCompats();
        });
        if (terrablenderLoaded && (Integer)Config.ARCHWOOD_FOREST_WEIGHT.get() > 0) {
            event.enqueueWork(TerrablenderAE::registerBiomes);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doClientStuff(FMLClientSetupEvent event) {
        if (!((Boolean)ConfigHandler.Client.EnableSFRendering.get()).booleanValue()) {
            return;
        }
        CuriosRendererRegistry.register((Item)((Item)ModItems.FIRE_FOCUS.get()), SpellFocusRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ModItems.WATER_FOCUS.get()), SpellFocusRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ModItems.AIR_FOCUS.get()), SpellFocusRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ModItems.EARTH_FOCUS.get()), SpellFocusRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ModItems.NECRO_FOCUS.get()), SpellFocusRenderer::new);
    }

    public void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("bundle").size(1).icon(new ResourceLocation("curios", "slot/empty_curio_slot")).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("bangle").size(1).icon(BANGLE_SLOT).build());
        InterModComms.sendTo((String)"curios", (String)"modify_type", () -> new SlotTypeMessage.Builder("an_focus").size(1).icon(FOCUS_SLOT).build());
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            ComposterBlock.f_51914_.putIfAbsent((Object)((Block)ModItems.FLASHING_SAPLING.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.putIfAbsent((Object)((Block)ModItems.FLASHING_POD.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.putIfAbsent((Object)((Block)ModItems.FLASHING_LEAVES.get()).m_5456_(), 0.3f);
        });
    }
}

