/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.items;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import mcjty.lib.client.GuiTools;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsbase.api.various.ITabletSupport;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerModule;
import mcjty.rftoolsstorage.modules.scanner.blocks.RemoteStorageScannerContainer;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerContainer;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.modules.scanner.items.StorageControlClientScreenModule;
import mcjty.rftoolsstorage.modules.scanner.items.StorageControlScreenModule;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class StorageControlModuleItem
extends GenericModuleItem
implements INBTPreservingIngredient,
ITabletSupport {
    public Item getInstalledTablet() {
        return (Item)StorageScannerModule.TABLET_SCANNER.get();
    }

    public void openGui(@Nonnull Player player, @Nonnull ItemStack tabletItem, @Nonnull ItemStack containingItem) {
        final BlockPos pos = ModuleTools.getPositionFromModule((ItemStack)containingItem);
        ResourceKey dimensionType = ModuleTools.getDimensionFromModule((ItemStack)containingItem);
        GuiTools.openRemoteGui((Player)player, (ResourceKey)dimensionType, (BlockPos)pos, te -> new MenuProvider(){
            final /* synthetic */ BlockEntity val$te;
            {
                this.val$te = blockEntity;
            }

            @Nonnull
            public Component m_5446_() {
                return ComponentFactory.literal((String)"Remote Storage Scanner");
            }

            @Nonnull
            public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
                RemoteStorageScannerContainer container = StorageScannerContainer.createRemote(id, pos, (StorageScannerTileEntity)this.val$te, player);
                this.val$te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> container.setupInventories((IItemHandler)h, inventory));
                return container;
            }
        });
    }

    protected int getUses(ItemStack stack) {
        return (Integer)StorageScannerConfiguration.STORAGE_CONTROL_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !ModuleTools.hasModuleTarget((ItemStack)stack);
    }

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public StorageControlModuleItem() {
        super(RFToolsStorage.setup.defaultProperties().m_41487_(1).m_41499_(1));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof IStorageScanner) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            String name = "<invalid>";
            if (block != null && !world.m_8055_(pos).m_60795_()) {
                name = Tools.getReadableName((Level)world, (BlockPos)pos);
            }
            ModuleTools.setPositionInModule((ItemStack)stack, (ResourceKey)world.m_46472_(), (BlockPos)pos, (String)name);
            if (world.f_46443_) {
                Logging.message((Player)player, (String)("Storage module is set to block '" + name + "'"));
            }
        } else {
            ModuleTools.clearPositionInModule((ItemStack)stack);
            if (world.f_46443_) {
                Logging.message((Player)player, (String)"Storage module is cleared");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Class<StorageControlScreenModule> getServerScreenModule() {
        return StorageControlScreenModule.class;
    }

    public Class<StorageControlClientScreenModule> getClientScreenModule() {
        return StorageControlClientScreenModule.class;
    }

    public String getModuleName() {
        return "Stor";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.ghostStack("stack0").ghostStack("stack1").ghostStack("stack2").nl().ghostStack("stack3").ghostStack("stack4").ghostStack("stack5").nl().ghostStack("stack6").ghostStack("stack7").ghostStack("stack8").nl().toggle("starred", "Starred", new String[]{"If enabled only count items", "in 'starred' inventories", "(mark inventories in storage scanner)"}).block("monitor").nl();
    }

    public Collection<String> getTagsToPreserve() {
        return Collections.emptyList();
    }
}

