/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.blocks;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.FakePlayerGetter;
import mcjty.lib.varia.InventoryTools;
import mcjty.lib.varia.ItemStackTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import mcjty.rftoolsbase.api.infoscreen.CapabilityInformationScreenInfo;
import mcjty.rftoolsbase.api.infoscreen.IInformationScreenInfo;
import mcjty.rftoolsbase.api.storage.IInventoryTracker;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.RFCraftingRecipe;
import mcjty.rftoolsstorage.craftinggrid.StorageCraftingTools;
import mcjty.rftoolsstorage.craftinggrid.TileEntityItemSource;
import mcjty.rftoolsstorage.modules.craftingmanager.blocks.CraftingManagerTileEntity;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingSystem;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerModule;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerContainer;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerInformationScreenInfo;
import mcjty.rftoolsstorage.modules.scanner.tools.CachedItemCount;
import mcjty.rftoolsstorage.modules.scanner.tools.CachedItemKey;
import mcjty.rftoolsstorage.modules.scanner.tools.InventoryAccessSettings;
import mcjty.rftoolsstorage.modules.scanner.tools.SortingMode;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class StorageScannerTileEntity
extends TickingTileEntity
implements CraftingGridProvider,
JEIRecipeAcceptor,
IStorageScanner {
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final Key<Boolean> PARAM_VIEW = new Key("view", Type.BOOLEAN);
    @GuiValue(name="export")
    private boolean exportToCurrent = false;
    @GuiValue
    public static final Value<?, Integer> VALUE_RADIUS = Value.create((String)"radius", (Type)Type.INTEGER, StorageScannerTileEntity::getRadius, StorageScannerTileEntity::setRadius);
    @GuiValue
    private SortingMode sortMode = SortingMode.NAME;
    public long rfReceived = 0L;
    public boolean exportToCurrentReceived = false;
    private final FakePlayerGetter lazyPlayer = new FakePlayerGetter((GenericTileEntity)this, "rftools_storage");
    public static final int XNETDELAY = 40;
    private final CraftingSystem craftingSystem = new CraftingSystem(this);
    private List<BlockPos> inventories = new ArrayList<BlockPos>();
    private List<BlockPos> craftingInventories = null;
    private final Set<BlockPos> inventoriesFromXNet = new HashSet<BlockPos>();
    private Map<BlockPos, InventoryAccessSettings> xnetAccess = Collections.emptyMap();
    private int xnetDelay = 40;
    private final Map<CachedItemKey, CachedItemCount> cachedCounts = new HashMap<CachedItemKey, CachedItemCount>();
    private final Set<BlockPos> routable = new HashSet<BlockPos>();
    private int radius = 1;
    private BlockPos lastSelectedInventory = null;
    @GuiValue
    private boolean openWideView = true;
    private final LazyOptional<IInformationScreenInfo> infoScreenInfo = LazyOptional.of(this::createScreenInfo);
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)StorageScannerConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)StorageScannerConfiguration.RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.ITEMS)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, StorageScannerContainer.CONTAINER_FACTORY).insertable(GenericItemHandler.slot((int)2)).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Storage Scanner").containerSupplier((windowId, player) -> StorageScannerContainer.create(windowId, this.m_58899_(), this, player)).energyHandler(() -> this.energyStorage).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((BlockEntity)this));
    private final CraftingGrid craftingGrid = new CraftingGrid();
    private ResourceKey<Level> dummyType = null;
    private static final ItemStack DUMMY = new ItemStack((ItemLike)Items.f_41829_, 666);
    @ServerCommand
    public static final Command<?> CMD_CLEARGRID = Command.create((String)"clearGrid", (te, player, params) -> te.clearGrid());
    @ServerCommand
    public static final Command<?> CMD_UP = Command.create((String)"scanner.up", (te, player, params) -> te.moveUp((Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_TOP = Command.create((String)"scanner.top", (te, player, params) -> te.moveTop((Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_DOWN = Command.create((String)"scanner.down", (te, player, params) -> te.moveDown((Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_BOTTOM = Command.create((String)"scanner.bottom", (te, player, params) -> te.moveBottom((Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_REMOVE = Command.create((String)"scanner.remove", (te, player, params) -> te.removeInventory((Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_TOGGLEROUTABLE = Command.create((String)"scanner.toggleRoutable", (te, player, params) -> te.toggleRoutable((BlockPos)params.get(PARAM_POS)));
    @ServerCommand
    public static final Command<?> CMD_SETVIEW = Command.create((String)"scanner.setView", (te, player, params) -> te.setOpenWideView((Boolean)params.get(PARAM_VIEW)));
    public static final Key<Long> PARAM_ENERGY = new Key("energy", Type.LONG);
    public static final Key<Boolean> PARAM_EXPORT = new Key("export", Type.BOOLEAN);
    @ServerCommand
    public static final ResultCommand<?> CMD_SCANNER_INFO = ResultCommand.create((String)"getScannerInfo", (te, player, params) -> TypedMap.builder().put(PARAM_ENERGY, (Object)te.getStoredPower()).put(PARAM_EXPORT, (Object)te.isExportToCurrent()).build(), (te, player, params) -> {
        te.rfReceived = (Long)params.get(PARAM_ENERGY);
        te.exportToCurrentReceived = (Boolean)params.get(PARAM_EXPORT);
    });

    public StorageScannerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StorageScannerModule.TYPE_STORAGE_SCANNER.get(), pos, state);
        this.radius = (Boolean)StorageScannerConfiguration.xnetRequired.get() != false && RFToolsStorage.setup.xnet ? 0 : 1;
    }

    public StorageScannerTileEntity(ResourceKey<Level> type, BlockPos pos) {
        this(pos, null);
        this.dummyType = type;
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.m_6596_();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.m_6596_();
    }

    @Override
    @Nonnull
    public List<Pair<ItemStack, Integer>> craft(Player player, int n, boolean test) {
        RFCraftingRecipe activeRecipe = this.craftingGrid.getActiveRecipe();
        return this.craft(player, n, test, activeRecipe);
    }

    @Nonnull
    public List<Pair<ItemStack, Integer>> craft(Player player, int n, boolean test, RFCraftingRecipe activeRecipe) {
        TileEntityItemSource itemSource = new TileEntityItemSource().add((IItemHandler)new InvWrapper((Container)player.m_150109_()), 0);
        this.inventories.stream().filter(p -> this.isOutputFromGui((BlockPos)p) && this.isRoutable((BlockPos)p)).forEachOrdered(p -> {
            BlockEntity tileEntity = this.f_58857_.m_7702_(p);
            if (!(tileEntity instanceof CraftingManagerTileEntity) && tileEntity != null && !(tileEntity instanceof StorageScannerTileEntity)) {
                itemSource.add(tileEntity, 0);
            }
        });
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, activeRecipe, itemSource);
        }
        StorageCraftingTools.craftItems(player, n, activeRecipe, itemSource);
        return Collections.emptyList();
    }

    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().setStackInSlot(i, stacks.get(i));
        }
        this.m_6596_();
    }

    private long getStoredPower() {
        return this.energyStorage.getEnergy();
    }

    private void consumeEnergy(long e) {
        this.energyStorage.consumeEnergy(e);
    }

    protected void tickServer() {
        ItemStack stack;
        this.craftingSystem.tick(this.f_58857_);
        --this.xnetDelay;
        if (this.xnetDelay < 0) {
            this.xnetAccess = Collections.emptyMap();
            this.xnetDelay = 40;
        }
        if (!this.items.getStackInSlot(0).m_41619_()) {
            if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue()) {
                return;
            }
            stack = this.items.getStackInSlot(0);
            stack = this.injectStackInternal(stack, this.exportToCurrent, (Function<BlockPos, Boolean>)((Function)this::isInputFromGui));
            this.items.setStackInSlot(0, stack);
            this.consumeEnergy(((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue());
        }
        if (!this.items.getStackInSlot(2).m_41619_()) {
            if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue()) {
                return;
            }
            stack = this.items.getStackInSlot(2);
            stack = this.injectStackInternal(stack, false, (Function<BlockPos, Boolean>)((Function)this::isInputFromAuto));
            this.items.setStackInSlot(2, stack);
            this.consumeEnergy(((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue());
        }
    }

    public ItemStack injectStackFromScreen(ItemStack stack, Player player) {
        if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue()) {
            player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "Not enough power to insert items!")), false);
            return stack;
        }
        if (!this.checkForRoutableInventories()) {
            player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "There are no routable inventories!")), false);
            return stack;
        }
        if ((stack = this.injectStackInternal(stack, false, (Function<BlockPos, Boolean>)((Function)this::isInputFromScreen))).m_41619_()) {
            this.consumeEnergy(((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue());
            SoundTools.playSound((Level)this.f_58857_, (SoundEvent)SoundEvents.f_12019_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)1.0, (double)3.0);
        }
        return stack;
    }

    private boolean checkForRoutableInventories() {
        return this.inventories.stream().filter(p -> this.isValid((BlockPos)p) && !p.equals((Object)this.m_58899_()) && this.isRoutable((BlockPos)p) && LevelTools.isLoaded((Level)this.f_58857_, (BlockPos)p)).anyMatch(p -> this.f_58857_.m_7702_(p) != null);
    }

    private ItemStack injectStackInternal(ItemStack stack, boolean toSelected, @Nonnull Function<BlockPos, Boolean> testAccess) {
        if (toSelected && this.lastSelectedInventory != null && this.lastSelectedInventory.m_123342_() != -1) {
            BlockEntity te2 = this.f_58857_.m_7702_(this.lastSelectedInventory);
            if (te2 != null && !(te2 instanceof StorageScannerTileEntity) && ((Boolean)testAccess.apply((Object)this.lastSelectedInventory)).booleanValue() && this.getInputMatcher(this.lastSelectedInventory).test(stack) && (stack = InventoryTools.insertItem((Level)this.f_58857_, (BlockPos)this.lastSelectedInventory, null, (ItemStack)stack)).m_41619_()) {
                return stack;
            }
            return stack;
        }
        ItemStack finalStack = stack;
        Iterator iterator = this.inventories.stream().filter(p -> (Boolean)testAccess.apply(p) != false && !p.equals((Object)this.m_58899_()) && this.isRoutable((BlockPos)p) && LevelTools.isLoaded((Level)this.f_58857_, (BlockPos)p) && this.getInputMatcher((BlockPos)p).test(finalStack)).map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity) && !(te instanceof CraftingManagerTileEntity)).iterator();
        while (!stack.m_41619_() && iterator.hasNext()) {
            BlockEntity te3 = (BlockEntity)iterator.next();
            stack = InventoryTools.insertItem((Level)this.f_58857_, (BlockPos)te3.m_58899_(), null, (ItemStack)stack);
        }
        return stack;
    }

    public void giveToPlayerFromScreen(ItemStack stack, boolean single, Player player) {
        if (stack.m_41619_()) {
            return;
        }
        if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerRequest.get()).intValue()) {
            player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "Not enough power to request items!")), false);
            return;
        }
        int[] cnt = new int[]{single ? 1 : stack.m_41741_()};
        int orig = cnt[0];
        this.inventories.stream().filter(this::isOutputFromScreen).map(this::getItemHandlerAt).forEachOrdered(handler -> handler.ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                ItemStack itemStack = h.getStackInSlot(i);
                if (!StorageScannerTileEntity.isItemEqual(stack, itemStack)) continue;
                ItemStack received = h.extractItem(i, cnt[0], false);
                this.giveItemToPlayer(player, cnt, received);
            }
        }));
        if (orig != cnt[0]) {
            this.consumeEnergy(((Integer)StorageScannerConfiguration.rfPerRequest.get()).intValue());
            SoundTools.playSound((Level)this.f_58857_, (SoundEvent)SoundEvents.f_12019_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)1.0, (double)1.0);
        }
    }

    private boolean giveItemToPlayer(Player player, int[] cnt, ItemStack received) {
        if (!received.m_41619_() && cnt[0] > 0) {
            cnt[0] = cnt[0] - received.m_41613_();
            this.giveToPlayer(received, player);
            return true;
        }
        return false;
    }

    private boolean giveToPlayer(ItemStack stack, Player player) {
        if (stack.m_41619_()) {
            return false;
        }
        if (!player.m_150109_().m_36054_(stack)) {
            player.m_5552_(stack, 1.05f);
        }
        return true;
    }

    public int countItems(Predicate<ItemStack> matcher, boolean starred, @Nullable Integer maxneeded) {
        int[] cc = new int[]{0};
        this.inventories.stream().filter(p -> this.isValid((BlockPos)p) && (!starred || this.isRoutable((BlockPos)p)) && LevelTools.isLoaded((Level)this.f_58857_, (BlockPos)p)).map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity) && !(te instanceof CraftingManagerTileEntity)).allMatch(te -> {
            InventoryTools.getItems((BlockEntity)te, (Predicate)matcher).forEach(s -> {
                cc[0] = cc[0] + s.m_41613_();
            });
            return maxneeded == null || cc[0] < maxneeded;
        });
        return cc[0];
    }

    @Nonnull
    public ItemStack getItem(Predicate<ItemStack> matcher, boolean starred) {
        return this.inventories.stream().filter(p -> this.isValid((BlockPos)p) && (!starred || this.isRoutable((BlockPos)p)) && LevelTools.isLoaded((Level)this.f_58857_, (BlockPos)p)).map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity) && !(te instanceof CraftingManagerTileEntity)).map(te -> InventoryTools.getFirstMatchingItem((BlockEntity)te, (Predicate)matcher)).filter(s -> !s.m_41619_()).findFirst().orElse(ItemStack.f_41583_);
    }

    public int countItems(ItemStack match, boolean routable) {
        return this.countItems(match, routable, null);
    }

    public int countItems(ItemStack stack, boolean starred, @Nullable Integer maxneeded) {
        if (stack.m_41619_()) {
            return 0;
        }
        Iterator iterator = this.inventories.stream().filter(p -> this.isValid((BlockPos)p) && (!starred || this.isRoutable((BlockPos)p)) && LevelTools.isLoaded((Level)this.f_58857_, (BlockPos)p)).map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity) && !(te instanceof CraftingManagerTileEntity)).iterator();
        int cnt = 0;
        while (iterator.hasNext()) {
            BlockEntity te2 = (BlockEntity)iterator.next();
            Integer cachedCount = null;
            if (te2 instanceof IInventoryTracker) {
                int oldVersion;
                IInventoryTracker tracker = (IInventoryTracker)te2;
                CachedItemCount itemCount = this.cachedCounts.get(new CachedItemKey(te2.m_58899_(), stack.m_41720_(), 0));
                if (itemCount != null && (oldVersion = itemCount.version()) == tracker.getVersion()) {
                    cachedCount = itemCount.count();
                }
            }
            if (cachedCount != null) {
                cnt += cachedCount.intValue();
            } else {
                int[] cc = new int[]{0};
                InventoryTools.getItems((BlockEntity)te2, s -> StorageScannerTileEntity.isItemEqual(stack, s)).forEach(s -> {
                    cc[0] = cc[0] + s.m_41613_();
                });
                if (te2 instanceof IInventoryTracker) {
                    IInventoryTracker tracker = (IInventoryTracker)te2;
                    this.cachedCounts.put(new CachedItemKey(te2.m_58899_(), stack.m_41720_(), 0), new CachedItemCount(tracker.getVersion(), cc[0]));
                }
                cnt += cc[0];
            }
            if (maxneeded == null || cnt < maxneeded) continue;
            break;
        }
        return cnt;
    }

    public static boolean isItemEqual(ItemStack thisItem, ItemStack other) {
        if (other.m_41619_()) {
            return false;
        }
        return thisItem.m_41656_(other);
    }

    public Set<BlockPos> performSearch(String search) {
        Predicate<ItemStack> matcher = StorageScannerTileEntity.getMatcher(search);
        HashSet<BlockPos> output = new HashSet<BlockPos>();
        this.inventories.stream().filter(this::isValid).map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity)).forEach(te -> InventoryTools.getItems((BlockEntity)te, (Predicate)matcher).forEach(s -> output.add(te.m_58899_())));
        return output;
    }

    public static Predicate<ItemStack> getMatcher(String search) {
        String[] splitted;
        Predicate<ItemStack> matcher = null;
        search = search.toLowerCase();
        for (String split : splitted = StringUtils.split((String)search)) {
            matcher = matcher == null ? StorageScannerTileEntity.makeSearchPredicate(split) : matcher.and(StorageScannerTileEntity.makeSearchPredicate(split));
        }
        if (matcher == null) {
            matcher = s -> true;
        }
        return matcher;
    }

    private static Predicate<ItemStack> makeSearchPredicate(String split) {
        if (split.startsWith("@")) {
            return s -> Tools.getModid((ItemStack)s).toLowerCase().startsWith(split.substring(1));
        }
        return s -> s.m_41786_().getString().toLowerCase().contains(split);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int v) {
        this.radius = v;
        if (((Boolean)StorageScannerConfiguration.xnetRequired.get()).booleanValue() && RFToolsStorage.setup.xnet) {
            this.radius = 0;
        }
        this.m_6596_();
    }

    public boolean isOpenWideView() {
        return this.openWideView;
    }

    public void setOpenWideView(boolean openWideView) {
        this.openWideView = openWideView;
        this.m_6596_();
    }

    public boolean isExportToCurrent() {
        return this.exportToCurrent;
    }

    public void setExportToCurrent(boolean exportToCurrent) {
        this.exportToCurrent = exportToCurrent;
        this.m_6596_();
    }

    private void toggleExportRoutable() {
        this.exportToCurrent = !this.exportToCurrent;
        this.m_6596_();
    }

    public boolean isRoutable(BlockPos p) {
        return this.routable.contains(p);
    }

    public boolean isValid(BlockPos p) {
        if (this.xnetAccess.containsKey(p)) {
            return true;
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isOutputFromGui(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockOutputGui();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isOutputFromScreen(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockOutputScreen();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isOutputFromAuto(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockOutputAuto();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public Predicate<ItemStack> getInputMatcher(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return settings.getMatcher();
        }
        return stack -> true;
    }

    public boolean isInputFromGui(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockInputGui();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isInputFromScreen(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockInputScreen();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isInputFromAuto(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockInputAuto();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public void toggleRoutable(BlockPos p) {
        if (this.routable.contains(p)) {
            this.routable.remove(p);
        } else {
            this.routable.add(p);
        }
        this.m_6596_();
    }

    public void register(Map<BlockPos, InventoryAccessSettings> access) {
        this.xnetAccess = access;
        this.xnetDelay = 40;
    }

    private void moveUp(int index) {
        if (index <= 0) {
            return;
        }
        if (index >= this.inventories.size()) {
            return;
        }
        BlockPos p1 = this.inventories.get(index - 1);
        BlockPos p2 = this.inventories.get(index);
        this.inventories.set(index - 1, p2);
        this.inventories.set(index, p1);
        this.m_6596_();
    }

    private void moveTop(int index) {
        if (index <= 0) {
            return;
        }
        if (index >= this.inventories.size()) {
            return;
        }
        BlockPos p = this.inventories.get(index);
        this.inventories.remove(index);
        this.inventories.add(0, p);
        this.m_6596_();
    }

    private void moveDown(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.inventories.size() - 1) {
            return;
        }
        BlockPos p1 = this.inventories.get(index);
        BlockPos p2 = this.inventories.get(index + 1);
        this.inventories.set(index, p2);
        this.inventories.set(index + 1, p1);
        this.m_6596_();
    }

    private void moveBottom(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.inventories.size() - 1) {
            return;
        }
        BlockPos p = this.inventories.get(index);
        this.inventories.remove(index);
        this.inventories.add(p);
        this.m_6596_();
    }

    private void removeInventory(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.inventories.size()) {
            return;
        }
        BlockPos p = this.inventories.get(index);
        if (this.inventoriesFromXNet.contains(p)) {
            return;
        }
        BlockPos removed = this.inventories.remove(index);
        if (this.craftingInventories != null) {
            this.craftingInventories.remove(removed);
        }
        this.m_6596_();
    }

    private boolean canPlayerAccess(Player fakePlayer, BlockPos p) {
        if (((Boolean)StorageScannerConfiguration.scannerNoRestrictions.get()).booleanValue()) {
            return true;
        }
        return this.f_58857_.m_8055_(p).canEntityDestroy((BlockGetter)this.f_58857_, p, (Entity)fakePlayer);
    }

    public void clearCachedCounts() {
        this.cachedCounts.clear();
    }

    public Stream<BlockPos> findInventories() {
        if (RFToolsStorage.setup.xnet && ((Boolean)StorageScannerConfiguration.xnetRequired.get()).booleanValue()) {
            this.radius = 0;
        }
        this.cachedCounts.clear();
        this.inventoriesFromXNet.clear();
        List<BlockPos> old = this.inventories;
        HashSet<BlockPos> oldAdded = new HashSet<BlockPos>();
        HashSet<BlockPos> seenPositions = new HashSet<BlockPos>();
        this.inventories = new ArrayList<BlockPos>();
        this.craftingInventories = new ArrayList<BlockPos>();
        ServerPlayer fakePlayer = this.lazyPlayer.get();
        for (BlockPos p : old) {
            BlockEntity te;
            if (!this.xnetAccess.containsKey(p) && !this.inRange(p) || (te = this.f_58857_.m_7702_(p)) == null || te instanceof StorageScannerTileEntity || !this.canPlayerAccess((Player)fakePlayer, p)) continue;
            if (te instanceof CraftingManagerTileEntity) {
                if (!seenPositions.add(p)) continue;
                this.inventories.add(p);
                this.craftingInventories.add(p);
                oldAdded.add(p);
                continue;
            }
            te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                if (seenPositions.add(p)) {
                    this.inventories.add(p);
                    oldAdded.add(p);
                }
            });
        }
        for (int x = this.m_58899_().m_123341_() - this.radius; x <= this.m_58899_().m_123341_() + this.radius; ++x) {
            for (int z = this.m_58899_().m_123343_() - this.radius; z <= this.m_58899_().m_123343_() + this.radius; ++z) {
                for (int y = this.m_58899_().m_123342_() - this.radius; y <= this.m_58899_().m_123342_() + this.radius; ++y) {
                    BlockPos p = new BlockPos(x, y, z);
                    this.inventoryAddNew(oldAdded, seenPositions, p);
                }
            }
        }
        for (BlockPos p : this.xnetAccess.keySet()) {
            this.inventoryAddNew(oldAdded, seenPositions, p);
            this.inventoriesFromXNet.add(p);
        }
        return this.getAllInventories();
    }

    public List<BlockPos> getCraftingInventories() {
        if (this.craftingInventories == null) {
            this.craftingInventories = new ArrayList<BlockPos>();
            this.getAllInventories().forEach(pos -> {
                if (this.f_58857_.m_7702_(pos) instanceof CraftingManagerTileEntity) {
                    this.craftingInventories.add((BlockPos)pos);
                }
            });
        }
        return this.craftingInventories;
    }

    public Stream<BlockPos> getAllInventories() {
        return this.inventories.stream().filter(this::isValid);
    }

    private void inventoryAddNew(Set<BlockPos> oldAdded, Set<BlockPos> seenPositions, BlockPos p) {
        if (!oldAdded.contains(p)) {
            BlockEntity te = this.f_58857_.m_7702_(p);
            if (this.canPlayerAccess((Player)this.lazyPlayer.get(), p) && te != null && !(te instanceof StorageScannerTileEntity)) {
                if (te instanceof CraftingManagerTileEntity) {
                    if (seenPositions.add(p)) {
                        this.inventories.add(p);
                        this.craftingInventories.add(p);
                    }
                } else if (!this.inventories.contains(p)) {
                    te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                        if (seenPositions.add(p)) {
                            this.inventories.add(p);
                        }
                    });
                }
            }
        }
    }

    private boolean inRange(BlockPos p) {
        return p.m_123341_() >= this.m_58899_().m_123341_() - this.radius && p.m_123341_() <= this.m_58899_().m_123341_() + this.radius && p.m_123342_() >= this.m_58899_().m_123342_() - this.radius && p.m_123342_() <= this.m_58899_().m_123342_() + this.radius && p.m_123343_() >= this.m_58899_().m_123343_() - this.radius && p.m_123343_() <= this.m_58899_().m_123343_() + this.radius;
    }

    public ItemStack requestItem(Predicate<ItemStack> matcher, boolean simulate, int amount, boolean doRoutable) {
        if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerRequest.get()).intValue()) {
            return ItemStack.f_41583_;
        }
        ServerPlayer fakePlayer = this.lazyPlayer.get();
        return this.inventories.stream().filter(p -> this.isOutputFromAuto((BlockPos)p) && (!doRoutable || this.isRoutable((BlockPos)p))).filter(p -> !(this.f_58857_.m_7702_(p) instanceof CraftingManagerTileEntity)).filter(arg_0 -> this.lambda$requestItem$37((Player)fakePlayer, arg_0)).map(this::getItemHandlerAt).map(handler -> handler.map(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                ItemStack received;
                ItemStack itemStack = h.getStackInSlot(i);
                if (!matcher.test(itemStack) || (received = h.extractItem(i, amount, simulate)).m_41619_()) continue;
                return received.m_41777_();
            }
            return DUMMY;
        }).orElse(DUMMY)).filter(s -> s != DUMMY).findFirst().orElse(ItemStack.f_41583_);
    }

    public ItemStack requestItem(ItemStack match, int amount, boolean doRoutable) {
        if (match.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerRequest.get()).intValue()) {
            return ItemStack.f_41583_;
        }
        ItemStack[] result = new ItemStack[]{ItemStack.f_41583_};
        int[] cnt = new int[]{Math.min(match.m_41741_(), amount)};
        ServerPlayer fakePlayer = this.lazyPlayer.get();
        this.inventories.stream().filter(p -> this.isOutputFromAuto((BlockPos)p) && !doRoutable || this.isRoutable((BlockPos)p)).filter(p -> !(this.f_58857_.m_7702_(p) instanceof CraftingManagerTileEntity)).filter(arg_0 -> this.lambda$requestItem$43((Player)fakePlayer, arg_0)).map(this::getItemHandlerAt).allMatch(handler -> {
            handler.ifPresent(h -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    ItemStack received;
                    ItemStack itemStack = h.getStackInSlot(i);
                    if (!StorageScannerTileEntity.isItemEqual(match, itemStack) || (received = h.extractItem(i, cnt[0], false)).m_41619_()) continue;
                    if (result[0].m_41619_()) {
                        result[0] = received;
                    } else {
                        result[0].m_41769_(received.m_41613_());
                    }
                    cnt[0] = cnt[0] - received.m_41613_();
                }
            });
            return cnt[0] > 0;
        });
        if (!result[0].m_41619_()) {
            this.consumeEnergy(((Integer)StorageScannerConfiguration.rfPerRequest.get()).intValue());
        }
        return result[0];
    }

    @Nonnull
    private LazyOptional<IItemHandler> getItemHandlerAt(BlockPos p) {
        if (!LevelTools.isLoaded((Level)this.f_58857_, (BlockPos)p)) {
            return LazyOptional.empty();
        }
        BlockEntity te = this.f_58857_.m_7702_(p);
        if (te == null || te instanceof StorageScannerTileEntity) {
            return LazyOptional.empty();
        }
        return StorageScannerTileEntity.getItemHandlerAt(te, null);
    }

    @Nonnull
    private static LazyOptional<IItemHandler> getItemHandlerAt(@Nullable BlockEntity te, Direction intSide) {
        if (te != null) {
            return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, intSide);
        }
        return LazyOptional.empty();
    }

    public int insertItem(ItemStack stack) {
        ItemStack s = this.insertItem(stack, false);
        return s.m_41613_();
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        if (this.getStoredPower() < (long)((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue()) {
            return stack;
        }
        ItemStack result = this.insertInternal(stack, simulate);
        this.consumeEnergy(((Integer)StorageScannerConfiguration.rfPerInsert.get()).intValue());
        return result;
    }

    public ItemStack insertInternal(ItemStack stack, boolean simulate) {
        ItemStack[] toInsert = new ItemStack[]{stack.m_41777_()};
        ServerPlayer fakePlayer = this.lazyPlayer.get();
        Iterator iterator = this.inventories.stream().filter(p -> this.isInputFromAuto((BlockPos)p) && !p.equals((Object)this.m_58899_()) && this.isRoutable((BlockPos)p) && this.getInputMatcher((BlockPos)p).test(stack)).filter(p -> !(this.f_58857_.m_7702_(p) instanceof CraftingManagerTileEntity)).filter(arg_0 -> this.lambda$insertInternal$48((Player)fakePlayer, arg_0)).map(this::getItemHandlerAt).filter(LazyOptional::isPresent).iterator();
        while (!toInsert[0].m_41619_() && iterator.hasNext()) {
            LazyOptional handler = (LazyOptional)iterator.next();
            handler.ifPresent(h -> {
                toInsert[0] = ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)toInsert[0], (boolean)simulate);
            });
        }
        return toInsert[0];
    }

    private ItemStack requestStackFromInv(BlockPos invPos, ItemStack requested, Integer[] todo, ItemStack outSlot) {
        BlockEntity tileEntity = this.f_58857_.m_7702_(invPos);
        if (tileEntity instanceof StorageScannerTileEntity) {
            return outSlot;
        }
        int size = InventoryTools.getInventorySize((BlockEntity)tileEntity);
        for (int i = 0; i < size; ++i) {
            ItemStack stack = ItemStackTools.getStack((BlockEntity)tileEntity, (int)i);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)requested, (ItemStack)stack)) continue;
            ItemStack extracted = ItemStackTools.extractItem((BlockEntity)tileEntity, (int)i, (int)todo[0]);
            Integer[] integerArray = todo;
            Integer.valueOf(integerArray[0] - extracted.m_41613_());
            if (outSlot.m_41619_()) {
                outSlot = extracted;
            } else {
                outSlot.m_41769_(extracted.m_41613_());
            }
            if (todo[0] == 0) break;
        }
        return outSlot;
    }

    @Nullable
    public List<ItemStack> requestIngredients(List<Ingredient> ingredients, Consumer<Ingredient> missingIngredientConsumer, boolean extract) {
        ArrayList<Ingredient> missing = new ArrayList<Ingredient>();
        for (Ingredient ingredient : ingredients) {
            ItemStack stack = this.requestItem((Predicate<ItemStack>)ingredient, true, 1, true);
            if (!stack.m_41619_() || ingredient.test(stack)) continue;
            missing.add(ingredient);
        }
        if (missing.isEmpty()) {
            if (extract) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (Ingredient ingredient : ingredients) {
                    ItemStack stack = this.requestItem((Predicate<ItemStack>)ingredient, false, 1, true);
                    stacks.add(stack);
                }
                return stacks;
            }
            return Collections.emptyList();
        }
        for (Ingredient ingredient : missing) {
            if (!this.getAllInventories().noneMatch(p -> {
                CraftingManagerTileEntity craftingManager;
                BlockEntity te = this.f_58857_.m_7702_(p);
                if (te instanceof CraftingManagerTileEntity && (craftingManager = (CraftingManagerTileEntity)te).canCraft(ingredient)) {
                    missingIngredientConsumer.accept(ingredient);
                    return true;
                }
                return false;
            })) continue;
            return null;
        }
        return Collections.emptyList();
    }

    public void requestCraft(BlockPos invPos, ItemStack requested, int amount, Player player) {
        int rf = (Integer)StorageScannerConfiguration.rfPerRequest.get();
        if (amount >= 0) {
            rf /= 10;
        }
        if (amount == -1) {
            amount = requested.m_41741_();
        }
        if (this.getStoredPower() < (long)rf) {
            return;
        }
        this.craftingSystem.requestCraft(requested, amount);
    }

    public void requestStack(BlockPos invPos, ItemStack requested, int amount, Player player) {
        int rf = (Integer)StorageScannerConfiguration.rfPerRequest.get();
        if (amount >= 0) {
            rf /= 10;
        }
        if (amount == -1) {
            amount = requested.m_41741_();
        }
        if (this.getStoredPower() < (long)rf) {
            return;
        }
        Integer[] todo = new Integer[]{amount};
        int finalAmount = amount;
        int finalRf = rf;
        ItemStack outSlot = this.items.getStackInSlot(1);
        if (!outSlot.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)outSlot, (ItemStack)requested)) {
                return;
            }
            if (outSlot.m_41613_() >= requested.m_41741_()) {
                return;
            }
            todo[0] = Math.min(todo[0], requested.m_41741_() - outSlot.m_41613_());
        }
        if (invPos.m_123342_() == -1) {
            ServerPlayer fakePlayer = this.lazyPlayer.get();
            Iterator iterator = this.inventories.stream().filter(p -> !(this.f_58857_.m_7702_(p) instanceof CraftingManagerTileEntity)).filter(arg_0 -> this.lambda$requestStack$52((Player)fakePlayer, arg_0)).filter(p -> this.isOutputFromGui((BlockPos)p) && this.isRoutable((BlockPos)p)).iterator();
            while (iterator.hasNext()) {
                BlockPos blockPos = (BlockPos)iterator.next();
                outSlot = this.requestStackFromInv(blockPos, requested, todo, outSlot);
                if (todo[0] != 0) continue;
                break;
            }
        } else if (this.isOutputFromGui(invPos)) {
            outSlot = this.requestStackFromInv(invPos, requested, todo, outSlot);
        }
        if (todo[0] == finalAmount) {
            return;
        }
        this.consumeEnergy(finalRf);
        this.items.setStackInSlot(1, outSlot);
        if (((Boolean)StorageScannerConfiguration.requestStraightToInventory.get()).booleanValue() && player.m_150109_().m_36054_(outSlot)) {
            this.items.setStackInSlot(1, ItemStack.f_41583_);
        }
    }

    private void addItemStack(List<ItemStack> stacks, Set<Item> foundItems, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        if (foundItems.contains(stack.m_41720_())) {
            for (ItemStack s : stacks) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
                s.m_41769_(stack.m_41613_());
                return;
            }
        }
        stacks.add(stack.m_41777_());
        foundItems.add(stack.m_41720_());
    }

    public void getInventoryForBlock(BlockPos cpos, List<ItemStack> stacks, List<ItemStack> craftable) {
        HashSet<Item> foundItems = new HashSet<Item>();
        this.lastSelectedInventory = cpos;
        if (cpos.m_123342_() == -1) {
            for (BlockPos blockPos : this.inventories) {
                if (!this.routable.contains(blockPos)) continue;
                this.addItemsFromInventory(blockPos, foundItems, stacks, craftable);
            }
        } else {
            this.addItemsFromInventory(cpos, foundItems, stacks, craftable);
        }
    }

    private void addItemsFromInventory(BlockPos cpos, Set<Item> foundItems, List<ItemStack> stacks, List<ItemStack> craftable) {
        BlockEntity tileEntity = this.f_58857_.m_7702_(cpos);
        if (tileEntity instanceof CraftingManagerTileEntity) {
            for (ItemStack stack : ((CraftingManagerTileEntity)tileEntity).getCraftables()) {
                this.addItemStack(craftable, foundItems, stack);
            }
        } else {
            StorageScannerTileEntity.getItemHandlerAt(tileEntity, null).ifPresent(h -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    this.addItemStack(stacks, foundItems, h.getStackInSlot(i));
                }
            });
        }
    }

    public SortingMode getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(SortingMode sortMode) {
        this.sortMode = sortMode;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tagCompound) {
        BlockPos c;
        CompoundTag tag;
        super.m_142466_(tagCompound);
        this.craftingSystem.read(tagCompound.m_128469_("CS"));
        ListTag list = tagCompound.m_128437_("inventories", 10);
        this.inventories.clear();
        this.craftingInventories = null;
        for (Tag inbt : list) {
            tag = (CompoundTag)inbt;
            c = BlockPosTools.read((CompoundTag)tag, (String)"c");
            this.inventories.add(c);
        }
        list = tagCompound.m_128437_("routable", 10);
        this.routable.clear();
        for (Tag inbt : list) {
            tag = (CompoundTag)inbt;
            c = BlockPosTools.read((CompoundTag)tag, (String)"c");
            this.routable.add(c);
        }
        list = tagCompound.m_128437_("fromxnet", 10);
        this.inventoriesFromXNet.clear();
        for (Tag inbt : list) {
            tag = (CompoundTag)inbt;
            c = BlockPosTools.read((CompoundTag)tag, (String)"c");
            this.inventoriesFromXNet.add(c);
        }
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        if (tagCompound.m_128441_("Info")) {
            CompoundTag infoTag = tagCompound.m_128469_("Info");
            if (infoTag.m_128441_("radius")) {
                this.radius = infoTag.m_128451_("radius");
            }
            if (infoTag.m_128441_("exportC")) {
                this.exportToCurrent = infoTag.m_128471_("exportC");
            }
            if (infoTag.m_128441_("wideview")) {
                this.openWideView = infoTag.m_128471_("wideview");
            }
            if (infoTag.m_128441_("grid")) {
                this.craftingGrid.readFromNBT(infoTag.m_128469_("grid"));
            }
            if (infoTag.m_128441_("sortMode")) {
                int m = infoTag.m_128451_("sortMode");
                this.sortMode = SortingMode.values()[m];
            }
        } else {
            this.openWideView = true;
            this.sortMode = SortingMode.NAME;
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        CompoundTag tag;
        super.m_183515_(tagCompound);
        tagCompound.m_128365_("CS", (Tag)this.craftingSystem.write());
        ListTag list = new ListTag();
        for (BlockPos c : this.inventories) {
            tag = BlockPosTools.write((BlockPos)c);
            list.add((Object)tag);
        }
        tagCompound.m_128365_("inventories", (Tag)list);
        list = new ListTag();
        for (BlockPos c : this.routable) {
            tag = BlockPosTools.write((BlockPos)c);
            list.add((Object)tag);
        }
        tagCompound.m_128365_("routable", (Tag)list);
        list = new ListTag();
        for (BlockPos c : this.inventoriesFromXNet) {
            tag = BlockPosTools.write((BlockPos)c);
            list.add((Object)tag);
        }
        tagCompound.m_128365_("fromxnet", (Tag)list);
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.m_128405_("radius", this.radius);
        infoTag.m_128379_("exportC", this.exportToCurrent);
        infoTag.m_128379_("wideview", this.openWideView);
        infoTag.m_128365_("grid", (Tag)this.craftingGrid.writeToNBT());
        infoTag.m_128405_("sortMode", this.sortMode.ordinal());
    }

    private void clearGrid() {
        CraftingGridInventory inventory = this.craftingGrid.getCraftingGridInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.m_6596_();
    }

    public boolean isDummy() {
        return this.dummyType != null;
    }

    public ResourceKey<Level> getDimension() {
        if (this.dummyType != null) {
            return this.dummyType;
        }
        return super.getDimension();
    }

    public BlockPos getCraftingGridContainerPos() {
        return this.m_58899_();
    }

    public CraftingGridProvider getCraftingGridProvider() {
        return this;
    }

    public BlockPos getStorageScannerPos() {
        return this.m_58899_();
    }

    public CraftingSystem getCraftingSystem() {
        return this.craftingSystem;
    }

    @Nonnull
    private IInformationScreenInfo createScreenInfo() {
        return new StorageScannerInformationScreenInfo(this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityInformationScreenInfo.INFORMATION_SCREEN_INFO_CAPABILITY) {
            return this.infoScreenInfo.cast();
        }
        return super.getCapability(cap, facing);
    }

    private /* synthetic */ boolean lambda$requestStack$52(Player fakePlayer, BlockPos p) {
        return this.canPlayerAccess(fakePlayer, p);
    }

    private /* synthetic */ boolean lambda$insertInternal$48(Player fakePlayer, BlockPos p) {
        return this.canPlayerAccess(fakePlayer, p);
    }

    private /* synthetic */ boolean lambda$requestItem$43(Player fakePlayer, BlockPos p) {
        return this.canPlayerAccess(fakePlayer, p);
    }

    private /* synthetic */ boolean lambda$requestItem$37(Player fakePlayer, BlockPos p) {
        return this.canPlayerAccess(fakePlayer, p);
    }
}

