/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.IItemKey;
import mcjty.rftoolsstorage.craftinggrid.IItemSource;
import mcjty.rftoolsstorage.craftinggrid.PacketCraftTestResultToClient;
import mcjty.rftoolsstorage.craftinggrid.PacketGridToClient;
import mcjty.rftoolsstorage.craftinggrid.RFCraftingRecipe;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkDirection;
import org.apache.commons.lang3.tuple.Pair;

public class StorageCraftingTools {
    @Nonnull
    private static List<Pair<ItemStack, Integer>> tryRecipe(Player player, RFCraftingRecipe craftingRecipe, int n, IItemSource itemSource) {
        int i;
        CraftingContainer workInventory = new CraftingContainer(new AbstractContainerMenu(null, -1){

            public boolean m_6875_(@Nonnull Player var1) {
                return false;
            }

            public ItemStack m_7648_(Player player, int slot) {
                return ItemStack.f_41583_;
            }
        }, 3, 3);
        Optional<CraftingRecipe> recipe = craftingRecipe.getCachedRecipe(player.m_20193_());
        List ingredients = (List)recipe.map(Recipe::m_7527_).orElseGet(() -> NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_));
        ArrayList<Pair> missing = new ArrayList<Pair>(9);
        for (i = 0; i < 9; ++i) {
            missing.add(Pair.of((Object)ItemStack.f_41583_, (Object)0));
        }
        for (i = 0; i < 9; ++i) {
            ItemStack stack;
            Ingredient ingredient;
            ItemStack[] stacks;
            if (i < ingredients.size() && (stacks = (ingredient = (Ingredient)ingredients.get(i)).m_43908_()).length > 0 && !(stack = stacks[0]).m_41619_()) {
                missing.set(i, Pair.of((Object)stack, (Object)(stack.m_41613_() * n)));
            }
            workInventory.m_6836_(i, ItemStack.f_41583_);
        }
        for (Pair<IItemKey, ItemStack> pair : itemSource.getItems()) {
            ItemStack input = (ItemStack)pair.getValue();
            int size = input.m_41613_();
            if (input.m_41619_()) continue;
            for (int i2 = 0; i2 < ingredients.size(); ++i2) {
                if ((Integer)((Pair)missing.get(i2)).getRight() <= 0 || !((Ingredient)ingredients.get(i2)).test(input)) continue;
                if (size > (Integer)((Pair)missing.get(i2)).getRight()) {
                    size -= ((Integer)((Pair)missing.get(i2)).getRight()).intValue();
                    missing.set(i2, Pair.of((Object)ItemStack.f_41583_, (Object)0));
                } else {
                    missing.set(i2, Pair.of((Object)((ItemStack)((Pair)missing.get(i2)).getLeft()), (Object)((Integer)((Pair)missing.get(i2)).getRight() - size)));
                    size = 0;
                }
                workInventory.m_6836_(i2, input.m_41777_());
            }
        }
        return missing.stream().filter(p -> (Integer)p.getRight() > 0).collect(Collectors.toList());
    }

    private static List<ItemStack> testAndConsumeCraftingItems(Player player, RFCraftingRecipe craftingRecipe, IItemSource itemSource) {
        CraftingContainer workInventory = new CraftingContainer(new AbstractContainerMenu(null, -1){

            public boolean m_6875_(@Nonnull Player var1) {
                return false;
            }

            public ItemStack m_7648_(Player player, int slot) {
                return ItemStack.f_41583_;
            }
        }, 3, 3);
        ArrayList undo = new ArrayList();
        ArrayList result = new ArrayList();
        Optional<CraftingRecipe> recipe = craftingRecipe.getCachedRecipe(player.m_20193_());
        return recipe.map(r -> {
            int w = 3;
            int h = 3;
            if (r instanceof ShapedRecipe) {
                w = ((ShapedRecipe)r).getRecipeWidth();
                h = ((ShapedRecipe)r).getRecipeHeight();
            }
            NonNullList ingredients = r.m_7527_();
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    ItemStack stack;
                    Ingredient ingredient;
                    ItemStack[] stacks;
                    int i = y * w + x;
                    int workIndex = y * 3 + x;
                    workInventory.m_6836_(workIndex, ItemStack.f_41583_);
                    if (i >= ingredients.size() || (stacks = (ingredient = (Ingredient)ingredients.get(i)).m_43908_()).length <= 0 || (stack = stacks[0]).m_41619_()) continue;
                    int count = stack.m_41613_();
                    count = StorageCraftingTools.findMatchingItems(workInventory, undo, workIndex, (Ingredient)ingredients.get(i), count, itemSource);
                    if (count <= 0) continue;
                    StorageCraftingTools.undo(player, itemSource, undo);
                    return Collections.emptyList();
                }
            }
            if (!r.m_5818_((Container)workInventory, player.m_20193_())) {
                result.clear();
                StorageCraftingTools.undo(player, itemSource, undo);
                return result;
            }
            ItemStack stack = r.m_5874_((Container)workInventory);
            if (!stack.m_41619_()) {
                result.add(stack);
                NonNullList remaining = r.m_7457_((Container)workInventory);
                for (ItemStack s : remaining) {
                    if (s.m_41619_()) continue;
                    result.add(s);
                }
            } else {
                result.clear();
                StorageCraftingTools.undo(player, itemSource, undo);
            }
            return result;
        }).orElse(result);
    }

    private static int findMatchingItems(CraftingContainer workInventory, List<Pair<IItemKey, ItemStack>> undo, int i, @Nonnull Ingredient stack, int count, IItemSource itemSource) {
        for (Pair<IItemKey, ItemStack> pair : itemSource.getItems()) {
            ItemStack input = (ItemStack)pair.getValue();
            if (!input.m_41619_() && stack.test(input)) {
                int ss = count;
                if (input.m_41613_() - ss < 0) {
                    ss = input.m_41613_();
                }
                IItemKey key = (IItemKey)pair.getKey();
                ItemStack copy = input.m_41777_();
                ItemStack actuallyExtracted = itemSource.decrStackSize(key, ss);
                if (!actuallyExtracted.m_41619_()) {
                    workInventory.m_6836_(i, copy);
                    count -= ss;
                    undo.add((Pair<IItemKey, ItemStack>)Pair.of((Object)key, (Object)actuallyExtracted));
                }
            }
            if (count != 0) continue;
            break;
        }
        return count;
    }

    private static void undo(Player player, IItemSource itemSource, List<Pair<IItemKey, ItemStack>> undo) {
        for (Pair<IItemKey, ItemStack> pair : undo) {
            int amountLeft;
            ItemStack stack = (ItemStack)pair.getValue();
            if (itemSource.insertStack((IItemKey)pair.getKey(), stack) || (amountLeft = itemSource.insertStackAnySlot((IItemKey)pair.getKey(), stack)) <= 0) continue;
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(amountLeft);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)copy);
        }
        player.f_36096_.m_38946_();
    }

    public static void craftItems(Player player, int nn, RFCraftingRecipe craftingRecipe, IItemSource itemSource) {
        Optional<CraftingRecipe> recipe = craftingRecipe.getCachedRecipe(player.m_20193_());
        if (!recipe.isPresent()) {
            return;
        }
        int[] n = new int[]{nn};
        recipe.ifPresent(r -> {
            ItemStack recipeResult = r.m_8043_();
            if (!recipeResult.m_41619_() && recipeResult.m_41613_() > 0) {
                if (n[0] == -1) {
                    n[0] = recipeResult.m_41741_();
                }
                int remainder = n[0] % recipeResult.m_41613_();
                n[0] = n[0] / recipeResult.m_41613_();
                if (remainder != 0) {
                    n[0] = n[0] + 1;
                }
                if (n[0] * recipeResult.m_41613_() > recipeResult.m_41741_()) {
                    n[0] = n[0] - 1;
                }
                for (int i = 0; i < n[0]; ++i) {
                    List<ItemStack> result = StorageCraftingTools.testAndConsumeCraftingItems(player, craftingRecipe, itemSource);
                    if (result.isEmpty()) {
                        return;
                    }
                    for (ItemStack stack : result) {
                        if (player.m_150109_().m_36054_(stack)) continue;
                        player.m_5552_(stack, 1.05f);
                    }
                }
            }
        });
    }

    @Nonnull
    public static List<Pair<ItemStack, Integer>> testCraftItems(Player player, int nn, RFCraftingRecipe craftingRecipe, IItemSource itemSource) {
        Optional<CraftingRecipe> recipe = craftingRecipe.getCachedRecipe(player.m_20193_());
        if (!recipe.isPresent()) {
            return Collections.emptyList();
        }
        int[] n = new int[]{nn};
        return recipe.map(r -> {
            ItemStack recipeResult = r.m_8043_();
            if (!recipeResult.m_41619_() && recipeResult.m_41613_() > 0) {
                if (n[0] == -1) {
                    n[0] = recipeResult.m_41741_();
                }
                int remainder = n[0] % recipeResult.m_41613_();
                n[0] = n[0] / recipeResult.m_41613_();
                if (remainder != 0) {
                    n[0] = n[0] + 1;
                }
                if (n[0] * recipeResult.m_41613_() > recipeResult.m_41741_()) {
                    n[0] = n[0] - 1;
                }
                return StorageCraftingTools.tryRecipe(player, craftingRecipe, n[0], itemSource);
            }
            return Collections.emptyList();
        }).orElse(Collections.emptyList());
    }

    public static void craftFromGrid(Player player, int count, boolean test, BlockPos pos, ResourceKey<Level> type) {
        List<Pair<ItemStack, Integer>> testResult = Collections.emptyList();
        BlockEntity te = LevelTools.getLevel((Level)player.m_20193_(), type).m_7702_(pos);
        if (te instanceof CraftingGridProvider) {
            CraftingGridProvider provider = (CraftingGridProvider)te;
            testResult = provider.craft(player, count, test);
        }
        if (!testResult.isEmpty()) {
            RFToolsStorageMessages.INSTANCE.sendTo((Object)new PacketCraftTestResultToClient(testResult), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void requestGridSync(Player player, BlockPos pos, ResourceKey<Level> type) {
        boolean dummy;
        ServerLevel world = LevelTools.getLevel((Level)player.m_20193_(), type);
        CraftingGridProvider provider = null;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof CraftingGridProvider && te instanceof GenericTileEntity) {
            provider = (CraftingGridProvider)te;
        }
        if (te instanceof StorageScannerTileEntity) {
            StorageScannerTileEntity scanner = (StorageScannerTileEntity)te;
            v0 = scanner.isDummy();
        } else {
            v0 = dummy = false;
        }
        if (provider != null) {
            RFToolsStorageMessages.INSTANCE.sendTo((Object)new PacketGridToClient(dummy ? null : pos, (ResourceKey<Level>)((GenericTileEntity)te).getDimension(), provider.getCraftingGrid()), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

