/*
 * Decompiled with CFR 0.152.
 */
package io.github.derringersmods.toomanyglyphs.common.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import io.github.derringersmods.toomanyglyphs.common.network.PacketRayEffect;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;

public class MethodRay
extends AbstractCastMethod {
    public static final MethodRay INSTANCE = new MethodRay(new ResourceLocation("toomanyglyphs", "glyph_ray"), "Ray");
    public ForgeConfigSpec.DoubleValue BASE_RANGE;
    public ForgeConfigSpec.DoubleValue BONUS_RANGE_PER_AUGMENT;

    public MethodRay(ResourceLocation tag, String description) {
        super(tag, description);
    }

    double getRange(SpellStats stats) {
        return (Double)this.BASE_RANGE.get() + (Double)this.BONUS_RANGE_PER_AUGMENT.get() * (double)stats.getBuffCount((AbstractAugment)AugmentAOE.INSTANCE);
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.BASE_RANGE = builder.comment("Base range in blocks").defineInRange("base_range", 16.0, 0.0, Double.MAX_VALUE);
        this.BONUS_RANGE_PER_AUGMENT = builder.comment("Bonus range per augment").defineInRange("bonus_range_per_augment", 16.0, 0.0, Double.MAX_VALUE);
    }

    public CastResolveType fireRay(Level world, LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver) {
        EntityHitResult entityTarget;
        Vec3 toPoint;
        int sensitivity = stats.getBuffCount((AbstractAugment)AugmentSensitive.INSTANCE);
        double range = this.getRange(stats);
        Vec3 fromPoint = shooter.m_20299_(1.0f);
        ClipContext rayTraceContext = new ClipContext(fromPoint, toPoint = fromPoint.m_82549_(shooter.m_20252_(1.0f).m_82490_(range)), sensitivity >= 1 ? ClipContext.Block.OUTLINE : ClipContext.Block.COLLIDER, sensitivity >= 2 ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)shooter);
        BlockHitResult blockTarget = world.m_45547_(rayTraceContext);
        if (blockTarget.m_6662_() != HitResult.Type.MISS) {
            BlockPos pos = blockTarget.m_82425_();
            Vec3 blockCenter = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            double distance = fromPoint.m_82554_(blockCenter) + 0.5;
            toPoint = fromPoint.m_82549_(shooter.m_20252_(1.0f).m_82490_(Math.min(range, distance)));
        }
        if ((entityTarget = ProjectileUtil.m_37304_((Level)world, (Entity)shooter, (Vec3)fromPoint, (Vec3)toPoint, (AABB)new AABB(fromPoint, toPoint).m_82400_(1.5), e -> e != shooter && e.m_6084_() && e instanceof LivingEntity)) != null) {
            resolver.expendMana();
            resolver.onResolveEffect(world, (HitResult)entityTarget);
            Vec3 hitPoint = MethodRay.findNearestPointOnLine(fromPoint, toPoint, entityTarget.m_82450_());
            PacketRayEffect.send(world, spellContext, fromPoint, hitPoint);
            return CastResolveType.SUCCESS;
        }
        if (blockTarget.m_6662_() == HitResult.Type.BLOCK) {
            resolver.expendMana();
            resolver.onResolveEffect(world, (HitResult)blockTarget);
            PacketRayEffect.send(world, spellContext, fromPoint, blockTarget.m_82450_());
            return CastResolveType.SUCCESS;
        }
        if (blockTarget.m_6662_() == HitResult.Type.MISS && sensitivity >= 2) {
            Vec3 approximateNormal = fromPoint.m_82546_(toPoint).m_82541_();
            blockTarget = new BlockHitResult(toPoint, Direction.m_122366_((double)approximateNormal.f_82479_, (double)approximateNormal.f_82480_, (double)approximateNormal.f_82481_), new BlockPos(toPoint), true);
            resolver.expendMana();
            resolver.onResolveEffect(world, (HitResult)blockTarget);
            PacketRayEffect.send(world, spellContext, fromPoint, blockTarget.m_82450_());
            return CastResolveType.SUCCESS;
        }
        PacketRayEffect.send(world, spellContext, fromPoint, toPoint);
        return CastResolveType.FAILURE;
    }

    @Nonnull
    private static Vec3 findNearestPointOnLine(@Nonnull Vec3 fromPoint, @Nonnull Vec3 toPoint, @Nonnull Vec3 hitPoint) {
        Vec3 u = toPoint.m_82546_(fromPoint);
        Vec3 pq = hitPoint.m_82546_(fromPoint);
        Vec3 w2 = pq.m_82546_(u.m_82490_(pq.m_82526_(u) / u.m_82556_()));
        return hitPoint.m_82546_(w2);
    }

    public CastResolveType onCast(@Nullable ItemStack itemStack, LivingEntity shooter, Level world, SpellStats stats, SpellContext spellContext, SpellResolver spellResolver) {
        return this.fireRay(world, shooter, stats, spellContext, spellResolver);
    }

    public CastResolveType onCastOnBlock(UseOnContext itemUseContext, SpellStats stats, SpellContext spellContext, SpellResolver spellResolver) {
        return this.fireRay(itemUseContext.m_43725_(), (LivingEntity)itemUseContext.m_43723_(), stats, spellContext, spellResolver);
    }

    public CastResolveType onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver spellResolver) {
        return this.fireRay(shooter.f_19853_, shooter, stats, spellContext, spellResolver);
    }

    public CastResolveType onCastOnEntity(@Nullable ItemStack itemStack, LivingEntity shooter, Entity target, InteractionHand hand, SpellStats stats, SpellContext spellContext, SpellResolver spellResolver) {
        return this.fireRay(shooter.f_19853_, shooter, stats, spellContext, spellResolver);
    }

    public int getDefaultManaCost() {
        return 10;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.setOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentSensitive.INSTANCE});
    }

    protected Map<ResourceLocation, Integer> getDefaultAugmentLimits(Map<ResourceLocation, Integer> result) {
        result.put(AugmentSensitive.INSTANCE.getRegistryName(), 2);
        return result;
    }
}

