/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.mobenchant;

import baguchan.enchantwithmob.EnchantWithMob;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.message.SoulParticleMessage;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="enchantwithmob")
public class SoulStealMobEnchant
extends MobEnchant {
    public SoulStealMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return 10 + (enchantmentLevel - 1) * 10;
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return this.getMinEnchantability(enchantmentLevel) + 30;
    }

    @SubscribeEvent
    public static void onLivingDeathAndStealEvent(LivingDeathEvent event) {
        LivingEntity attacker;
        LivingEntity entity = event.getEntity();
        DamageSource damageSource = event.getSource();
        if (damageSource != null && damageSource.m_7640_() instanceof LivingEntity && (attacker = (LivingEntity)damageSource.m_7640_()) instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)attacker;
            int enchantLevel = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.SOUL_STEAL.get());
            if (cap.getEnchantCap().hasEnchant() && enchantLevel > 0 && !attacker.m_21023_(MobEffects.f_19617_)) {
                if (attacker.m_6103_() < 6.0f) {
                    attacker.m_7911_(Mth.m_14036_((float)(attacker.m_6103_() + (float)enchantLevel), (float)0.0f, (float)6.0f));
                }
                if (!entity.f_19853_.m_5776_()) {
                    SoulParticleMessage message = new SoulParticleMessage((Entity)entity);
                    EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
                }
            }
        }
    }

    @Override
    public boolean isTresureEnchant() {
        return true;
    }

    @Override
    public boolean isOnlyChest() {
        return true;
    }
}

