/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.capability.ItemMobEnchantCapability;
import baguchan.enchantwithmob.capability.MobEnchantCapability;
import baguchan.enchantwithmob.capability.MobEnchantHandler;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="enchantwithmob")
public class CommonEventHandler {
    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ItemMobEnchantCapability.class);
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Projectile) {
            event.addCapability(new ResourceLocation("enchantwithmob", "item_mob_enchant"), (ICapabilityProvider)new ItemMobEnchantCapability());
        }
    }

    @SubscribeEvent
    public static void onEnderDragonSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)entity;
            entity = event.getEntity();
            if (entity instanceof EnderDragon) {
                EnderDragon livingEntity = (EnderDragon)entity;
                Level world = event.getLevel();
                if (!cap.getEnchantCap().hasEnchant()) {
                    float difficultScale;
                    int i;
                    if (CommonEventHandler.isSpawnAlwayEnchantableAncientEntity((Entity)livingEntity)) {
                        i = 0;
                        difficultScale = world.m_6436_(livingEntity.m_20183_()).m_19056_() - 0.2f;
                        switch (world.m_46791_()) {
                            case EASY: {
                                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(10)) * difficultScale), (float)1.0f, (float)30.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, true);
                                break;
                            }
                            case NORMAL: {
                                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(15)) * difficultScale), (float)1.0f, (float)60.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, true);
                                break;
                            }
                            case HARD: {
                                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(20)) * difficultScale), (float)1.0f, (float)100.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, true);
                            }
                        }
                        livingEntity.m_21153_(livingEntity.m_21233_());
                    }
                    if (CommonEventHandler.isSpawnAlwayEnchantableEntity((Entity)livingEntity)) {
                        i = 0;
                        difficultScale = world.m_6436_(livingEntity.m_20183_()).m_19056_() - 0.2f;
                        switch (world.m_46791_()) {
                            case EASY: {
                                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)20.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false);
                                break;
                            }
                            case NORMAL: {
                                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)40.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false);
                                break;
                            }
                            case HARD: {
                                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(10)) * difficultScale), (float)1.0f, (float)50.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false);
                            }
                        }
                        livingEntity.m_21153_(livingEntity.m_21233_());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSpawnEntity(LivingSpawnEvent.SpecialSpawn event) {
        Mob mob = event.getEntity();
        if (mob instanceof IEnchantCap) {
            float difficultScale;
            int i;
            IEnchantCap cap = (IEnchantCap)mob;
            LevelAccessor world = event.getLevel();
            Mob livingEntity = event.getEntity();
            if (CommonEventHandler.isSpawnAlwayEnchantableAncientEntity((Entity)livingEntity)) {
                i = 0;
                difficultScale = world.m_6436_(livingEntity.m_20183_()).m_19056_() - 0.2f;
                switch (world.m_46791_()) {
                    case EASY: {
                        i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(10)) * difficultScale), (float)1.0f, (float)30.0f);
                        MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, true);
                        break;
                    }
                    case NORMAL: {
                        i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(15)) * difficultScale), (float)1.0f, (float)60.0f);
                        MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, true);
                        break;
                    }
                    case HARD: {
                        i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(20)) * difficultScale), (float)1.0f, (float)100.0f);
                        MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, true);
                    }
                }
                livingEntity.m_21153_(livingEntity.m_21233_());
                cap.getEnchantCap().sync((LivingEntity)livingEntity);
            }
            if (CommonEventHandler.isSpawnAlwayEnchantableEntity((Entity)livingEntity)) {
                i = 0;
                difficultScale = world.m_6436_(livingEntity.m_20183_()).m_19056_() - 0.2f;
                switch (world.m_46791_()) {
                    case EASY: {
                        i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)20.0f);
                        MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false);
                        break;
                    }
                    case NORMAL: {
                        i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)40.0f);
                        MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false);
                        break;
                    }
                    case HARD: {
                        i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(10)) * difficultScale), (float)1.0f, (float)50.0f);
                        MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false);
                    }
                }
                livingEntity.m_21153_(livingEntity.m_21233_());
                cap.getEnchantCap().sync((LivingEntity)livingEntity);
            }
            if (((Boolean)EnchantConfig.COMMON.naturalSpawnEnchantedMob.get()).booleanValue() && CommonEventHandler.isSpawnEnchantableEntity((Entity)event.getEntity()) && (!(livingEntity instanceof Animal) && !(livingEntity instanceof WaterAnimal) || ((Boolean)EnchantConfig.COMMON.spawnEnchantedAnimal.get()).booleanValue()) && event.getSpawnReason() != MobSpawnType.BREEDING && event.getSpawnReason() != MobSpawnType.CONVERSION && event.getSpawnReason() != MobSpawnType.STRUCTURE && event.getSpawnReason() != MobSpawnType.MOB_SUMMONED && (double)world.m_213780_().m_188501_() < (Double)EnchantConfig.COMMON.difficultyBasePercent.get() * (double)world.m_46791_().m_19028_() + (double)world.m_6436_(livingEntity.m_20183_()).m_19056_() * (Double)EnchantConfig.COMMON.effectiveBasePercent.get() && !world.m_5776_()) {
                i = 0;
                difficultScale = world.m_6436_(livingEntity.m_20183_()).m_19056_() - 0.2f;
                switch (world.m_46791_()) {
                    case EASY: {
                        i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)20.0f);
                        MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false);
                        break;
                    }
                    case NORMAL: {
                        i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)40.0f);
                        MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false);
                        break;
                    }
                    case HARD: {
                        i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(10)) * difficultScale), (float)1.0f, (float)50.0f);
                        MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.m_213780_(), i, true, false);
                    }
                }
                livingEntity.m_21153_(livingEntity.m_21233_());
                cap.getEnchantCap().sync((LivingEntity)livingEntity);
            }
        }
    }

    private static boolean isSpawnAlwayEnchantableEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && ((List)EnchantConfig.COMMON.ALWAY_ENCHANTABLE_MOBS.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
    }

    private static boolean isSpawnAlwayEnchantableAncientEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && ((List)EnchantConfig.COMMON.ALWAY_ENCHANTABLE_ANCIENT_MOBS.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
    }

    private static boolean isSpawnEnchantableEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && !((List)EnchantConfig.COMMON.ENCHANT_ON_SPAWN_EXCLUSION_MOBS.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
    }

    @SubscribeEvent
    public static void onUpdateEnchanted(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)livingEntity;
            for (MobEnchantHandler enchantHandler : cap.getEnchantCap().getMobEnchants()) {
                enchantHandler.getMobEnchant().tick(livingEntity, enchantHandler.getEnchantLevel());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        LivingEntity attacker;
        LivingEntity livingEntity = event.getEntity();
        if (event.getSource().m_7639_() instanceof LivingEntity && (attacker = (LivingEntity)event.getSource().m_7639_()) instanceof IEnchantCap) {
            int i;
            IEnchantCap cap = (IEnchantCap)attacker;
            if (cap.getEnchantCap().hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.STRONG.get())) {
                if (event.getSource().m_7639_() != null && event.getSource().m_7639_() instanceof SnowGolem && event.getAmount() == 0.0f) {
                    event.setAmount(CommonEventHandler.getDamageAddition(1.0f, cap.getEnchantCap()));
                } else if (event.getAmount() > 0.0f) {
                    event.setAmount(CommonEventHandler.getDamageAddition(event.getAmount(), cap.getEnchantCap()));
                }
            }
            if (cap.getEnchantCap().hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.POISON.get())) {
                i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.POISON.get());
                if (event.getAmount() > 0.0f && attacker.m_217043_().m_188501_() < (float)i * 0.125f) {
                    livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60 * i, 0), (Entity)attacker);
                }
            }
            if (cap.getEnchantCap().hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.THORN.get())) {
                i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.THORN.get());
                if (event.getSource().m_7640_() == attacker && !event.getSource().m_19372_() && livingEntity.m_217043_().m_188501_() < (float)i * 0.1f) {
                    attacker.m_6469_(DamageSource.m_19335_((Entity)livingEntity), CommonEventHandler.getThornDamage(event.getAmount(), cap.getEnchantCap()));
                }
            }
        }
        if (livingEntity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)livingEntity;
            if (event.getSource() != DamageSource.f_19313_ && cap.getEnchantCap().hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.PROTECTION.get())) {
                event.setAmount(CommonEventHandler.getDamageReduction(event.getAmount(), cap.getEnchantCap()));
            }
            event.setAmount(CommonEventHandler.getBonusMobEnchantDamageReduction(event.getAmount(), cap.getEnchantCap()));
        }
    }

    public static float getDamageAddition(float damage, MobEnchantCapability cap) {
        int level = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.STRONG.get());
        if (level > 0) {
            damage += 1.0f + (float)Math.max(0, level - 1) * 1.0f;
        }
        return damage;
    }

    public static float getDamageReduction(float damage, MobEnchantCapability cap) {
        int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.PROTECTION.get());
        if (i > 0) {
            damage = (float)((double)damage - (double)Mth.m_14107_((double)((double)damage * (double)((float)i * 0.15f))));
        }
        return damage;
    }

    public static float getBonusMobEnchantDamageReduction(float damage, MobEnchantCapability cap) {
        int i = cap.getMobEnchants().size();
        if (i > 0) {
            damage = (float)((double)damage - (double)Mth.m_14107_((double)((double)damage * (double)((float)i * 0.05f))));
        }
        return damage;
    }

    public static float getThornDamage(float damage, MobEnchantCapability cap) {
        int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.THORN.get());
        if (i > 0) {
            damage = Mth.m_14107_((double)((double)damage * (double)((float)i * 0.15f)));
        }
        return damage;
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.EntityInteract event) {
        IEnchantCap cap;
        LivingEntity target;
        ItemStack stack = event.getItemStack();
        Entity entityTarget = event.getTarget();
        if (stack.m_41720_() == ModItems.MOB_ENCHANT_BOOK.get() && !event.getEntity().m_36335_().m_41519_(stack.m_41720_()) && entityTarget instanceof LivingEntity) {
            target = (LivingEntity)entityTarget;
            if (MobEnchantUtils.hasMobEnchant(stack) && target instanceof IEnchantCap) {
                cap = (IEnchantCap)target;
                boolean[] flag = new boolean[]{false};
                flag[0] = MobEnchantUtils.addItemMobEnchantToEntity(stack, target, cap);
                if (flag[0]) {
                    event.getEntity().m_5496_(SoundEvents.f_11887_, 1.0f, 1.0f);
                    stack.m_41622_(1, (LivingEntity)event.getEntity(), entity -> entity.m_21190_(event.getHand()));
                    event.getEntity().m_36335_().m_41524_(stack.m_41720_(), 60);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                } else {
                    event.getEntity().m_5661_((Component)Component.m_237115_((String)"enchantwithmob.cannot.enchant"), true);
                    event.getEntity().m_36335_().m_41524_(stack.m_41720_(), 20);
                    event.setCancellationResult(InteractionResult.FAIL);
                    event.setCanceled(true);
                }
            }
        }
        if (stack.m_41720_() == ModItems.MOB_UNENCHANT_BOOK.get() && !event.getEntity().m_36335_().m_41519_(stack.m_41720_()) && entityTarget instanceof LivingEntity && (target = (LivingEntity)entityTarget) instanceof IEnchantCap) {
            cap = (IEnchantCap)target;
            MobEnchantUtils.removeMobEnchantToEntity(target, cap);
            event.getEntity().m_5496_(SoundEvents.f_11887_, 1.0f, 1.0f);
            stack.m_41622_(1, (LivingEntity)event.getEntity(), entity -> entity.m_21190_(event.getHand()));
            event.getEntity().m_36335_().m_41524_(stack.m_41720_(), 80);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack stack1 = event.getLeft();
        ItemStack stack2 = event.getRight();
        if (stack1.m_41720_() == ModItems.MOB_ENCHANT_BOOK.get() && stack2.m_41720_() == ModItems.MOB_ENCHANT_BOOK.get()) {
            Map<MobEnchant, Integer> map = MobEnchantUtils.getEnchantments(stack1);
            Map<MobEnchant, Integer> map1 = MobEnchantUtils.getEnchantments(stack2);
            boolean flag2 = false;
            boolean flag3 = false;
            for (MobEnchant enchantment1 : map1.keySet()) {
                int j2;
                if (enchantment1 == null) continue;
                int i2 = map.getOrDefault(enchantment1, 0);
                j2 = i2 == (j2 = map1.get(enchantment1).intValue()) ? j2 + 1 : Math.max(j2, i2);
                boolean flag1 = true;
                for (MobEnchant enchantment : map.keySet()) {
                    if (enchantment == enchantment1 || enchantment1.isCompatibleWith(enchantment)) continue;
                    flag1 = false;
                }
                if (!flag1) {
                    flag3 = true;
                    continue;
                }
                flag2 = true;
                if (j2 > enchantment1.getMaxLevel()) {
                    j2 = enchantment1.getMaxLevel();
                }
                map.put(enchantment1, j2);
                int k3 = 0;
                switch (enchantment1.getRarity()) {
                    case COMMON: {
                        k3 = 1;
                        break;
                    }
                    case UNCOMMON: {
                        k3 = 2;
                        break;
                    }
                    case RARE: {
                        k3 = 4;
                        break;
                    }
                    case VERY_RARE: {
                        k3 = 8;
                    }
                }
            }
            if (!stack1.m_41619_()) {
                int k2 = stack1.m_41610_();
                if (!stack2.m_41619_() && k2 < stack2.m_41610_()) {
                    k2 = stack2.m_41610_();
                }
                ItemStack stack3 = new ItemStack((ItemLike)stack1.m_41720_());
                MobEnchantUtils.setEnchantments(map, stack3);
                stack3.m_41742_(4 + k2);
                event.setOutput(stack3);
                event.setCost(4 + k2);
                event.setMaterialCost(1);
            }
        }
    }

    @SubscribeEvent
    public static void onExpDropped(LivingExperienceDropEvent event) {
        IEnchantCap cap;
        LivingEntity entity = event.getEntity();
        if (entity instanceof IEnchantCap && (cap = (IEnchantCap)entity).getEnchantCap().hasEnchant()) {
            if (cap.getEnchantCap().isAncient()) {
                event.setDroppedExperience(event.getDroppedExperience() + MobEnchantUtils.getExperienceFromMob(cap) * 5);
            } else {
                event.setDroppedExperience(event.getDroppedExperience() + MobEnchantUtils.getExperienceFromMob(cap));
            }
        }
    }
}

