/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class SolidifyRecipe
implements Recipe<Container> {
    private final Ingredient mould;
    private final ItemStack result;
    private final int fluidAmount;
    private final ResourceLocation id;
    public static final String NAME = "solidify";

    public SolidifyRecipe(ResourceLocation id, Ingredient mould, ItemStack result, int fluidAmount) {
        this.id = id;
        this.mould = mould;
        this.result = result;
        this.fluidAmount = fluidAmount;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return false;
    }

    public boolean matches(ItemStack input) {
        return this.mould.test(input);
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public Ingredient getMould() {
        return this.mould;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv) {
        return this.result.m_41777_();
    }

    public ItemStack getResult() {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.result;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MobGrindingUtils.SOLIDIFIER_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)MobGrindingUtils.SOLIDIFIER_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<SolidifyRecipe> {
        @Nonnull
        public SolidifyRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            ItemStack result = new ItemStack((ItemLike)GsonHelper.m_13909_((JsonObject)json.get("result").getAsJsonObject(), (String)"item"));
            int fluidAmount = json.get("fluidAmount").getAsInt();
            return new SolidifyRecipe(recipeId, ingredient, result, fluidAmount);
        }

        public SolidifyRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            Ingredient mould = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            int fluidAmount = buffer.readInt();
            return new SolidifyRecipe(recipeId, mould, result, fluidAmount);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, SolidifyRecipe recipe) {
            recipe.mould.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
            buffer.writeInt(recipe.fluidAmount);
        }
    }

    public static class DataRecipe
    implements FinishedRecipe {
        private final Ingredient mould;
        private final ItemStack result;
        private final int fluidAmount;
        private final ResourceLocation id;

        public DataRecipe(ResourceLocation id, Ingredient mould, ItemStack result, int fluidAmount) {
            this.mould = mould;
            this.result = result;
            this.fluidAmount = fluidAmount;
            this.id = id;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.mould.m_43942_());
            json.addProperty("fluidAmount", (Number)this.fluidAmount);
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_())).toString());
            json.add("result", (JsonElement)resultJson);
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)MobGrindingUtils.SOLIDIFIER_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

