/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.client.widgets;

import appeng.client.gui.widgets.ITooltip;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.requester.status.RequestStatus;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;

public class StatusDisplay
extends AbstractWidget
implements ITooltip {
    private static final int WIDTH = 118;
    private static final int HEIGHT = 2;
    private final BooleanSupplier isInactive;
    private RequestStatus status = RequestStatus.IDLE;

    StatusDisplay(int x, int y, BooleanSupplier isInactive) {
        super(x, y, 118, 2, (Component)Component.m_237119_());
        this.isInactive = isInactive;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }

    public void m_6303_(PoseStack poseStack, int mX, int mY, float partialTick) {
        StatusDisplay.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)Utils.fillColorAlpha(this.getStatusColor()));
    }

    protected boolean m_7972_(int button) {
        return false;
    }

    private ChatFormatting getStatusColor(RequestStatus requestStatus) {
        return switch (requestStatus) {
            case RequestStatus.IDLE -> ChatFormatting.DARK_GREEN;
            case RequestStatus.LINK -> ChatFormatting.YELLOW;
            case RequestStatus.EXPORT -> ChatFormatting.DARK_PURPLE;
            default -> throw new IllegalStateException("Impossible client state: " + requestStatus);
        };
    }

    public List<Component> getTooltipMessage() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Utils.translate("tooltip", "status", new Object[0]));
        if (Screen.m_96638_()) {
            tooltip.addAll(List.of(Component.m_237113_((String)" "), Utils.translate("tooltip", RequestStatus.IDLE.toString().toLowerCase(), new Object[0]).m_130940_(this.getStatusColor(RequestStatus.IDLE)), Utils.translate("tooltip", Utils.f("{}_desc", RequestStatus.IDLE.toString().toLowerCase()), new Object[0]), Component.m_237113_((String)" "), Utils.translate("tooltip", RequestStatus.LINK.toString().toLowerCase(), new Object[0]).m_130940_(this.getStatusColor(RequestStatus.LINK)), Utils.translate("tooltip", Utils.f("{}_desc", RequestStatus.LINK.toString().toLowerCase()), new Object[0]), Component.m_237113_((String)" "), Utils.translate("tooltip", RequestStatus.EXPORT.toString().toLowerCase(), new Object[0]).m_130940_(this.getStatusColor(RequestStatus.EXPORT)), Utils.translate("tooltip", Utils.f("{}_desc", RequestStatus.EXPORT.toString().toLowerCase()), new Object[0])));
        } else {
            Utils.addShiftInfoTooltip(tooltip);
        }
        return tooltip;
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_);
    }

    public boolean isTooltipAreaVisible() {
        return this.f_93624_;
    }

    private ChatFormatting getStatusColor() {
        if (this.isInactive.getAsBoolean()) {
            return ChatFormatting.DARK_GRAY;
        }
        return this.getStatusColor(this.status);
    }

    void setStatus(RequestStatus status) {
        this.status = status;
    }
}

