/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.logic.entityblocking;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.village.VillageSiegeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.ModCaps;
import net.xalcon.torchmaster.common.logic.entityblocking.LightsRegistryCapability;

@Mod.EventBusSubscriber(modid="torchmaster")
public class EntityBlockingEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        boolean log = (Boolean)TorchmasterConfig.GENERAL.logSpawnChecks.get();
        if (log) {
            Torchmaster.Log.debug("CheckSpawn - IsSpawner: {}, Reason: {}, Type: {}, Pos: {}/{}/{}", (Object)event.isSpawner(), (Object)event.getSpawnReason(), (Object)EntityType.m_20613_((EntityType)event.getEntity().m_6095_()), (Object)event.getX(), (Object)event.getY(), (Object)event.getZ());
        }
        if (!((Boolean)TorchmasterConfig.GENERAL.aggressiveSpawnChecks.get()).booleanValue() && event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (((Boolean)TorchmasterConfig.GENERAL.blockOnlyNaturalSpawns.get()).booleanValue() && event.isSpawner()) {
            return;
        }
        Mob entity = event.getEntity();
        Level world = entity.m_20193_();
        BlockPos pos = new BlockPos(event.getX(), event.getY(), event.getZ());
        world.getCapability(ModCaps.TEB_REGISTRY).ifPresent(reg -> {
            if (reg.shouldBlockEntity((Entity)entity, pos)) {
                event.setResult(Event.Result.DENY);
                if (log) {
                    Torchmaster.Log.debug("Blocking spawn of {}", (Object)EntityType.m_20613_((EntityType)event.getEntity().m_6095_()));
                }
            } else if (log) {
                Torchmaster.Log.debug("Allowed spawn of {}", (Object)EntityType.m_20613_((EntityType)event.getEntity().m_6095_()));
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onVillageSiegeEvent(VillageSiegeEvent event) {
        if (!((Boolean)TorchmasterConfig.GENERAL.blockVillageSieges.get()).booleanValue()) {
            return;
        }
        boolean log = (Boolean)TorchmasterConfig.GENERAL.logSpawnChecks.get();
        if (log) {
            Torchmaster.Log.debug("VillageSiegeEvent - Pos: {}", (Object)event.getAttemptedSpawnPos());
        }
        if (!((Boolean)TorchmasterConfig.GENERAL.aggressiveSpawnChecks.get()).booleanValue() && event.getResult() == Event.Result.ALLOW) {
            return;
        }
        Vec3 vec = event.getAttemptedSpawnPos();
        BlockPos pos = new BlockPos(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        Level level = event.getLevel();
        level.getCapability(ModCaps.TEB_REGISTRY).ifPresent(reg -> {
            if (reg.shouldBlockVillageSiege(pos)) {
                event.setResult(Event.Result.DENY);
                if (log) {
                    Torchmaster.Log.debug("Blocking village siege @ {}", (Object)pos);
                }
            } else if (log) {
                Torchmaster.Log.debug("Allowed village siege @ {}", (Object)pos);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDoSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        boolean log = (Boolean)TorchmasterConfig.GENERAL.logSpawnChecks.get();
        if (log) {
            Torchmaster.Log.debug("DoSpecialSpawn - Reason: {}, Type: {}, Pos: {}/{}/{}", (Object)event.getSpawnReason(), (Object)EntityType.m_20613_((EntityType)event.getEntity().m_6095_()), (Object)event.getX(), (Object)event.getY(), (Object)event.getZ());
        }
        if (!((Boolean)TorchmasterConfig.GENERAL.aggressiveSpawnChecks.get()).booleanValue() && event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (((Boolean)TorchmasterConfig.GENERAL.blockOnlyNaturalSpawns.get()).booleanValue() && event.getSpawnReason() == MobSpawnType.SPAWNER) {
            return;
        }
        if (event.getSpawnReason() != MobSpawnType.NATURAL && event.getSpawnReason() != MobSpawnType.STRUCTURE) {
            return;
        }
        Mob entity = event.getEntity();
        Level world = entity.m_20193_();
        BlockPos pos = new BlockPos(event.getX(), event.getY(), event.getZ());
        world.getCapability(ModCaps.TEB_REGISTRY).ifPresent(reg -> {
            if (reg.shouldBlockEntity((Entity)entity, pos)) {
                event.setResult(Event.Result.DENY);
                if (log) {
                    Torchmaster.Log.debug("Blocking spawn of {}", (Object)EntityType.m_20613_((EntityType)event.getEntity().m_6095_()));
                }
            } else if (log) {
                Torchmaster.Log.debug("Allowed spawn of {}", (Object)EntityType.m_20613_((EntityType)event.getEntity().m_6095_()));
            }
        });
    }

    @SubscribeEvent
    public static void onWorldAttachCapabilityEvent(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(new ResourceLocation("torchmaster", "registry"), (ICapabilityProvider)new LightsRegistryCapability());
    }

    @SubscribeEvent
    public static void onGlobalTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            if (Torchmaster.server == null) {
                return;
            }
            for (ServerLevel level : Torchmaster.server.m_129785_()) {
                level.m_46473_().m_6180_("torchmaster_" + level.m_46472_().m_211136_());
                level.getCapability(ModCaps.TEB_REGISTRY).ifPresent(reg -> reg.onGlobalTick((Level)level));
                level.m_46473_().m_7238_();
            }
        }
    }
}

