/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.placementhandlers.main;

import com.ldtteam.structurize.blocks.interfaces.ILeveledBlueprintAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.ISurvivalBlueprintHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.network.messages.client.OpenDecoWindowMessage;
import com.minecolonies.coremod.util.AdvancementUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class SurvivalHandler
implements ISurvivalBlueprintHandler {
    public String getId() {
        return "minecolonies";
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)"com.minecolonies.coremod.blueprint.placement");
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canHandle(Blueprint blueprint, ClientLevel clientLevel, Player player, BlockPos blockPos, PlacementSettings placementSettings) {
        if (blueprint.getBlockState(blueprint.getPrimaryBlockOffset()).m_60734_() instanceof BlockHutTownHall) {
            return true;
        }
        IColonyView colonyView = IColonyManager.getInstance().getClosestColonyView((Level)clientLevel, blockPos);
        if (colonyView == null) {
            return false;
        }
        if (!colonyView.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
            return false;
        }
        return colonyView.isCoordInColony((Level)clientLevel, blockPos);
    }

    public void handle(Blueprint blueprint, String packName, String blueprintPath, boolean clientPack, Level world, Player player, BlockPos blockPos, PlacementSettings placementSettings) {
        if (blueprint == null) {
            MessageUtils.format("com.minecolonies.coremod.structures.nocustomhuts", new Object[0]).sendTo(player);
            SoundUtils.playErrorSound(player, player.m_20183_());
            return;
        }
        blueprint.rotateWithMirror(placementSettings.rotation, placementSettings.mirror == Mirror.NONE ? Mirror.NONE : Mirror.FRONT_BACK, world);
        BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
        if (anchor.m_60734_() instanceof AbstractBlockHut) {
            if (clientPack || !StructurePacks.hasPack((String)packName)) {
                MessageUtils.format("com.minecolonies.coremod.structures.buildingmissing", new Object[0]).sendTo(player);
                SoundUtils.playErrorSound(player, player.m_20183_());
                return;
            }
            ItemStack stack = new ItemStack((ItemLike)anchor.m_60734_());
            if (anchor.m_60734_() != null && EventHandler.onBlockHutPlaced(world, player, anchor.m_60734_(), blockPos)) {
                int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.m_150109_()), anchor.m_60734_());
                if (slot == -1 && !player.m_7500_()) {
                    SoundUtils.playErrorSound(player, player.m_20183_());
                    return;
                }
                IColony tempColony = IColonyManager.getInstance().getClosestColony(world, blockPos);
                if (!(tempColony == null || tempColony.getPermissions().hasPermission(player, Action.MANAGE_HUTS) || anchor.m_60734_() instanceof BlockHutTownHall && IColonyManager.getInstance().isFarEnoughFromColonies(world, blockPos))) {
                    SoundUtils.playErrorSound(player, player.m_20183_());
                    return;
                }
                ItemStack inventoryStack = slot == -1 ? stack : player.m_150109_().m_8020_(slot);
                CompoundTag compound = inventoryStack.m_41783_();
                if (tempColony != null && compound != null && compound.m_128441_("colony") && tempColony.getID() != compound.m_128451_("colony")) {
                    MessageUtils.format("com.minecolonies.coremod.gui.buildtool.wrongcolony", compound.m_128451_("colony")).sendTo(player);
                    SoundUtils.playErrorSound(player, player.m_20183_());
                    return;
                }
                if (tempColony != null) {
                    AdvancementUtils.TriggerAdvancementPlayersForColony(tempColony, playerMP -> AdvancementTriggers.PLACE_STRUCTURE.trigger((ServerPlayer)playerMP, ((AbstractBlockHut)anchor.m_60734_()).getBlueprintName()));
                } else {
                    AdvancementTriggers.PLACE_STRUCTURE.trigger((ServerPlayer)player, ((AbstractBlockHut)anchor.m_60734_()).getBlueprintName());
                }
                world.m_46961_(blockPos, true);
                world.m_46597_(blockPos, anchor);
                ((AbstractBlockHut)anchor.m_60734_()).onBlockPlacedByBuildTool(world, blockPos, anchor, (LivingEntity)player, null, placementSettings.getMirror() != Mirror.NONE, packName, blueprintPath);
                int level = 0;
                boolean finishedUpgrade = false;
                if (compound != null) {
                    if (compound.m_128431_().contains("otherLevel")) {
                        level = compound.m_128451_("otherLevel");
                    }
                    if (compound.m_128431_().contains("isPasteable")) {
                        Object newBlueprintPath = blueprintPath;
                        newBlueprintPath = ((String)newBlueprintPath).substring(0, ((String)newBlueprintPath).length() - 1);
                        newBlueprintPath = (String)newBlueprintPath + level;
                        CreativeBuildingStructureHandler.loadAndPlaceStructureWithRotation(player.f_19853_, StructurePacks.getBlueprintFuture((String)packName, (String)newBlueprintPath), blockPos, placementSettings.getRotation(), placementSettings.getMirror() != Mirror.NONE ? Mirror.FRONT_BACK : Mirror.NONE, true, (ServerPlayer)player);
                        finishedUpgrade = true;
                    }
                }
                InventoryUtils.reduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), inventoryStack, 1);
                @Nullable IBuilding building = IColonyManager.getInstance().getBuilding(world, blockPos);
                if (building == null) {
                    if (!(anchor.m_60734_() instanceof BlockHutTownHall)) {
                        SoundUtils.playErrorSound(player, player.m_20183_());
                        Log.getLogger().error("BuildTool: building is null!", (Throwable)new Exception());
                    }
                } else {
                    SoundUtils.playSuccessSound(player, player.m_20183_());
                    if (building.getTileEntity() != null) {
                        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, blockPos);
                        if (colony == null) {
                            Log.getLogger().info("No colony for " + player.m_7755_().getString());
                        } else {
                            building.getTileEntity().setColony(colony);
                        }
                    }
                    building.setStructurePack(packName);
                    building.setBlueprintPath(blueprintPath);
                    building.setBuildingLevel(level);
                    if (level > 0) {
                        building.setDeconstructed();
                    }
                    if (!(building instanceof IRSComponent)) {
                        ConstructionTapeHelper.placeConstructionTape(building.getCorners(), world);
                    }
                    building.setIsMirrored(placementSettings.mirror != Mirror.NONE);
                    if (finishedUpgrade) {
                        building.onUpgradeComplete(building.getBuildingLevel());
                    }
                }
            }
            SoundUtils.playSuccessSound(player, player.m_20183_());
        } else if (blueprint.getBlockState(blueprint.getPrimaryBlockOffset()).m_60734_() instanceof ILeveledBlueprintAnchorBlock) {
            int level = Utils.getBlueprintLevel(blueprint.getFileName());
            if (level == -1) {
                Network.getNetwork().sendToPlayer(new OpenDecoWindowMessage(blockPos, packName, blueprintPath, placementSettings.getRotation(), placementSettings.mirror), (ServerPlayer)player);
            } else {
                Network.getNetwork().sendToPlayer(new OpenDecoWindowMessage(blockPos, packName, blueprintPath.replace(level + ".blueprint", "1.blueprint"), placementSettings.getRotation(), placementSettings.mirror), (ServerPlayer)player);
            }
        } else {
            Network.getNetwork().sendToPlayer(new OpenDecoWindowMessage(blockPos, packName, blueprintPath, placementSettings.getRotation(), placementSettings.mirror), (ServerPlayer)player);
        }
        Log.getLogger().warn("Handling Survival Placement in Colony");
    }
}

