/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.util.AdvancementUtils;
import java.util.ArrayList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenJobHandler
implements ICitizenJobHandler {
    private final AbstractEntityCitizen citizen;

    public CitizenJobHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void setModelDependingOnJob(@Nullable IJob<?> job) {
        if (this.citizen.m_6162_()) {
            this.citizen.setModelId(ModModelTypes.CHILD_ID);
            this.citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_MODEL, (Object)this.citizen.getModelType().toString());
            this.citizen.setRenderMetadata("");
            return;
        }
        if (job == null) {
            if (this.citizen.getCitizenColonyHandler().getHomeBuilding() != null) {
                switch (this.citizen.getCitizenColonyHandler().getHomeBuilding().getBuildingLevel()) {
                    case 3: {
                        this.citizen.setModelId(ModModelTypes.CITIZEN_ID);
                        break;
                    }
                    case 4: {
                        this.citizen.setModelId(ModModelTypes.NOBLE_ID);
                        break;
                    }
                    case 5: {
                        this.citizen.setModelId(ModModelTypes.ARISTOCRAT_ID);
                        break;
                    }
                    default: {
                        this.citizen.setModelId(ModModelTypes.SETTLER_ID);
                        break;
                    }
                }
            } else {
                this.citizen.setModelId(ModModelTypes.SETTLER_ID);
            }
        } else {
            this.citizen.setModelId(job.getModel());
        }
        this.citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_MODEL, (Object)this.citizen.getModelType().toString());
        this.citizen.setRenderMetadata("");
    }

    @Override
    public void onJobChanged(@Nullable IJob<?> job) {
        this.setModelDependingOnJob(job);
        for (WrappedGoal task : new ArrayList(this.citizen.getTasks().f_25345_)) {
            if (!(task.m_26015_() instanceof AbstractAISkeleton)) continue;
            this.citizen.getTasks().m_25363_(task.m_26015_());
        }
        this.citizen.getCitizenData().setIdleAtJob(false);
        if (job != null) {
            job.addWorkerAIToTaskList(this.citizen.getTasks());
            if (this.citizen.getTicksExisted() > 0 && this.citizen.getCitizenColonyHandler().getWorkBuilding() != null && this.citizen.getDesiredActivity() == DesiredActivity.WORK) {
                BlockPosUtil.tryMoveBaseCitizenEntityToXYZ(this.citizen, this.citizen.getCitizenColonyHandler().getWorkBuilding().getPosition());
            }
            if (job instanceof AbstractJobGuard) {
                IColony colony = this.citizen.getCitizenColonyHandler().getColony();
                int guards = (int)colony.getCitizenManager().getCitizens().stream().filter(citizen -> citizen.getJob() instanceof AbstractJobGuard).count();
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.citizen.getCitizenColonyHandler().getColony(), player -> AdvancementTriggers.ARMY_POPULATION.trigger((ServerPlayer)player, guards));
            }
            job.initEntityValues(this.citizen);
        }
    }

    @Override
    @Nullable
    public <J extends IJob<?>> J getColonyJob(@NotNull Class<J> type) {
        return this.citizen.getCitizenData() == null ? null : (J)this.citizen.getCitizenData().getJob(type);
    }

    @Override
    @Nullable
    public IJob<?> getColonyJob() {
        return this.citizen.getCitizenData() == null ? null : this.citizen.getCitizenData().getJob();
    }

    @Override
    public boolean shouldRunAvoidance() {
        return this.getColonyJob() == null || this.getColonyJob().allowsAvoidance();
    }
}

