/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.util.MessageUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;

public class CitizenChatHandler
implements ICitizenChatHandler {
    private final AbstractEntityCitizen citizen;

    public CitizenChatHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void notifyDeath(DamageSource damageSource) {
        if (this.citizen.getCitizenColonyHandler().getColony() != null && this.citizen.getCitizenData() != null) {
            IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
            MutableComponent contentComponent = job != null ? Component.m_237110_((String)"block.blockhuttownhall.messageworkerdead", (Object[])new Object[]{Component.m_237115_((String)job.getJobRegistryEntry().getTranslationKey()), this.citizen.getCitizenData().getName(), Math.round(this.citizen.m_20185_()), Math.round(this.citizen.m_20186_()), Math.round(this.citizen.m_20189_()), Component.m_237115_((String)damageSource.f_19326_)}) : Component.m_237110_((String)"block.blockhuttownhall.messagecolonistdead", (Object[])new Object[]{this.citizen.getCitizenData().getName(), Math.round(this.citizen.m_20185_()), Math.round(this.citizen.m_20186_()), Math.round(this.citizen.m_20189_()), Component.m_237115_((String)damageSource.f_19326_)});
            MessageUtils.format((Component)contentComponent).with(ChatFormatting.RED).sendTo(this.citizen.getCitizenColonyHandler().getColony()).forManagers();
        }
    }

    @Override
    public void sendLocalizedChat(String keyIn, Object ... msg) {
        this.sendLocalizedChat((Component)Component.m_237110_((String)keyIn, (Object[])msg));
    }

    @Override
    public void sendLocalizedChat(Component component) {
        if (this.citizen.getCitizenColonyHandler().getColony() != null) {
            IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
            MessageUtils.MessageBuilder builder = job != null ? MessageUtils.format(job.getJobRegistryEntry().getTranslationKey(), new Object[0]).append((Component)Component.m_237113_((String)" ")).append(this.citizen.m_7770_()).append((Component)Component.m_237113_((String)": ")).append(component) : MessageUtils.format(this.citizen.m_7770_()).append((Component)Component.m_237113_((String)": ")).append(component);
            builder.sendTo(this.citizen.getCitizenColonyHandler().getColony()).forAllPlayers();
        }
    }
}

