/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHospital;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAICitizenAvoidEntity
extends Goal {
    private static final double TOO_CLOSE_TO_MOB = 4.0;
    private static final int CHECKS_BEFORE_SAFE = 40;
    private static final float MIN_MOVE_AWAY_DIST = 5.0f;
    private static final float MED_MOVE_AWAY_DIST = 10.0f;
    private static final float MAX_MOVE_AWAY_DIST = 20.0f;
    private final EntityCitizen citizen;
    private final double farSpeed;
    private final double nearSpeed;
    private final float distanceFromEntity;
    private final Class<? extends Entity> targetEntityClass;
    @Nullable
    private Entity closestLivingEntity;
    private int fleeingCounter = 0;
    private PathResult moveAwayPath;
    private final ITickRateStateMachine<IAIState> stateMachine;
    private BlockPos startingPos;
    private final Random rand = new Random();

    public EntityAICitizenAvoidEntity(@NotNull EntityCitizen entity, @NotNull Class<? extends Entity> targetEntityClass, float distanceFromEntity, double farSpeed, double nearSpeed) {
        this.citizen = entity;
        this.startingPos = entity.m_20183_();
        this.targetEntityClass = targetEntityClass;
        this.distanceFromEntity = distanceFromEntity;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        super.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.stateMachine = new TickRateStateMachine<AIWorkerState>(AIWorkerState.SAFE, this::onException);
        this.stateMachine.addTransition(new AITarget(AIWorkerState.SAFE, this::isEntityClose, () -> AIWorkerState.RUNNING, 5));
        this.stateMachine.addTransition(new AITarget(AIWorkerState.RUNNING, this::updateMoving, () -> AIWorkerState.SAFE, 5));
    }

    private void onException(RuntimeException e) {
        Log.getLogger().warn("AvoidAI of:" + this.citizen.m_7755_() + " threw an Exception:", (Throwable)e);
    }

    public boolean isEntityClose() {
        if (!this.citizen.isCurrentlyFleeing()) {
            return false;
        }
        ++this.fleeingCounter;
        if (this.fleeingCounter == 40) {
            this.fleeingCounter = 0;
            this.citizen.setFleeingState(false);
            this.citizen.getNavigation().tryMoveToBlockPos(this.startingPos, 1.0);
            return false;
        }
        this.closestLivingEntity = this.citizen.getThreatTable().getTargetMob();
        return this.closestLivingEntity != null && this.citizen.m_21574_().m_148306_(this.closestLivingEntity) && this.targetEntityClass.isInstance(this.closestLivingEntity);
    }

    private Entity getClosestToAvoid() {
        if (this.targetEntityClass == Player.class) {
            return CompatibilityUtils.getWorldFromCitizen(this.citizen).m_45930_((Entity)this.citizen, (double)this.distanceFromEntity);
        }
        Optional<Entity> entityOptional = CompatibilityUtils.getWorldFromCitizen(this.citizen).m_6249_((Entity)this.citizen, this.citizen.m_20191_().m_82377_((double)this.distanceFromEntity, 3.0, (double)this.distanceFromEntity), target -> target.m_6084_() && this.citizen.m_21574_().m_148306_(target)).stream().filter(this.targetEntityClass::isInstance).findFirst();
        return entityOptional.orElse(null);
    }

    private boolean performMoveAway() {
        if ((this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) && this.citizen.getNavigation().m_26571_()) {
            this.moveAwayPath = this.citizen.getNavigation().moveAwayFromXYZ(this.citizen.m_20183_().m_7918_(this.rand.nextInt(2), 0, this.rand.nextInt(2)), this.distanceFromEntity + this.getMoveAwayDist(this.citizen), this.nearSpeed, true);
            this.citizen.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.avoiding")});
            return true;
        }
        return false;
    }

    private float getMoveAwayDist(AbstractEntityCitizen citizen) {
        if (citizen.m_21223_() >= citizen.m_21233_() - 4.0f) {
            return 5.0f;
        }
        if (citizen.m_21223_() >= citizen.m_21233_() / 2.0f) {
            return 10.0f;
        }
        return 20.0f;
    }

    private boolean updateMoving() {
        this.citizen.playMoveAwaySound();
        @Nullable Entity newClosest = this.getClosestToAvoid();
        if (newClosest != null) {
            if (newClosest.m_19879_() != this.closestLivingEntity.m_19879_()) {
                this.citizen.callForHelp(newClosest, 90000);
                this.closestLivingEntity = newClosest;
            }
            this.performMoveAway();
        }
        if (this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) {
            this.fleeingCounter = 0;
            return true;
        }
        if ((double)this.citizen.m_20270_(this.closestLivingEntity) < 4.0) {
            this.citizen.getNavigation().m_26517_(this.nearSpeed);
        } else {
            this.citizen.getNavigation().m_26517_(this.farSpeed);
        }
        return false;
    }

    public boolean m_8036_() {
        if (this.citizen.isCurrentlyFleeing() && this.citizen.getCitizenJobHandler().shouldRunAvoidance() && (this.citizen.getCitizenJobHandler().getColonyJob() == null || this.citizen.getCitizenJobHandler().getColonyJob().canAIBeInterrupted())) {
            this.startingPos = this.citizen.m_20183_();
            this.fleeingCounter = 0;
            return !((double)this.citizen.m_21223_() <= 6.0) || this.citizen.getCitizenColonyHandler().getColony() == null || this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBestBuilding(this.citizen, BuildingHospital.class) == null;
        }
        return false;
    }

    public boolean m_8045_() {
        this.stateMachine.tick();
        if ((double)this.citizen.m_21223_() <= 6.0 && this.citizen.getCitizenColonyHandler().getColony() != null && this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBestBuilding(this.citizen, BuildingHospital.class) != null) {
            return false;
        }
        return this.citizen.isCurrentlyFleeing() && this.citizen.getCitizenJobHandler().shouldRunAvoidance();
    }

    public void m_8041_() {
        this.closestLivingEntity = null;
        this.moveAwayPath = null;
        this.stateMachine.reset();
    }
}

