/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.school;

import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSchool;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobPupil;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.CircleParticleEffectMessage;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkPupil
extends AbstractEntityAIInteract<JobPupil, BuildingSchool> {
    private static final int STUDY_TO_RECESS_RATIO = 10;
    private final Predicate<ItemStack> PAPER = stack -> stack.m_41720_() == Items.f_42516_;
    private int maxSittingTicks = 0;
    private int sittingTicks = 0;
    private BlockPos studyPos;
    private BlockPos recessPos;

    public EntityAIWorkPupil(@NotNull JobPupil job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.DECIDE, this::decide, 20), new AITarget((IAIState)AIWorkerState.STUDY, this::study, 20), new AITarget((IAIState)AIWorkerState.RECESS, this::recess, 20));
        this.worker.m_21553_(true);
    }

    private IAIState decide() {
        if (this.worker.m_217043_().m_188503_(10) < 1) {
            this.recessPos = ((BuildingSchool)this.building).getPosition();
            return AIWorkerState.RECESS;
        }
        BuildingSchool school = (BuildingSchool)this.building;
        BlockPos pos = school.getRandomPlaceToSit();
        if (pos == null) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.school.nocarpet"), ChatPriority.BLOCKING));
            return AIWorkerState.DECIDE;
        }
        this.studyPos = pos;
        return AIWorkerState.STUDY;
    }

    private IAIState recess() {
        if (this.recessPos == null || this.worker.m_217043_().m_188503_(10) < 1) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.recessPos)) {
            return this.getState();
        }
        BlockPos newRecessPos = this.findRandomPositionToWalkTo(10);
        if (newRecessPos != null) {
            this.recessPos = newRecessPos;
        }
        return this.getState();
    }

    private IAIState study() {
        int slot;
        if (this.studyPos == null) {
            return AIWorkerState.DECIDE;
        }
        if (this.walkToBlock(this.studyPos, 1)) {
            return this.getState();
        }
        if (!this.world.m_45976_(EntityCitizen.class, new AABB((double)this.studyPos.m_123341_(), (double)this.studyPos.m_123342_(), (double)this.studyPos.m_123343_(), (double)this.studyPos.m_123341_(), (double)this.studyPos.m_123342_(), (double)this.studyPos.m_123343_())).isEmpty()) {
            this.studyPos = null;
            return AIWorkerState.DECIDE;
        }
        if (this.sittingTicks == 0 || this.worker.f_19824_ == null) {
            this.maxSittingTicks = this.worker.m_217043_().m_188503_(60) + 60;
            SittingEntity.sitDown(this.studyPos, (Mob)this.worker, this.maxSittingTicks * 20);
        }
        if ((slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), this.PAPER)) != -1) {
            this.worker.m_8061_(EquipmentSlot.MAINHAND, this.worker.getInventoryCitizen().getStackInSlot(slot));
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.worker.m_20182_().m_82520_(0.0, 1.0, 0.0), ParticleTypes.f_123809_, this.sittingTicks), (Entity)this.worker);
        } else {
            this.worker.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.worker.m_20182_().m_82520_(0.0, 1.0, 0.0), ParticleTypes.f_123748_, this.sittingTicks), (Entity)this.worker);
        }
        ++this.sittingTicks;
        if (this.sittingTicks < this.maxSittingTicks) {
            return this.getState();
        }
        this.worker.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        if (this.worker.f_19824_ != null) {
            this.worker.m_8127_();
            this.worker.m_6034_(this.worker.m_20185_(), this.worker.m_20186_() + 1.0, this.worker.m_20189_());
        }
        if (slot != -1) {
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((ItemLike)Items.f_42516_), 1);
            double bonus = 50.0 * (1.0 + this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.TEACHING));
            this.worker.getCitizenData().getCitizenSkillHandler().addXpToSkill(Skill.Intelligence, bonus, this.worker.getCitizenData());
        }
        this.worker.decreaseSaturationForContinuousAction();
        this.maxSittingTicks = 0;
        this.sittingTicks = 0;
        return null;
    }

    @Override
    public Class<BuildingSchool> getExpectedBuildingClass() {
        return BuildingSchool.class;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.STUDY;
    }
}

