/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.alchemist;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingAlchemist;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobAlchemist;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.network.messages.client.BlockParticleEffectMessage;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkAlchemist
extends AbstractEntityAICrafting<JobAlchemist, BuildingAlchemist> {
    private static final double BASE_XP_GAIN = 5.0;
    private static final int DELAY_TO_HARVEST_NETHERWART = 30;
    private static final int DELAY_TO_HARVEST_MISTLETOE = 30;
    private BlockPos fuelPos = null;
    private IAIState preFuelState = null;
    private BlockPos walkTo;

    public EntityAIWorkAlchemist(@NotNull JobAlchemist alchemistJob) {
        super(alchemistJob);
        super.registerTargets(new AIEventTarget<Supplier<Object>>(AIBlockingEventType.EVENT, this::isFuelNeeded, this::checkBrewingStandFuel, 200), new AIEventTarget<Supplier<Object>>(AIBlockingEventType.EVENT, this::accelerateBrewingStand, this::getState, 20), new AITarget((IAIState)AIWorkerState.START_USING_BREWINGSTAND, this::fillUpBrewingStand, 20), new AITarget((IAIState)AIWorkerState.RETRIEVING_END_PRODUCT_FROM_BREWINGSTAMD, this::retrieveBrewableFromBrewingStand, 20), new AITarget((IAIState)AIWorkerState.RETRIEVING_USED_FUEL_FROM_BREWINGSTAND, this::retrieveUsedFuel, 20), new AITarget((IAIState)AIWorkerState.ADD_FUEL_TO_BREWINGSTAND, this::addFuelToBrewingStand, 20), new AITarget((IAIState)AIWorkerState.HARVEST_MISTLETOE, this::harvestMistleToe, 20), new AITarget((IAIState)AIWorkerState.HARVEST_NETHERWART, this::harvestNetherWart, 20));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAIState harvestNetherWart() {
        if (this.walkTo == null) {
            List<BlockPos> soilList = ((BuildingAlchemist)this.building).getAllSoilPositions();
            if (soilList.isEmpty()) {
                return AIWorkerState.IDLE;
            }
            BlockPos randomSoil = soilList.get(this.worker.m_217043_().m_188503_(soilList.size()));
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.world, randomSoil)) return AIWorkerState.HARVEST_NETHERWART;
            if (this.world.m_8055_(randomSoil).m_60734_() == Blocks.f_50135_) {
                if (this.world.m_8055_(randomSoil.m_7494_()).m_60734_() == Blocks.f_50200_) {
                    this.walkTo = randomSoil;
                    return AIWorkerState.HARVEST_NETHERWART;
                }
                if (this.world.m_46859_(randomSoil.m_7494_()) && !this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)Items.f_42588_, 1), 16, 1)) {
                    return AIWorkerState.IDLE;
                }
                this.walkTo = randomSoil;
                return AIWorkerState.HARVEST_NETHERWART;
            } else {
                ((BuildingAlchemist)this.building).removeSoilPosition(randomSoil);
            }
            return AIWorkerState.HARVEST_NETHERWART;
        }
        if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, this.walkTo) && this.world.m_8055_(this.walkTo).m_60734_() == Blocks.f_50135_) {
            if (this.walkToBlock(this.walkTo)) {
                return AIWorkerState.HARVEST_NETHERWART;
            }
            BlockState aboveState = this.world.m_8055_(this.walkTo.m_7494_());
            if (!(aboveState.m_60734_() instanceof AirBlock)) {
                if (aboveState.m_60734_() == Blocks.f_50200_ && (Integer)aboveState.m_61143_((Property)NetherWartBlock.f_54967_) < 2) {
                    this.walkTo = null;
                    return AIWorkerState.IDLE;
                }
                if (!this.mineBlock(this.walkTo.m_7494_())) return AIWorkerState.HARVEST_NETHERWART;
                this.walkTo = null;
                this.worker.decreaseSaturationForContinuousAction();
                return AIWorkerState.IDLE;
            }
            if (!this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)Items.f_42588_, 1), 16, 1)) {
                this.walkTo = null;
                return AIWorkerState.IDLE;
            }
            int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(Items.f_42588_);
            if (slot == -1) {
                this.walkTo = null;
                return AIWorkerState.IDLE;
            }
            this.world.m_46597_(this.walkTo.m_7494_(), Blocks.f_50200_.m_49966_());
            this.worker.decreaseSaturationForContinuousAction();
            this.getInventory().extractItem(slot, 1, false);
            this.walkTo = null;
            return AIWorkerState.IDLE;
        }
        this.walkTo = null;
        return AIWorkerState.IDLE;
    }

    private IAIState harvestMistleToe() {
        if (this.checkForToolOrWeapon(ToolType.SHEARS)) {
            return AIWorkerState.IDLE;
        }
        if (this.walkTo == null) {
            List<BlockPos> leaveList = ((BuildingAlchemist)this.building).getAllLeavePositions();
            if (leaveList.isEmpty()) {
                return AIWorkerState.IDLE;
            }
            BlockPos randomLeaf = leaveList.get(this.worker.m_217043_().m_188503_(leaveList.size()));
            if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, randomLeaf)) {
                if (this.world.m_8055_(randomLeaf).m_60734_() instanceof LeavesBlock) {
                    this.walkTo = randomLeaf;
                } else {
                    ((BuildingAlchemist)this.building).removeLeafPosition(randomLeaf);
                }
            }
            return AIWorkerState.HARVEST_MISTLETOE;
        }
        if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, this.walkTo) && this.world.m_8055_(this.walkTo).m_60734_() instanceof LeavesBlock) {
            if (this.walkToBlock(this.walkTo)) {
                return AIWorkerState.HARVEST_MISTLETOE;
            }
            BlockState state = this.world.m_8055_(this.walkTo);
            int slot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.worker.getInventoryCitizen(), ToolType.SHEARS, 0, ((BuildingAlchemist)this.building).getMaxToolLevel());
            this.worker.getCitizenItemHandler().setHeldItem(InteractionHand.MAIN_HAND, slot);
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            this.world.m_5594_(null, this.walkTo, state.getSoundType((LevelReader)this.world, this.walkTo, (Entity)this.worker).m_56775_(), SoundSource.BLOCKS, state.getSoundType((LevelReader)this.world, this.walkTo, (Entity)this.worker).m_56773_(), state.getSoundType((LevelReader)this.world, this.walkTo, (Entity)this.worker).m_56774_());
            Network.getNetwork().sendToTrackingEntity(new BlockParticleEffectMessage(this.walkTo, state, this.worker.m_217043_().m_188503_(7) - 1), (Entity)this.worker);
            if (this.worker.m_217043_().m_188503_(120) < 1) {
                this.worker.decreaseSaturationForContinuousAction();
                InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((ItemLike)ModItems.mistletoe, 1));
                this.walkTo = null;
                this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
                return AIWorkerState.INVENTORY_FULL;
            }
        } else {
            this.walkTo = null;
            return AIWorkerState.IDLE;
        }
        return AIWorkerState.HARVEST_MISTLETOE;
    }

    @Override
    protected IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (((JobAlchemist)this.job).getTaskQueue().isEmpty() || ((JobAlchemist)this.job).getCurrentTask() == null) {
            if (this.worker.getNavigation().m_26571_()) {
                if (this.worker.m_217043_().m_188503_(30) < 1) {
                    return AIWorkerState.HARVEST_NETHERWART;
                }
                if (this.worker.m_217043_().m_188503_(30) < 1) {
                    return AIWorkerState.HARVEST_MISTLETOE;
                }
                if (((BuildingAlchemist)this.building).isInBuilding(this.worker.m_20183_())) {
                    this.worker.getNavigation().moveToRandomPos(10, 0.6, ((BuildingAlchemist)this.building).getCorners(), AbstractAdvancedPathNavigate.RestrictionType.XYZ);
                } else {
                    this.walkToBuilding();
                }
            }
            return AIWorkerState.IDLE;
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((JobAlchemist)this.job).getActionsDone() >= this.getActionsDoneUntilDumping()) {
            return this.getState();
        }
        return this.getNextCraftingState();
    }

    @Override
    public Class<BuildingAlchemist> getExpectedBuildingClass() {
        return BuildingAlchemist.class;
    }

    @Override
    protected int getExtendedCount(ItemStack stack) {
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() == Blocks.f_50255_) {
            int count = 0;
            for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
                if (!WorldUtil.isBlockLoaded((LevelAccessor)this.world, pos)) continue;
                BlockEntity entity = this.world.m_7702_(pos);
                if (entity instanceof BrewingStandBlockEntity) {
                    BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
                    for (int slot = 0; slot < 4; ++slot) {
                        ItemStack stackInSlot = brewingStand.m_8020_(slot);
                        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(stack, stackInSlot).booleanValue()) continue;
                        count += stackInSlot.m_41613_();
                    }
                    continue;
                }
                ((BuildingAlchemist)this.building).removeBrewingStand(pos);
            }
            return count;
        }
        return 0;
    }

    @Override
    protected IAIState getRecipe() {
        IRequest currentTask = ((JobAlchemist)this.job).getCurrentTask();
        if (currentTask == null) {
            this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
            return AIWorkerState.START_WORKING;
        }
        ((JobAlchemist)this.job).setMaxCraftingCount(((PublicCrafting)currentTask.getRequest()).getCount());
        BlockPos brewingStandPos = this.getPositionOfBrewingStandToRetrieveFrom();
        if (brewingStandPos != null) {
            this.currentRequest = currentTask;
            this.walkTo = brewingStandPos;
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_BREWINGSTAMD;
        }
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() == Blocks.f_50255_) {
            for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
                BlockEntity entity = this.world.m_7702_(pos);
                if (entity instanceof BrewingStandBlockEntity) {
                    BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
                    if (brewingStand.f_58976_ <= 0 && ItemStackUtils.isEmpty(brewingStand.m_8020_(3)).booleanValue()) continue;
                    return AIWorkerState.CRAFT;
                }
                ((BuildingAlchemist)this.building).removeBrewingStand(pos);
            }
        }
        return super.getRecipe();
    }

    private int countOfBubblingBrewingStands() {
        int count = 0;
        Level world = ((BuildingAlchemist)this.building).getColony().getWorld();
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) continue;
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof BrewingStandBlockEntity) {
                BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
                if (brewingStand.f_58976_ <= 0) continue;
                ++count;
                continue;
            }
            ((BuildingAlchemist)this.building).removeBrewingStand(pos);
        }
        return count;
    }

    private boolean accelerateBrewingStand() {
        int accelerationTicks = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getSecondarySkill()) / 10 * 2;
        Level world = ((BuildingAlchemist)this.building).getColony().getWorld();
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((entity = world.m_7702_(pos)) instanceof BrewingStandBlockEntity)) continue;
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
            for (int i = 0; i < accelerationTicks; ++i) {
                if (brewingStand.f_58976_ <= 0) continue;
                BrewingStandBlockEntity.m_155285_((Level)entity.m_58904_(), (BlockPos)entity.m_58899_(), (BlockState)entity.m_58900_(), (BrewingStandBlockEntity)brewingStand);
            }
        }
        return false;
    }

    private boolean isFuelNeeded() {
        if (this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.f_50255_) {
            return false;
        }
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.world, pos)) continue;
            BlockEntity entity = this.world.m_7702_(pos);
            if (!(entity instanceof BrewingStandBlockEntity)) {
                ((BuildingAlchemist)this.building).removeBrewingStand(pos);
                continue;
            }
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
            if (brewingStand.f_58976_ > 0 || !ItemStackUtils.hasBrewableAndNoFuel(brewingStand) && !ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand)) continue;
            return this.getState() != AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return false;
    }

    private IAIState checkBrewingStandFuel() {
        if (this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.f_50255_) {
            return this.getState();
        }
        Level world = ((BuildingAlchemist)this.building).getColony().getWorld();
        if (!(InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.f_42593_) || InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, Items.f_42593_) || ((BuildingAlchemist)this.building).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(Stack.class)))) {
            this.worker.getCitizenData().createRequestAsync(new Stack(new ItemStack((ItemLike)Items.f_42593_), 8 * ((BuildingAlchemist)this.building).getAllBrewingStandPositions().size(), 1));
            return this.getState();
        }
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) continue;
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof BrewingStandBlockEntity) {
                BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
                if (brewingStand.f_58976_ > 0 || !ItemStackUtils.hasBrewableAndNoFuel(brewingStand) && !ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand)) continue;
                if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.f_42593_)) {
                    if (InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, Items.f_42593_)) {
                        this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(item -> item.m_41720_() == Items.f_42593_, 8);
                        this.walkTo = null;
                        return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                    }
                    return this.getState();
                }
                this.fuelPos = pos;
                if (this.preFuelState == null) {
                    this.preFuelState = this.getState();
                }
                return AIWorkerState.ADD_FUEL_TO_BREWINGSTAND;
            }
            ((BuildingAlchemist)this.building).removeBrewingStand(pos);
        }
        return this.getState();
    }

    private IAIState addFuelToBrewingStand() {
        BlockEntity entity;
        if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.f_42593_)) {
            if (InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, Items.f_42593_)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(item -> item.m_41720_() == Items.f_42593_, 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.preFuelState = null;
            this.fuelPos = null;
            return AIWorkerState.START_WORKING;
        }
        if (this.fuelPos == null || this.walkToBlock(this.fuelPos)) {
            return this.getState();
        }
        if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, this.fuelPos) && (entity = this.world.m_7702_(this.fuelPos)) instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.f_42593_) && (ItemStackUtils.hasBrewableAndNoFuel(brewingStand) || ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand))) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), item -> item.m_41720_() == Items.f_42593_, 8, (IItemHandler)new InvWrapper((Container)brewingStand), 4);
                if (this.preFuelState != null && this.preFuelState != AIWorkerState.ADD_FUEL_TO_BREWINGSTAND) {
                    IAIState returnState = this.preFuelState;
                    this.preFuelState = null;
                    this.fuelPos = null;
                    return returnState;
                }
            }
        }
        this.preFuelState = null;
        this.fuelPos = null;
        return AIWorkerState.START_WORKING;
    }

    private int getMaxUsableBrewingStands() {
        int maxSkillBrewingStand = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getPrimarySkill()) / 10 + 1;
        return Math.min(maxSkillBrewingStand, ((BuildingAlchemist)this.building).getAllBrewingStandPositions().size());
    }

    private BlockPos getPositionOfBrewingStandToRetrieveFrom() {
        if (this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.f_50255_) {
            return null;
        }
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            BlockEntity entity = this.world.m_7702_(pos);
            if (!(entity instanceof BrewingStandBlockEntity)) continue;
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
            int countInResultSlot = 0;
            for (int slot = 0; slot < 3; ++slot) {
                if (ItemStackUtils.isEmpty(brewingStand.m_8020_(slot)).booleanValue() || !ItemStackUtils.compareItemStacksIgnoreStackSize(this.currentRecipeStorage.getPrimaryOutput(), brewingStand.m_8020_(slot)).booleanValue()) continue;
                countInResultSlot = brewingStand.m_8020_(slot).m_41613_();
            }
            if (brewingStand.f_58976_ > 0 || countInResultSlot <= 0 || !ItemStackUtils.isEmpty(brewingStand.m_8020_(3)).booleanValue()) continue;
            this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.retrieving")});
            return pos;
        }
        return null;
    }

    @Override
    protected IAIState checkForItems(@NotNull IRecipeStorage storage) {
        if (storage.getIntermediate() != Blocks.f_50255_) {
            return super.checkForItems(storage);
        }
        List<ItemStorage> input = storage.getCleanedInput();
        int countInBewingStand = this.getExtendedCount(storage.getPrimaryOutput());
        int outputInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, storage.getPrimaryOutput()));
        for (ItemStorage inputStorage : input) {
            int inputInInv;
            Predicate<ItemStack> predicate = stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(stack, inputStorage.getItemStack()) != false;
            int inputInBrewingStand = this.getExtendedCount(inputStorage.getItemStack());
            if (countInBewingStand + inputInBrewingStand + (inputInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate)) + outputInInv < inputStorage.getAmount() * ((JobAlchemist)this.job).getMaxCraftingCount() && InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, predicate)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(predicate, inputStorage.getAmount() * (((JobAlchemist)this.job).getMaxCraftingCount() - countInBewingStand - inputInBrewingStand));
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            int countOfInput = inputInInv + InventoryUtils.getCountFromBuilding((IBuilding)this.building, predicate) + countInBewingStand + inputInBrewingStand + outputInInv;
            if (countOfInput >= inputStorage.getAmount() * ((JobAlchemist)this.job).getMaxCraftingCount()) continue;
            ((JobAlchemist)this.job).finishRequest(false);
            this.resetValues();
        }
        return AIWorkerState.CRAFT;
    }

    private IAIState retrieveBrewableFromBrewingStand() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.retrieving")});
        if (this.walkTo == null || this.currentRequest == null) {
            return AIWorkerState.START_WORKING;
        }
        BlockEntity entity = this.world.m_7702_(this.walkTo);
        if (!(entity instanceof BrewingStandBlockEntity)) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            return this.getState();
        }
        this.walkTo = null;
        int preExtractCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(((PublicCrafting)this.currentRequest.getRequest()).getStack(), stack));
        for (int slot = 0; slot < 3; ++slot) {
            if (ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).m_8020_(slot)).booleanValue()) continue;
            this.extractFromBrewingStandSlot((BrewingStandBlockEntity)entity, slot);
        }
        int resultCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(((PublicCrafting)this.currentRequest.getRequest()).getStack(), stack)) - preExtractCount;
        if (resultCount > 0) {
            ItemStack stack2 = ((PublicCrafting)this.currentRequest.getRequest()).getStack().m_41777_();
            stack2.m_41764_(resultCount);
            this.currentRequest.addDelivery(stack2);
            int step = resultCount / this.currentRecipeStorage.getPrimaryOutput().m_41613_();
            ((JobAlchemist)this.job).setCraftCounter(((JobAlchemist)this.job).getCraftCounter() + step);
            ((JobAlchemist)this.job).setProgress(((JobAlchemist)this.job).getProgress() - step);
            if (((JobAlchemist)this.job).getMaxCraftingCount() == 0) {
                ((JobAlchemist)this.job).setMaxCraftingCount(((PublicCrafting)this.currentRequest.getRequest()).getCount());
            }
            if (((JobAlchemist)this.job).getCraftCounter() >= ((JobAlchemist)this.job).getMaxCraftingCount() && ((JobAlchemist)this.job).getProgress() <= 0) {
                ((JobAlchemist)this.job).finishRequest(true);
                this.resetValues();
                this.currentRecipeStorage = null;
                this.incrementActionsDoneAndDecSaturation();
                return AIWorkerState.INVENTORY_FULL;
            }
        }
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    private IAIState retrieveUsedFuel() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.retrieving")});
        if (this.walkTo == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            return this.getState();
        }
        BlockEntity entity = this.world.m_7702_(this.walkTo);
        if (!(entity instanceof BrewingStandBlockEntity) || ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).m_8020_(4)).booleanValue()) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        this.walkTo = null;
        this.extractFromBrewingStandSlot((BrewingStandBlockEntity)entity, 4);
        return AIWorkerState.START_WORKING;
    }

    private void extractFromBrewingStandSlot(BrewingStandBlockEntity brewingStand, int slot) {
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((Container)brewingStand), slot, (IItemHandler)this.worker.getInventoryCitizen());
        if (slot <= 3 && slot >= 0) {
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
        }
    }

    private IAIState checkIfAbleToSmelt() {
        int burning = this.countOfBubblingBrewingStands();
        if (burning > 0 && (burning >= this.getMaxUsableBrewingStands() || ((JobAlchemist)this.job).getCraftCounter() + ((JobAlchemist)this.job).getProgress() >= ((JobAlchemist)this.job).getMaxCraftingCount())) {
            this.setDelay(20);
            return this.getState();
        }
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            BlockEntity entity = this.world.m_7702_(pos);
            if (entity instanceof BrewingStandBlockEntity) {
                if (!ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).m_8020_(3)).booleanValue()) continue;
                this.walkTo = pos;
                return AIWorkerState.START_USING_BREWINGSTAND;
            }
            ((BuildingAlchemist)this.building).removeBrewingStand(pos);
        }
        if (burning > 0) {
            this.setDelay(20);
        }
        return this.getState();
    }

    /*
     * Enabled aggressive block sorting
     */
    private IAIState fillUpBrewingStand() {
        block17: {
            Predicate<ItemStack> potion;
            int maxBrewingStands;
            BrewingStandBlockEntity brewingStand;
            BlockEntity entity;
            int burningCount;
            block18: {
                block14: {
                    int amountOfIngredientInInv;
                    int amountOfIngredientInBuilding;
                    int targetCount;
                    Predicate<ItemStack> ingredient;
                    block19: {
                        int resultInCitizenInv;
                        int resultInBrewingStand;
                        block15: {
                            int amountOfPotionInInv;
                            int amountOfPotionInBuilding;
                            int targetCount2;
                            block16: {
                                if (((BuildingAlchemist)this.building).getAllBrewingStandPositions().isEmpty()) {
                                    if (this.worker.getCitizenData() != null) {
                                        this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.bakery.nofurnace"), ChatPriority.BLOCKING));
                                    }
                                    this.setDelay(5);
                                    return AIWorkerState.START_WORKING;
                                }
                                if (this.walkTo == null || this.world.m_8055_(this.walkTo).m_60734_() != Blocks.f_50255_) {
                                    this.walkTo = null;
                                    this.setDelay(5);
                                    return AIWorkerState.START_WORKING;
                                }
                                burningCount = this.countOfBubblingBrewingStands();
                                entity = this.world.m_7702_(this.walkTo);
                                if (!(entity instanceof BrewingStandBlockEntity) || this.currentRecipeStorage == null) break block14;
                                brewingStand = (BrewingStandBlockEntity)entity;
                                maxBrewingStands = this.getMaxUsableBrewingStands();
                                resultInBrewingStand = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
                                resultInCitizenInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
                                if (!ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).m_8020_(0)).booleanValue() && !ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).m_8020_(1)).booleanValue() && !ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).m_8020_(2)).booleanValue()) break block15;
                                ItemStack potionStack = this.currentRecipeStorage.getCleanedInput().get(1).getItemStack();
                                potion = stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(potionStack, stack);
                                int potionInBrewingStand = this.getExtendedCount(potionStack);
                                targetCount2 = ((PublicCrafting)this.currentRequest.getRequest()).getCount() * this.currentRecipeStorage.getPrimaryOutput().m_41613_() - potionInBrewingStand - resultInBrewingStand - resultInCitizenInv;
                                if (targetCount2 <= 0) {
                                    return AIWorkerState.START_WORKING;
                                }
                                amountOfPotionInBuilding = InventoryUtils.getCountFromBuilding((IBuilding)this.building, potion);
                                amountOfPotionInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), potion);
                                if (this.worker.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                                    this.worker.m_21008_(InteractionHand.MAIN_HAND, potionStack.m_41777_());
                                }
                                if (amountOfPotionInInv <= 0) break block16;
                                if (!ItemStackUtils.hasFuelAndNoBrewable(brewingStand) && !ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand)) break block17;
                                break block18;
                            }
                            if (amountOfPotionInBuilding >= targetCount2 - amountOfPotionInInv && this.currentRecipeStorage.getIntermediate() == Blocks.f_50255_) {
                                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(potion, targetCount2);
                                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                            }
                            ((JobAlchemist)this.job).finishRequest(false);
                            this.resetValues();
                            this.walkTo = null;
                            return AIWorkerState.IDLE;
                        }
                        if (!ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).m_8020_(3)).booleanValue()) break block17;
                        ItemStack ingredientStack = this.currentRecipeStorage.getCleanedInput().get(0).getItemStack();
                        ingredient = stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(ingredientStack, stack);
                        int ingredientInBrewingStand = this.getExtendedCount(ingredientStack);
                        targetCount = ((PublicCrafting)this.currentRequest.getRequest()).getCount() * this.currentRecipeStorage.getPrimaryOutput().m_41613_() - ingredientInBrewingStand * 3 - resultInBrewingStand - resultInCitizenInv;
                        if (targetCount <= 0) {
                            return AIWorkerState.START_WORKING;
                        }
                        amountOfIngredientInBuilding = InventoryUtils.getCountFromBuilding((IBuilding)this.building, ingredient);
                        amountOfIngredientInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ingredient);
                        if (this.worker.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                            this.worker.m_21008_(InteractionHand.MAIN_HAND, ingredientStack.m_41777_());
                        }
                        if (amountOfIngredientInInv <= 0) break block19;
                        if (!ItemStackUtils.hasFuelAndNoBrewable(brewingStand) && !ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand)) break block17;
                        int toTransfer = 0;
                        if (burningCount < maxBrewingStands) {
                            toTransfer = 1;
                        }
                        if (toTransfer <= 0) break block17;
                        if (this.walkToBlock(this.walkTo)) {
                            return this.getState();
                        }
                        this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.walkTo);
                        InventoryUtils.transferXInItemHandlerIntoSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ingredient, toTransfer, (IItemHandler)new InvWrapper((Container)brewingStand), 3);
                        break block17;
                    }
                    if (amountOfIngredientInBuilding >= targetCount - amountOfIngredientInInv && this.currentRecipeStorage.getIntermediate() == Blocks.f_50255_) {
                        this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(ingredient, targetCount);
                        return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                    }
                    ((JobAlchemist)this.job).finishRequest(false);
                    this.resetValues();
                    this.walkTo = null;
                    return AIWorkerState.IDLE;
                }
                if (this.world.m_8055_(this.walkTo).m_60734_() instanceof BrewingStandBlock) break block17;
                ((BuildingAlchemist)this.building).removeBrewingStand(this.walkTo);
                break block17;
            }
            for (int slot = 0; slot < 3; ++slot) {
                if (!ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).m_8020_(slot)).booleanValue()) continue;
                int toTransfer = 0;
                if (burningCount < maxBrewingStands) {
                    toTransfer = 1;
                }
                if (toTransfer <= 0) continue;
                if (this.walkToBlock(this.walkTo)) {
                    return this.getState();
                }
                this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.walkTo);
                InventoryUtils.transferXInItemHandlerIntoSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), potion, toTransfer, (IItemHandler)new InvWrapper((Container)brewingStand), slot);
            }
        }
        this.walkTo = null;
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected IAIState craft() {
        if (this.walkToBuilding()) {
            this.setDelay(5);
            return this.getState();
        }
        if (this.currentRecipeStorage != null && this.currentRequest == null) {
            this.currentRequest = ((JobAlchemist)this.job).getCurrentTask();
        }
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() != Blocks.f_50255_) {
            return super.craft();
        }
        if (((BuildingAlchemist)this.building).getAllBrewingStandPositions().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.bakery.nofurnace"), ChatPriority.BLOCKING));
            }
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        BlockPos posOfOven = this.getPositionOfBrewingStandToRetrieveFrom();
        if (posOfOven != null) {
            this.walkTo = posOfOven;
            this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.retrieving")});
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_BREWINGSTAMD;
        }
        if (this.currentRequest != null && ((JobAlchemist)this.job).getMaxCraftingCount() > 0 && ((JobAlchemist)this.job).getCraftCounter() >= ((JobAlchemist)this.job).getMaxCraftingCount()) {
            ((JobAlchemist)this.job).finishRequest(true);
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            this.resetValues();
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        return this.checkIfAbleToSmelt();
    }
}

