/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.commands.AbstractCommand;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.ScanToolData;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.client.SaveStructureNBTMessage;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScanCommand
extends AbstractCommand {
    public static final String NAME = "scan";
    private static final String PLAYER_NOT_FOUND = "com.structurize.command.playernotfound";
    private static final String SCAN_SUCCESS_MESSAGE = "com.structurize.command.scan.success";
    private static final String NO_PERMISSION_MESSAGE = "com.structurize.command.scan.no.perm";
    public static final String FILE_NAME = "filename";
    public static final String PLAYER_NAME = "player";
    public static final String POS1 = "pos1";
    public static final String POS2 = "pos2";
    public static final String ANCHOR_POS = "anchor_pos";

    public static void saveStructure(Level world, Player player, ScanToolData.Slot slot, boolean saveEntities) {
        boolean isHut;
        List list;
        String[] split;
        if (slot.getBox().getAnchor().isPresent() && !BlockPosUtil.isInbetween((BlockPos)((BlockPos)slot.getBox().getAnchor().get()), (BlockPos)slot.getBox().getPos1(), (BlockPos)slot.getBox().getPos2())) {
            player.m_5661_((Component)Component.m_237115_((String)"item.sceptersteel.badanchorpos"), false);
            return;
        }
        BoundingBox box = BoundingBox.m_162375_((Vec3i)slot.getBox().getPos1(), (Vec3i)slot.getBox().getPos2());
        if (box.m_71056_() * box.m_71057_() * box.m_71058_() > (Integer)Structurize.getConfig().getServer().schematicBlockLimit.get()) {
            player.m_5661_((Component)Component.m_237110_((String)"item.sceptersteel.toobig", (Object[])new Object[]{Structurize.getConfig().getServer().schematicBlockLimit.get()}), false);
            return;
        }
        long currentMillis = System.currentTimeMillis();
        String currentMillisString = Long.toString(currentMillis);
        Object fileName = slot.getName().isEmpty() ? Component.m_237110_((String)"item.sceptersteel.scanformat", (Object[])new Object[]{"", currentMillisString}).getString() : slot.getName();
        if (!((String)fileName).contains(".blueprint")) {
            fileName = (String)fileName + ".blueprint";
        }
        String style = (split = ((String)fileName).split("/")).length <= 1 ? "" : split[0];
        BlockPos zero = new BlockPos(box.m_162395_(), box.m_162396_(), box.m_162398_());
        Blueprint bp = BlueprintUtil.createBlueprint((Level)world, (BlockPos)zero, (boolean)saveEntities, (short)((short)box.m_71056_()), (short)((short)box.m_71057_()), (short)((short)box.m_71058_()), (String)fileName, (Optional)slot.getBox().getAnchor());
        if (slot.getBox().getAnchor().isEmpty() && bp.getPrimaryBlockOffset().equals((Object)new BlockPos(bp.getSizeX() / 2, 0, bp.getSizeZ() / 2)) && (list = bp.getBlockInfoAsList().stream().filter(blockInfo -> blockInfo.hasTileEntityData() && blockInfo.getTileEntityData().m_128441_("blueprintDataProvider")).collect(Collectors.toList())).size() > 1) {
            player.m_5661_((Component)Component.m_237110_((String)"com.ldtteam.structurize.gui.scantool.scanbadanchor", (Object[])new Object[]{fileName}), false);
        }
        com.ldtteam.structurize.Network.getNetwork().sendToPlayer((IMessage)new SaveScanMessage(BlueprintUtil.writeBlueprintToNBT((Blueprint)bp), (String)fileName), (ServerPlayer)player);
        if (style.isEmpty()) {
            return;
        }
        boolean hasJigsaw = false;
        for (BlockState state : bp.getPalette()) {
            if (state.m_60734_() != Blocks.f_50678_) continue;
            hasJigsaw = true;
            break;
        }
        if (!hasJigsaw) {
            return;
        }
        BlockState primary = world.m_8055_(zero.m_121955_((Vec3i)bp.getPrimaryBlockOffset()));
        if (primary.m_60734_() instanceof AbstractBlockHut) {
            isHut = true;
            AbstractTileEntityColonyBuilding building = (AbstractTileEntityColonyBuilding)world.m_7702_(zero.m_121955_((Vec3i)bp.getPrimaryBlockOffset()));
            building.addTag(new BlockPos(0, 0, 0), "deactivated");
            building.addTag(new BlockPos(0, 0, 0), style);
        } else {
            isHut = false;
        }
        for (BlockPos mutablePos : BlockPos.m_121940_((BlockPos)zero, (BlockPos)zero.m_7918_(box.m_71056_() - 1, box.m_71057_() - 1, box.m_71058_() - 1))) {
            BlockState state = world.m_8055_(mutablePos);
            if (state.m_60734_() != Blocks.f_50678_) continue;
            JigsawBlockEntity jigsawBlockEntity = (JigsawBlockEntity)world.m_7702_(mutablePos);
            if (jigsawBlockEntity.m_59442_().m_135815_().isEmpty() || jigsawBlockEntity.m_59442_().m_135815_().equals("empty")) {
                if (jigsawBlockEntity.m_59445_().equals("minecraft:air")) {
                    jigsawBlockEntity.m_59431_("minecraft:structure_void");
                }
                if (isHut) {
                    jigsawBlockEntity.m_222763_(ResourceKey.m_135785_((ResourceKey)Registry.f_122884_, (ResourceLocation)new ResourceLocation("minecolonies:" + style + "/roads")));
                    jigsawBlockEntity.m_59435_(new ResourceLocation("minecolonies:building_entrance"));
                    jigsawBlockEntity.m_59438_(new ResourceLocation("minecolonies:building_entrance"));
                } else if (jigsawBlockEntity.m_222765_().m_135782_().m_135815_().contains("building")) {
                    jigsawBlockEntity.m_222763_(ResourceKey.m_135785_((ResourceKey)Registry.f_122884_, (ResourceLocation)new ResourceLocation("minecolonies:" + style + "/buildings")));
                    jigsawBlockEntity.m_59435_(new ResourceLocation("minecolonies:building_entrance"));
                    jigsawBlockEntity.m_59438_(new ResourceLocation("minecolonies:building_entrance"));
                } else {
                    jigsawBlockEntity.m_222763_(ResourceKey.m_135785_((ResourceKey)Registry.f_122884_, (ResourceLocation)new ResourceLocation("minecolonies:" + style + "/roads")));
                    jigsawBlockEntity.m_59435_(new ResourceLocation("minecolonies:street"));
                    jigsawBlockEntity.m_59438_(new ResourceLocation("minecolonies:street"));
                }
            }
            jigsawBlockEntity.m_6596_();
            world.m_7260_(mutablePos, state, state, 3);
        }
        StructureTemplateManager structuretemplatemanager = ((ServerLevel)world).m_215082_();
        try {
            ResourceLocation location = new ResourceLocation("structurize", ((String)fileName).replace(".blueprint", ""));
            StructureTemplate structuretemplate = structuretemplatemanager.m_230359_(location);
            structuretemplate.m_163802_(world, zero, (Vec3i)new BlockPos(box.m_71056_(), box.m_71057_(), box.m_71058_()), false, Blocks.f_50454_);
            Network.getNetwork().sendToPlayer(new SaveStructureNBTMessage(structuretemplate.m_74618_(new CompoundTag()), ((String)fileName).replace(".blueprint", ".nbt")), (ServerPlayer)player);
        }
        catch (ResourceLocationException resLocEx) {
            Log.getLogger().warn("Couldnt save nbt.");
        }
        if (isHut) {
            AbstractTileEntityColonyBuilding building = (AbstractTileEntityColonyBuilding)world.m_7702_(zero.m_121955_((Vec3i)bp.getPrimaryBlockOffset()));
            building.removeTag(new BlockPos(0, 0, 0), "deactivated");
            building.removeTag(new BlockPos(0, 0, 0), style);
        }
    }

    private static int execute(CommandSourceStack source, BlockPos from, BlockPos to, Optional<BlockPos> anchorPos, GameProfile profile, String name) throws CommandSyntaxException {
        ServerPlayer player;
        @Nullable ServerLevel world = source.m_81372_();
        if (source.m_81373_() instanceof Player && !source.m_81375_().m_7500_()) {
            source.m_81352_((Component)Component.m_237113_((String)NO_PERMISSION_MESSAGE));
        }
        if (profile != null && world.m_7654_() != null) {
            player = world.m_7654_().m_6846_().m_11259_(profile.getId());
            if (player == null) {
                source.m_81352_((Component)Component.m_237110_((String)PLAYER_NOT_FOUND, (Object[])new Object[]{profile.getName()}));
                return 0;
            }
        } else if (source.m_81373_() instanceof Player) {
            player = source.m_81375_();
        } else {
            source.m_81352_((Component)Component.m_237115_((String)PLAYER_NOT_FOUND));
            return 0;
        }
        ScanCommand.saveStructure((Level)world, (Player)player, new ScanToolData.Slot(name, new BoxPreviewData(from, to, anchorPos)), true);
        source.m_81352_((Component)Component.m_237115_((String)SCAN_SUCCESS_MESSAGE));
        return 1;
    }

    private static int onExecute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.m_174395_(context, (String)POS1);
        BlockPos to = BlockPosArgument.m_174395_(context, (String)POS2);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.empty(), null, null);
    }

    private static int onExecuteWithAnchor(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.m_174395_(context, (String)POS1);
        BlockPos to = BlockPosArgument.m_174395_(context, (String)POS2);
        BlockPos anchorPos = BlockPosArgument.m_174395_(context, (String)ANCHOR_POS);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.of(anchorPos), null, null);
    }

    private static int onExecuteWithPlayerName(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.m_174395_(context, (String)POS1);
        BlockPos to = BlockPosArgument.m_174395_(context, (String)POS2);
        GameProfile profile = GameProfileArgument.m_94590_(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.empty(), profile, null);
    }

    private static int onExecuteWithPlayerNameAndFileName(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.m_174395_(context, (String)POS1);
        BlockPos to = BlockPosArgument.m_174395_(context, (String)POS2);
        GameProfile profile = GameProfileArgument.m_94590_(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        String name = StringArgumentType.getString(context, (String)FILE_NAME);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.empty(), profile, name);
    }

    private static int onExecuteWithPlayerNameAndFileNameAndAnchorPos(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.m_174395_(context, (String)POS1);
        BlockPos to = BlockPosArgument.m_174395_(context, (String)POS2);
        BlockPos anchorPos = BlockPosArgument.m_174395_(context, (String)ANCHOR_POS);
        GameProfile profile = GameProfileArgument.m_94590_(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        String name = StringArgumentType.getString(context, (String)FILE_NAME);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.of(anchorPos), profile, name);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)ScanCommand.newLiteral((String)NAME).then(ScanCommand.newArgument((String)POS1, (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)ScanCommand.newArgument((String)POS2, (ArgumentType)BlockPosArgument.m_118239_()).executes(ScanCommand::onExecute)).then(ScanCommand.newArgument((String)ANCHOR_POS, (ArgumentType)BlockPosArgument.m_118239_()).executes(ScanCommand::onExecuteWithAnchor))).then(((RequiredArgumentBuilder)ScanCommand.newArgument((String)PLAYER_NAME, (ArgumentType)GameProfileArgument.m_94584_()).executes(ScanCommand::onExecuteWithPlayerName)).then(((RequiredArgumentBuilder)ScanCommand.newArgument((String)FILE_NAME, (ArgumentType)StringArgumentType.string()).executes(ScanCommand::onExecuteWithPlayerNameAndFileName)).then(ScanCommand.newArgument((String)ANCHOR_POS, (ArgumentType)BlockPosArgument.m_118239_()).executes(ScanCommand::onExecuteWithPlayerNameAndFileNameAndAnchorPos))))));
    }

    @NotNull
    public static String format(@NotNull ScanToolData.Slot slot) {
        String name = slot.getName().chars().anyMatch(c -> !StringReader.isAllowedInUnquotedString((char)((char)c))) ? StringTag.m_129303_((String)slot.getName()) : slot.getName();
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("/%s %s %s %s @p %s", "structurize", NAME, BlockPosUtil.format((BlockPos)slot.getBox().getPos1()), BlockPosUtil.format((BlockPos)slot.getBox().getPos2()), name));
        if (slot.getBox().getAnchor().isPresent() && BlockPosUtil.isInbetween((BlockPos)((BlockPos)slot.getBox().getAnchor().get()), (BlockPos)slot.getBox().getPos1(), (BlockPos)slot.getBox().getPos2())) {
            builder.append(' ');
            builder.append(BlockPosUtil.format((BlockPos)((BlockPos)slot.getBox().getAnchor().get())));
        }
        return builder.toString();
    }
}

