/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.core;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.effects.AbstractResearchEffect;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.requestsystem.requesters.IBuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCraftingRequestResolver
extends AbstractRequestResolver<IDeliverable>
implements IBuildingBasedRequester {
    public final boolean isPublicCrafter;
    private final JobEntry jobEntry;

    public AbstractCraftingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token, @NotNull JobEntry entry, boolean isPublicCrafter) {
        super(location, token);
        this.isPublicCrafter = isPublicCrafter;
        this.jobEntry = entry;
    }

    public JobEntry getJobEntry() {
        return this.jobEntry;
    }

    @Override
    public TypeToken<? extends IDeliverable> getRequestType() {
        return TypeToken.of(IDeliverable.class);
    }

    @Override
    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        if (!manager.getColony().getWorld().f_46443_) {
            return Optional.ofNullable(manager.getColony().getRequesterBuildingForPosition(this.getLocation().getInDimensionLocation()));
        }
        return Optional.empty();
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public int getSuitabilityMetric(@NotNull IRequest<? extends IDeliverable> request) {
        return (int)BlockPosUtil.getDistance(request.getRequester().getLocation().getInDimensionLocation(), this.getLocation().getInDimensionLocation());
    }

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends IDeliverable> requestToCheck) {
        if (!manager.getColony().getWorld().f_46443_) {
            ILocation requesterLocation = requestToCheck.getRequester().getLocation();
            if (this.isPublicCrafter || requesterLocation.equals(this.getLocation())) {
                Optional<AbstractBuilding> building = this.getBuilding(manager, (IToken<?>)requestToCheck.getId()).map(r -> (AbstractBuilding)r);
                return building.map(b -> this.canResolveForBuilding(manager, requestToCheck, (AbstractBuilding)b)).orElse(false);
            }
        }
        return false;
    }

    public boolean canResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        if (building.getBuildingLevel() <= 0 || building.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry).getAssignedCitizen().isEmpty()) {
            return false;
        }
        if (this.createsCraftingCycle(manager, request, request)) {
            return false;
        }
        if (!(request.getRequest() instanceof Food)) {
            return building.hasModule(WorkerBuildingModule.class) && this.canBuildingCraftStack(building, itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack));
        }
        if (building.hasModule(WorkerBuildingModule.class)) {
            for (ICraftingBuildingModule module : building.getModules(ICraftingBuildingModule.class)) {
                IRecipeStorage recipe = module.getFirstRecipe(itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack));
                if (recipe == null || recipe.getIntermediate() == Blocks.f_50094_) continue;
                return this.canBuildingCraftStack(building, itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack));
            }
        }
        return false;
    }

    protected boolean createsCraftingCycle(@NotNull IRequestManager manager, @NotNull IRequest<?> request, @NotNull IRequest<? extends IDeliverable> target) {
        return this.createsCraftingCycle(manager, request, target, 0, new ArrayList<IRequestable>());
    }

    protected boolean createsCraftingCycle(@NotNull IRequestManager manager, @NotNull IRequest<?> request, @NotNull IRequest<? extends IDeliverable> target, int count, List<IRequestable> reqs) {
        if (reqs.contains(request.getRequest())) {
            for (IRequestable requestable : reqs) {
                if (!requestable.equals(request.getRequest()) || !(request.getRequest() instanceof IDeliverable) || !(requestable instanceof IDeliverable) || ((IDeliverable)request.getRequest()).getCount() > ((IDeliverable)requestable).getCount()) continue;
                return true;
            }
        }
        reqs.add((IRequestable)request.getRequest());
        if (count > 20) {
            return true;
        }
        if (!request.equals(target) && request.getRequest().equals(target.getRequest()) && request.getRequest() instanceof IDeliverable && ((IDeliverable)request.getRequest()).getCount() <= target.getRequest().getCount() && !request.hasChildren()) {
            return true;
        }
        if (!request.hasParent()) {
            return false;
        }
        return this.createsCraftingCycle(manager, manager.getRequestForToken((IToken<?>)request.getParent()), target, count + 1, reqs);
    }

    public abstract boolean canBuildingCraftStack(@NotNull AbstractBuilding var1, Predicate<ItemStack> var2);

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getId()).map(r -> (AbstractBuilding)r).get();
        return this.attemptResolveForBuilding(manager, request, building);
    }

    @Nullable
    public List<IToken<?>> attemptResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        return this.attemptResolveForBuildingAndStack(manager, building, itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack), request.getRequest().getCount(), request.getRequest().getMinimumCount());
    }

    @Nullable
    protected List<IToken<?>> attemptResolveForBuildingAndStack(@NotNull IRequestManager manager, @NotNull AbstractBuilding building, @NotNull Predicate<ItemStack> stackPrecicate, int count, int minCount) {
        for (ICraftingBuildingModule module : building.getModules(ICraftingBuildingModule.class)) {
            IRecipeStorage craftableCrafting = module.getFirstRecipe(stackPrecicate);
            if (craftableCrafting == null) continue;
            return this.createRequestsForRecipe(manager, craftableCrafting, count, minCount);
        }
        return null;
    }

    @Nullable
    protected List<IToken<?>> createRequestsForRecipe(@NotNull IRequestManager manager, IRecipeStorage recipeRequest, int count, int minCount) {
        List<ItemStorage> inputs = recipeRequest.getCleanedInput();
        ItemStack requestStack = recipeRequest.getPrimaryOutput();
        List<ItemStack> secondaryStacks = recipeRequest.getCraftingToolsAndSecondaryOutputs();
        AbstractResearchEffect researchEffect = manager.getColony().getResearchManager().getResearchEffects().getEffect(ResearchConstants.CITIZEN_INV_SLOTS, AbstractResearchEffect.class);
        int extraSlots = researchEffect != null ? ((Double)researchEffect.getEffect()).intValue() : 0;
        int maxSlots = 27 + extraSlots - (27 + extraSlots) % 8;
        int recipeExecutionsCount = (int)Math.ceil((double)count / (double)requestStack.m_41613_());
        int minRecipeExecutionsCount = (int)Math.ceil((double)minCount / (double)requestStack.m_41613_());
        int batchSize = recipeExecutionsCount;
        int totalSlots = Integer.MAX_VALUE;
        while (totalSlots > maxSlots) {
            int stacksNeeded = (int)Math.ceil((double)(requestStack.m_41613_() * batchSize) / (double)requestStack.m_41741_());
            for (ItemStorage ingredient : inputs) {
                if (ItemStackUtils.compareItemStackListIgnoreStackSize(secondaryStacks, ingredient.getItemStack(), false, true)) {
                    ++stacksNeeded;
                    continue;
                }
                stacksNeeded += (int)Math.ceil((double)(ingredient.getAmount() * batchSize) / (double)ingredient.getItemStack().m_41741_());
            }
            if (stacksNeeded > maxSlots) {
                batchSize = (int)Math.floor((double)batchSize * ((double)maxSlots / (double)stacksNeeded));
            }
            totalSlots = Math.min(totalSlots, stacksNeeded);
        }
        ArrayList requests = new ArrayList();
        while (recipeExecutionsCount > 0) {
            requests.add(manager.createRequest(this, this.createNewRequestableForStack(requestStack.m_41777_(), Math.min(batchSize, recipeExecutionsCount), Math.max(1, Math.min(batchSize, minRecipeExecutionsCount)), recipeRequest.getToken())));
            recipeExecutionsCount -= batchSize;
            minRecipeExecutionsCount = minRecipeExecutionsCount > batchSize ? minRecipeExecutionsCount - batchSize : 0;
        }
        return ImmutableList.copyOf(requests);
    }

    protected abstract IRequestable createNewRequestableForStack(ItemStack var1, int var2, int var3, IToken<?> var4);

    @Override
    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getId()).map(r -> (AbstractBuilding)r).get();
        this.resolveForBuilding(manager, request, building);
    }

    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        manager.updateRequestState((IToken<?>)request.getId(), RequestState.RESOLVED);
    }
}

