/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IModuleWithExternalBlocks;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BedHandlingModule
extends AbstractBuildingModule
implements IModuleWithExternalBlocks,
IPersistentModule,
IBuildingEventsModule {
    @NotNull
    private final Set<BlockPos> bedList = new HashSet<BlockPos>();

    @Override
    public void deserializeNBT(CompoundTag compound) {
        ListTag bedTagList = compound.m_128437_("beds", 10);
        for (int i = 0; i < bedTagList.size(); ++i) {
            CompoundTag bedCompound = bedTagList.m_128728_(i);
            BlockPos bedPos = NbtUtils.m_129239_((CompoundTag)bedCompound);
            this.bedList.add(bedPos);
        }
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        if (!this.bedList.isEmpty()) {
            @NotNull ListTag bedTagList = new ListTag();
            for (BlockPos pos : this.bedList) {
                bedTagList.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            compound.m_128365_("beds", (Tag)bedTagList);
        }
    }

    @Override
    public void onBlockPlacedInBuilding(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level world) {
        BlockPos registrationPosition = pos;
        if (blockState.m_60734_() instanceof BedBlock) {
            if (blockState.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT) {
                registrationPosition = registrationPosition.m_121945_((Direction)blockState.m_61143_((Property)BedBlock.f_54117_));
            }
            this.bedList.add(registrationPosition);
        }
    }

    @Override
    public List<BlockPos> getRegisteredBlocks() {
        return new ArrayList<BlockPos>(this.bedList);
    }

    @Override
    public void onWakeUp() {
        Level world = this.building.getColony().getWorld();
        if (world == null) {
            return;
        }
        for (BlockPos pos : this.bedList) {
            BlockState state;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((state = world.m_8055_(pos)).m_60734_() instanceof BedBlock) || !((Boolean)state.m_61143_((Property)BedBlock.f_49441_)).booleanValue() || !((BedPart)state.m_61143_((Property)BedBlock.f_49440_)).equals((Object)BedPart.HEAD)) continue;
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(false)), 3);
        }
    }
}

