/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render.worldevent;

import com.ldtteam.structurize.util.WorldRenderMacros;
import com.minecolonies.coremod.client.render.worldevent.WorldEventContext;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;

public class HighlightManager {
    private static final Map<String, List<TimedBoxRenderData>> HIGHLIGHT_MAP = new HashMap<String, List<TimedBoxRenderData>>();

    static void render(WorldEventContext ctx) {
        if (HIGHLIGHT_MAP.isEmpty()) {
            return;
        }
        long worldTime = ctx.clientLevel.m_46467_();
        Iterator<List<TimedBoxRenderData>> categoryIterator = HIGHLIGHT_MAP.values().iterator();
        while (categoryIterator.hasNext()) {
            List<TimedBoxRenderData> boxes = categoryIterator.next();
            Iterator<TimedBoxRenderData> boxListIterator = boxes.iterator();
            while (boxListIterator.hasNext()) {
                TimedBoxRenderData boxRenderData = boxListIterator.next();
                if (boxRenderData.removalTimePoint <= worldTime) {
                    boxListIterator.remove();
                    continue;
                }
                MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
                WorldRenderMacros.renderLineBox((VertexConsumer)buffer.m_6299_(WorldRenderMacros.GLINT_LINES_WITH_WIDTH), (PoseStack)ctx.poseStack, (BlockPos)boxRenderData.pos, (int)boxRenderData.argbColor, (float)0.025f);
                if (!boxRenderData.text.isEmpty()) {
                    WorldRenderMacros.renderDebugText((BlockPos)boxRenderData.pos, boxRenderData.text, (PoseStack)ctx.poseStack, (boolean)true, (int)3, (MultiBufferSource)buffer);
                }
                buffer.m_109911_();
            }
            if (!boxes.isEmpty()) continue;
            categoryIterator.remove();
        }
    }

    public static void addRenderBox(String category, TimedBoxRenderData data) {
        HIGHLIGHT_MAP.computeIfAbsent(category, k -> new ArrayList()).add(data);
    }

    public static void clearCategory(String category) {
        HIGHLIGHT_MAP.remove(category);
    }

    public static class TimedBoxRenderData {
        private List<String> text = new ArrayList<String>();
        private BlockPos pos = BlockPos.f_121853_;
        private long removalTimePoint = 0L;
        private int argbColor = -1;

        public TimedBoxRenderData addText(String text) {
            this.text.add(text);
            return this;
        }

        public TimedBoxRenderData setRemovalTimePoint(long removalTimePoint) {
            this.removalTimePoint = removalTimePoint;
            return this;
        }

        public TimedBoxRenderData setPos(BlockPos pos) {
            this.pos = pos;
            return this;
        }

        public TimedBoxRenderData setColor(int argbColor) {
            this.argbColor = argbColor;
            return this;
        }
    }
}

