/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render.worldevent;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.StructureClientHandler;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.WorldRenderMacros;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.coremod.client.render.worldevent.WorldEventContext;
import com.minecolonies.coremod.colony.workorders.view.WorkOrderBuildingView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.phys.AABB;

public class ColonyBlueprintRenderer {
    private static final BlockPos INVALID_POS = BlockPos.f_121853_.m_6625_(500);
    private static final double CACHE_RESET_RANGE = 12.5;
    private static Map<BlockPos, RenderData> blueprintCache = new HashMap<BlockPos, RenderData>();
    private static BlockPos lastCacheRebuild = null;
    private static final Queue<PendingRenderData> pendingBlueprints = new LinkedList<PendingRenderData>();
    private static final List<IRenderBlueprintRule> renderRules = new ArrayList<IRenderBlueprintRule>();

    static void render(WorldEventContext ctx) {
        if (!ctx.hasNearestColony()) {
            blueprintCache.clear();
            lastCacheRebuild = null;
            return;
        }
        ArrayList<IRenderBlueprintRule> activeRules = new ArrayList<IRenderBlueprintRule>();
        for (IRenderBlueprintRule rule : renderRules) {
            if (!rule.isEnabled(ctx)) continue;
            activeRules.add(rule);
        }
        if (activeRules.isEmpty()) {
            blueprintCache.clear();
            lastCacheRebuild = null;
            return;
        }
        BlockPos activePosition = ctx.clientPlayer.m_20183_();
        if (lastCacheRebuild == null || !lastCacheRebuild.m_123314_((Vec3i)activePosition, 12.5)) {
            ColonyBlueprintRenderer.rebuildCache(ctx, activeRules);
            lastCacheRebuild = activePosition;
        }
        if (Minecraft.m_91087_().f_91073_.m_46467_() % 20L == 0L) {
            ColonyBlueprintRenderer.processPendingBlueprints();
        }
        for (Map.Entry<BlockPos, RenderData> entry : blueprintCache.entrySet()) {
            RenderData buildingData = entry.getValue();
            if (buildingData == null) continue;
            BlockPos position = entry.getKey();
            if (buildingData.blueprint != null && buildingData.blueprint.getBlueprint() != null) {
                StructureClientHandler.renderStructureAtPos((BlueprintPreviewData)buildingData.blueprint, (float)ctx.partialTicks, (BlockPos)position, (PoseStack)ctx.poseStack);
            }
            if (buildingData.box().getPos1() != INVALID_POS) {
                WorldRenderMacros.renderLineBox((VertexConsumer)ctx.bufferSource.m_6299_(WorldRenderMacros.LINES_WITH_WIDTH), (PoseStack)ctx.poseStack, (BlockPos)buildingData.box().getPos1(), (BlockPos)buildingData.box().getPos2(), (int)0, (int)0, (int)255, (int)255, (float)0.08f);
            }
            buildingData.box().getAnchor().ifPresent(pos -> {
                if (ctx.clientPlayer.m_6144_()) {
                    WorldRenderMacros.renderRedGlintLineBox((MultiBufferSource.BufferSource)WorldRenderMacros.getBufferSource(), (PoseStack)ctx.poseStack, (BlockPos)pos, (BlockPos)pos, (float)0.02f);
                }
            });
        }
    }

    private static void rebuildCache(WorldEventContext ctx, List<IRenderBlueprintRule> rules) {
        Collections.reverse(rules);
        HashMap<BlockPos, Supplier<PendingRenderData>> desired = new HashMap<BlockPos, Supplier<PendingRenderData>>();
        for (IRenderBlueprintRule rule : rules) {
            desired.putAll(rule.getDesiredBlueprints(ctx));
        }
        HashMap<BlockPos, RenderData> newCache = new HashMap<BlockPos, RenderData>();
        for (Map.Entry entry : desired.entrySet()) {
            if (blueprintCache.containsKey(entry.getKey())) {
                newCache.put((BlockPos)entry.getKey(), blueprintCache.get(entry.getKey()));
                continue;
            }
            newCache.put((BlockPos)entry.getKey(), null);
            pendingBlueprints.add((PendingRenderData)((Supplier)entry.getValue()).get());
        }
        blueprintCache = newCache;
    }

    private static void processPendingBlueprints() {
        PendingRenderData data;
        while (!pendingBlueprints.isEmpty() && ((data = pendingBlueprints.peek()).blueprint() == null || data.blueprint().isDone())) {
            try {
                pendingBlueprints.poll();
                if (data.blueprint() == null) {
                    if (data.boxOnly() && data.hasAnchor()) {
                        BoxPreviewData box = new BoxPreviewData(INVALID_POS, INVALID_POS, Optional.of(data.pos()));
                        blueprintCache.put(data.pos(), new RenderData(null, box));
                        continue;
                    }
                    blueprintCache.remove(data.pos());
                    continue;
                }
                Blueprint localBlueprint = data.blueprint().get();
                if (localBlueprint == null) {
                    blueprintCache.remove(data.pos());
                    continue;
                }
                if (!blueprintCache.containsKey(data.pos())) continue;
                BlueprintPreviewData blueprintPreviewData = new BlueprintPreviewData();
                blueprintPreviewData.setBlueprint(localBlueprint);
                blueprintPreviewData.setPos(data.pos());
                blueprintPreviewData.rotate(data.settings().getRotation());
                if (data.settings().getMirror() != Mirror.NONE) {
                    blueprintPreviewData.mirror();
                }
                BlockPos primaryOffset = localBlueprint.getPrimaryBlockOffset();
                BlockPos boxStartPos = data.pos().m_121996_((Vec3i)primaryOffset);
                BlockPos size = new BlockPos((int)localBlueprint.getSizeX(), (int)localBlueprint.getSizeY(), (int)localBlueprint.getSizeZ());
                BlockPos boxEndPos = boxStartPos.m_121955_((Vec3i)size).m_7918_(-1, -1, -1);
                BoxPreviewData box = new BoxPreviewData(boxStartPos, boxEndPos, data.hasAnchor() ? Optional.of(data.pos()) : Optional.empty());
                localBlueprint.setRenderSource(data.pos());
                if (data.boxOnly()) {
                    blueprintCache.put(data.pos(), new RenderData(null, box));
                    break;
                }
                blueprintCache.put(data.pos(), new RenderData(blueprintPreviewData, box));
                break;
            }
            catch (InterruptedException | ExecutionException exception) {
            }
        }
    }

    static {
        renderRules.add(new NearBuildPreview());
        renderRules.add(new BuildGoggles());
    }

    private static interface IRenderBlueprintRule {
        public boolean isEnabled(WorldEventContext var1);

        public Map<BlockPos, Supplier<PendingRenderData>> getDesiredBlueprints(WorldEventContext var1);
    }

    private record RenderData(BlueprintPreviewData blueprint, BoxPreviewData box) {
    }

    private record PendingRenderData(Future<Blueprint> blueprint, BlockPos pos, PlacementSettings settings, boolean boxOnly, boolean hasAnchor) {
    }

    private static class NearBuildPreview
    implements IRenderBlueprintRule {
        private NearBuildPreview() {
        }

        @Override
        public boolean isEnabled(WorldEventContext ctx) {
            return RenderingCache.getOrCreateBlueprintPreviewData((String)"blueprint").getBlueprint() != null && (Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getClient().neighborbuildingrendering.get() != false && ctx.mainHandItem.m_41720_() == ModItems.buildTool.get();
        }

        @Override
        public Map<BlockPos, Supplier<PendingRenderData>> getDesiredBlueprints(WorldEventContext ctx) {
            HashMap<BlockPos, Supplier<PendingRenderData>> desired = new HashMap<BlockPos, Supplier<PendingRenderData>>();
            BlockPos activePosition = RenderingCache.getOrCreateBlueprintPreviewData((String)"blueprint").getPos();
            Blueprint blueprint = RenderingCache.getOrCreateBlueprintPreviewData((String)"blueprint").getBlueprint();
            BlockPos zeroPos = activePosition.m_121996_((Vec3i)blueprint.getPrimaryBlockOffset());
            AABB blueprintAABB = new AABB(zeroPos, zeroPos.m_7918_(blueprint.getSizeX() - 1, blueprint.getSizeY() - 1, blueprint.getSizeZ() - 1)).m_82400_((double)(2 + (Integer)MinecoloniesAPIProxy.getInstance().getConfig().getClient().neighborbuildingrange.get()));
            for (IBuildingView buildingView : ctx.nearestColony.getBuildings()) {
                BlockPos cornerB;
                Tuple corners;
                BlockPos cornerA;
                if (buildingView.getBuildingType() == ModBuildings.postBox.get() || buildingView.getBuildingType() == ModBuildings.stash.get()) continue;
                BlockPos currentPosition = buildingView.getPosition();
                TileEntityColonyBuilding tileEntityColonyBuilding = (TileEntityColonyBuilding)ctx.clientLevel.m_7702_(buildingView.getPosition());
                if (tileEntityColonyBuilding == null || !blueprintAABB.m_82381_(new AABB(cornerA = (BlockPos)(corners = tileEntityColonyBuilding.getInWorldCorners()).m_14418_(), cornerB = (BlockPos)corners.m_14419_()))) continue;
                desired.put(currentPosition, () -> {
                    Object schemPath = buildingView.getStructurePath();
                    schemPath = ((String)schemPath).replace(".blueprint", "");
                    schemPath = ((String)schemPath).substring(0, ((String)schemPath).length() - 1) + buildingView.getBuildingMaxLevel() + ".blueprint";
                    String structurePack = buildingView.getStructurePack();
                    Future localBlueprint = StructurePacks.getBlueprintFuture((String)structurePack, (String)schemPath);
                    return new PendingRenderData(localBlueprint, currentPosition, new PlacementSettings(buildingView.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(buildingView.getRotation())), buildingView.getBuildingLevel() >= buildingView.getBuildingMaxLevel(), true);
                });
            }
            return desired;
        }
    }

    private static class BuildGoggles
    implements IRenderBlueprintRule {
        private BuildGoggles() {
        }

        @Override
        public boolean isEnabled(WorldEventContext ctx) {
            return ctx.clientPlayer.m_6844_(EquipmentSlot.HEAD).m_150930_(com.minecolonies.api.items.ModItems.buildGoggles);
        }

        @Override
        public Map<BlockPos, Supplier<PendingRenderData>> getDesiredBlueprints(WorldEventContext ctx) {
            double range = MathUtils.square(((Integer)MinecoloniesAPIProxy.getInstance().getConfig().getClient().buildgogglerange.get()).intValue());
            HashMap<BlockPos, Supplier<PendingRenderData>> desired = new HashMap<BlockPos, Supplier<PendingRenderData>>();
            for (IWorkOrderView workOrder : ctx.nearestColony.getWorkOrders()) {
                if (!(workOrder.getLocation().m_123331_((Vec3i)ctx.clientPlayer.m_20183_()) < range)) continue;
                desired.put(workOrder.getLocation(), () -> {
                    Future localBlueprint = StructurePacks.getBlueprintFuture((String)workOrder.getPackName(), (String)workOrder.getStructurePath());
                    return new PendingRenderData(localBlueprint, workOrder.getLocation(), new PlacementSettings(workOrder.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(workOrder.getRotation())), workOrder.getWorkOrderType() == WorkOrderType.REMOVE, workOrder instanceof WorkOrderBuildingView);
                });
            }
            for (IBuildingView building : ctx.nearestColony.getBuildings()) {
                if (desired.containsKey(building.getPosition()) || building.getBuildingLevel() != 0 || building.getBuildingMaxLevel() <= 0 || !(building.getPosition().m_123331_((Vec3i)ctx.clientPlayer.m_20183_()) < range)) continue;
                desired.put(building.getPosition(), () -> new PendingRenderData(null, building.getPosition(), new PlacementSettings(), true, true));
            }
            return desired;
        }
    }
}

