/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IStackBasedTask;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.IDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.coremod.colony.jobs.views.CrafterJobView;
import com.minecolonies.coremod.colony.jobs.views.DmanJobView;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WindowHutCrafterTaskModule
extends AbstractModuleWindow {
    private static final String LIST_TASKS = "tasks";

    public WindowHutCrafterTaskModule(IBuildingView view, String name) {
        super(view, name);
    }

    public void onOpened() {
        super.onOpened();
        final ArrayList tasks = new ArrayList();
        for (WorkerBuildingModuleView moduleView : this.buildingView.getModuleViews(WorkerBuildingModuleView.class)) {
            for (int citizenId : moduleView.getAssignedCitizens()) {
                ICitizenDataView citizen = this.buildingView.getColony().getCitizen(citizenId);
                if (citizen == null) continue;
                if (citizen.getJobView() instanceof CrafterJobView) {
                    tasks.addAll(((CrafterJobView)citizen.getJobView()).getDataStore().getQueue());
                    continue;
                }
                if (!(citizen.getJobView() instanceof DmanJobView)) continue;
                tasks.addAll(((DmanJobView)citizen.getJobView()).getDataStore().getQueue());
            }
        }
        ((ScrollingList)this.findPaneOfTypeByID(LIST_TASKS, ScrollingList.class)).setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                tasks.removeIf(token -> WindowHutCrafterTaskModule.this.buildingView.getColony().getRequestManager().getRequestForToken((IToken<?>)token) == null);
                return tasks.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                IRequest<?> request = WindowHutCrafterTaskModule.this.buildingView.getColony().getRequestManager().getRequestForToken((IToken)tasks.get(index));
                IRequest<?> parent = WindowHutCrafterTaskModule.this.buildingView.getColony().getRequestManager().getRequestForToken((IToken<?>)request.getParent());
                while (parent != null && parent.getRequester().getLocation().equals(request.getRequester().getLocation())) {
                    IRequest<?> tempParent = WindowHutCrafterTaskModule.this.buildingView.getColony().getRequestManager().getRequestForToken((IToken<?>)parent.getParent());
                    if (tempParent == null) continue;
                    parent = tempParent;
                }
                if (parent == null) {
                    ((Text)rowPane.findPaneOfTypeByID("requester", Text.class)).setText(request.getRequester().getRequesterDisplayName(WindowHutCrafterTaskModule.this.buildingView.getColony().getRequestManager(), request));
                } else {
                    ((Text)rowPane.findPaneOfTypeByID("requester", Text.class)).setText(Component.m_237113_((String)(request.getRequester().getRequesterDisplayName(WindowHutCrafterTaskModule.this.buildingView.getColony().getRequestManager(), request).getString() + " -> " + parent.getRequester().getRequesterDisplayName(WindowHutCrafterTaskModule.this.buildingView.getColony().getRequestManager(), parent).getString())));
                    PaneBuilders.tooltipBuilder().hoverPane(rowPane.findPaneOfTypeByID("requester", Text.class)).build().setText(Component.m_237113_((String)(request.getRequester().getLocation().getInDimensionLocation().m_123344_() + " -> " + parent.getRequester().getLocation().getInDimensionLocation().m_123344_())));
                }
                if (request instanceof IStackBasedTask) {
                    ItemIcon icon = (ItemIcon)rowPane.findPaneOfTypeByID("detailIcon", ItemIcon.class);
                    ItemStack copyStack = ((IStackBasedTask)((Object)request)).getTaskStack().m_41777_();
                    copyStack.m_41764_(((IStackBasedTask)((Object)request)).getDisplayCount());
                    icon.setItem(copyStack);
                    icon.setVisible(true);
                    ((Text)rowPane.findPaneOfTypeByID("shortDetail", Text.class)).setText(((IStackBasedTask)((Object)request)).getDisplayPrefix().m_130940_(request.getState() == RequestState.IN_PROGRESS ? ChatFormatting.DARK_GREEN : ChatFormatting.BLACK));
                } else {
                    ((ItemIcon)rowPane.findPaneOfTypeByID("detailIcon", ItemIcon.class)).setVisible(false);
                    ((Text)rowPane.findPaneOfTypeByID("shortDetail", Text.class)).setText(Component.m_237113_((String)request.getShortDisplayString().getString().replace("\u00a7f", "")).m_130940_(request.getState() == RequestState.IN_PROGRESS ? ChatFormatting.DARK_GREEN : ChatFormatting.BLACK));
                }
                if (request.getRequest() instanceof IDeliverymanRequestable) {
                    ((Text)rowPane.findPaneOfTypeByID("priority", Text.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.deliveryman.priority").m_130946_(String.valueOf(((IDeliverymanRequestable)request.getRequest()).getPriority())));
                }
                Image logo = (Image)rowPane.findPaneOfTypeByID("deliveryImage", Image.class);
                logo.setImage(request.getDisplayIcon(), false);
            }
        });
    }
}

