/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.sounds;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.sounds.MercenarySounds;
import com.minecolonies.api.sounds.RaidSounds;
import com.minecolonies.api.sounds.RaiderSounds;
import com.minecolonies.api.sounds.TavernSounds;
import com.minecolonies.api.util.Tuple;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.DeferredRegister;

public final class ModSoundEvents {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((ResourceKey)Registry.f_122898_, (String)"minecolonies");
    public static Map<String, Map<EventType, Tuple<SoundEvent, SoundEvent>>> CITIZEN_SOUND_EVENTS = new HashMap<String, Map<EventType, Tuple<SoundEvent, SoundEvent>>>();
    public static SoundEvent SAW;

    private ModSoundEvents() {
    }

    public static SoundEvent getSoundID(String soundName) {
        return new SoundEvent(new ResourceLocation("minecolonies", soundName));
    }

    static {
        for (ResourceLocation resourceLocation : ModJobs.getJobs()) {
            if (!resourceLocation.m_135827_().equals("minecolonies") || resourceLocation.m_135815_().equals("placeholder")) continue;
            HashMap<EventType, Tuple<SoundEvent, SoundEvent>> map = new HashMap<EventType, Tuple<SoundEvent, SoundEvent>>();
            for (EventType soundEvents : EventType.values()) {
                SoundEvent maleSoundEvent = ModSoundEvents.getSoundID("mob." + resourceLocation.m_135815_() + ".male." + soundEvents.name().toLowerCase(Locale.US));
                SoundEvent femaleSoundEvent = ModSoundEvents.getSoundID("mob." + resourceLocation.m_135815_() + ".female." + soundEvents.name().toLowerCase(Locale.US));
                SOUND_EVENTS.register(maleSoundEvent.m_11660_().m_135815_(), () -> maleSoundEvent);
                SOUND_EVENTS.register(femaleSoundEvent.m_11660_().m_135815_(), () -> femaleSoundEvent);
                map.put(soundEvents, new Tuple<SoundEvent, SoundEvent>(maleSoundEvent, femaleSoundEvent));
            }
            CITIZEN_SOUND_EVENTS.put(resourceLocation.m_135815_(), map);
        }
        HashMap<EventType, Tuple<SoundEvent, SoundEvent>> citizenMap = new HashMap<EventType, Tuple<SoundEvent, SoundEvent>>();
        for (EventType soundEvents : EventType.values()) {
            SoundEvent soundEvent = ModSoundEvents.getSoundID("mob.citizen.male." + soundEvents.name().toLowerCase(Locale.US));
            SoundEvent femaleSoundEvent = ModSoundEvents.getSoundID("mob.citizen.female." + soundEvents.name().toLowerCase(Locale.US));
            SOUND_EVENTS.register(soundEvent.m_11660_().m_135815_(), () -> maleSoundEvent);
            SOUND_EVENTS.register(femaleSoundEvent.m_11660_().m_135815_(), () -> femaleSoundEvent);
            citizenMap.put(soundEvents, new Tuple<SoundEvent, SoundEvent>(soundEvent, femaleSoundEvent));
        }
        CITIZEN_SOUND_EVENTS.put("citizen", citizenMap);
        HashMap<EventType, Tuple<SoundEvent, SoundEvent>> hashMap = new HashMap<EventType, Tuple<SoundEvent, SoundEvent>>();
        for (EventType eventType : EventType.values()) {
            SoundEvent maleSoundEvent = ModSoundEvents.getSoundID("mob.child.male." + eventType.name().toLowerCase(Locale.US));
            SoundEvent femaleSoundEvent = ModSoundEvents.getSoundID("mob.child.female." + eventType.name().toLowerCase(Locale.US));
            SOUND_EVENTS.register(maleSoundEvent.m_11660_().m_135815_(), () -> maleSoundEvent);
            SOUND_EVENTS.register(femaleSoundEvent.m_11660_().m_135815_(), () -> femaleSoundEvent);
            hashMap.put(eventType, new Tuple<SoundEvent, SoundEvent>(maleSoundEvent, femaleSoundEvent));
        }
        CITIZEN_SOUND_EVENTS.put("child", hashMap);
        SOUND_EVENTS.register(TavernSounds.tavernTheme.m_11660_().m_135815_(), () -> TavernSounds.tavernTheme);
        for (Enum enum_ : RaiderType.values()) {
            SoundEvent raiderHurt = ModSoundEvents.getSoundID("mob." + enum_.name().toLowerCase(Locale.US) + ".hurt");
            SoundEvent raiderDeath = ModSoundEvents.getSoundID("mob." + enum_.name().toLowerCase(Locale.US) + ".death");
            SoundEvent raiderSay = ModSoundEvents.getSoundID("mob." + enum_.name().toLowerCase(Locale.US) + ".say");
            SOUND_EVENTS.register(raiderHurt.m_11660_().m_135815_(), () -> raiderHurt);
            SOUND_EVENTS.register(raiderDeath.m_11660_().m_135815_(), () -> raiderDeath);
            SOUND_EVENTS.register(raiderSay.m_11660_().m_135815_(), () -> raiderSay);
            HashMap<RaiderSounds.RaiderSoundTypes, SoundEvent> sounds = new HashMap<RaiderSounds.RaiderSoundTypes, SoundEvent>();
            sounds.put(RaiderSounds.RaiderSoundTypes.HURT, raiderHurt);
            sounds.put(RaiderSounds.RaiderSoundTypes.DEATH, raiderDeath);
            sounds.put(RaiderSounds.RaiderSoundTypes.SAY, raiderSay);
            RaiderSounds.raiderSounds.put((RaiderType)enum_, sounds);
        }
        SAW = ModSoundEvents.getSoundID("tile.sawmill.saw");
        SOUND_EVENTS.register(SAW.m_11660_().m_135815_(), () -> SAW);
        SOUND_EVENTS.register(RaidSounds.WARNING.m_11660_().m_135815_(), () -> RaidSounds.WARNING);
        SOUND_EVENTS.register(RaidSounds.WARNING_EARLY.m_11660_().m_135815_(), () -> RaidSounds.WARNING_EARLY);
        SOUND_EVENTS.register(RaidSounds.VICTORY.m_11660_().m_135815_(), () -> RaidSounds.VICTORY);
        SOUND_EVENTS.register(RaidSounds.VICTORY_EARLY.m_11660_().m_135815_(), () -> RaidSounds.VICTORY_EARLY);
        SOUND_EVENTS.register(RaidSounds.AMAZON_RAID.m_11660_().m_135815_(), () -> RaidSounds.AMAZON_RAID);
        SOUND_EVENTS.register(RaidSounds.DESERT_RAID.m_11660_().m_135815_(), () -> RaidSounds.DESERT_RAID);
        SOUND_EVENTS.register(RaidSounds.DESERT_RAID_WARNING.m_11660_().m_135815_(), () -> RaidSounds.DESERT_RAID_WARNING);
        SOUND_EVENTS.register(MercenarySounds.mercenaryAttack.m_11660_().m_135815_(), () -> MercenarySounds.mercenaryAttack);
        SOUND_EVENTS.register(MercenarySounds.mercenaryCelebrate.m_11660_().m_135815_(), () -> MercenarySounds.mercenaryCelebrate);
        SOUND_EVENTS.register(MercenarySounds.mercenaryDie.m_11660_().m_135815_(), () -> MercenarySounds.mercenaryDie);
        SOUND_EVENTS.register(MercenarySounds.mercenaryHurt.m_11660_().m_135815_(), () -> MercenarySounds.mercenaryHurt);
        SOUND_EVENTS.register(MercenarySounds.mercenarySay.m_11660_().m_135815_(), () -> MercenarySounds.mercenarySay);
        SOUND_EVENTS.register(MercenarySounds.mercenaryStep.m_11660_().m_135815_(), () -> MercenarySounds.mercenaryStep);
    }
}

