/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.colonyEvents.registry;

import com.minecolonies.api.colony.colonyEvents.descriptions.IColonyEventDescription;
import com.minecolonies.api.util.Log;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ColonyEventDescriptionTypeRegistryEntry {
    private final Function<CompoundTag, IColonyEventDescription> nbtEventDescriptionCreator;
    private final Function<FriendlyByteBuf, IColonyEventDescription> packetBufferEventDescriptionCreator;
    private final ResourceLocation registryName;

    public ColonyEventDescriptionTypeRegistryEntry(@NotNull Function<CompoundTag, IColonyEventDescription> nbtEventCreator, @NotNull Function<FriendlyByteBuf, IColonyEventDescription> packetBufferEventCreator, @NotNull ResourceLocation registryID) {
        if (registryID.m_135815_().isEmpty()) {
            Log.getLogger().warn("Created empty registry empty for event, supply a name for it!");
        }
        this.nbtEventDescriptionCreator = nbtEventCreator;
        this.packetBufferEventDescriptionCreator = packetBufferEventCreator;
        this.registryName = registryID;
    }

    public IColonyEventDescription deserializeEventDescriptionFromNBT(@Nonnull CompoundTag compound) {
        return this.nbtEventDescriptionCreator.apply(compound);
    }

    public IColonyEventDescription deserializeEventDescriptionFromFriendlyByteBuf(@Nonnull FriendlyByteBuf buffer) {
        return this.packetBufferEventDescriptionCreator.apply(buffer);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

