/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.colytra.common.crafting;

import com.illusivesoulworks.colytra.common.ColytraConfig;
import com.illusivesoulworks.colytra.common.ElytraTag;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;

public class ElytraDetachmentRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<ElytraDetachmentRecipe> CRAFTING_DETACH_ELYTRA = new SimpleRecipeSerializer(ElytraDetachmentRecipe::new);

    public ElytraDetachmentRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        if (ColytraConfig.SERVER.colytraMode.get() != ColytraConfig.ColytraMode.NORMAL) {
            return false;
        }
        ItemStack itemstack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack currentStack = inv.m_8020_(i);
            if (currentStack.m_41619_()) continue;
            if (!itemstack.m_41619_() || !ElytraTag.hasUpgrade(currentStack)) {
                return false;
            }
            itemstack = currentStack;
        }
        return !itemstack.m_41619_();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack itemstack = ItemStack.f_41583_;
        for (int k = 0; k < inv.m_6643_(); ++k) {
            ItemStack currentStack = inv.m_8020_(k);
            if (currentStack.m_41619_()) continue;
            if (!itemstack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            itemstack = ElytraTag.getElytra(currentStack);
        }
        if (!itemstack.m_41619_()) {
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack currentStack = inv.m_8020_(i);
            if (currentStack.m_41619_() || !ElytraTag.hasUpgrade(currentStack)) continue;
            currentStack.m_41749_("colytra:ElytraUpgrade");
            nonnulllist.set(i, (Object)currentStack.m_41777_());
            break;
        }
        return nonnulllist;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return CRAFTING_DETACH_ELYTRA;
    }
}

