/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.colytra.common.crafting;

import com.illusivesoulworks.colytra.common.ColytraConfig;
import com.illusivesoulworks.colytra.common.ElytraTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ElytraAttachmentRecipe
extends CustomRecipe {
    public static final List<Item> VALID_ITEMS = new ArrayList<Item>();
    public static final SimpleRecipeSerializer<ElytraAttachmentRecipe> CRAFTING_ATTACH_ELYTRA = new SimpleRecipeSerializer(ElytraAttachmentRecipe::new);

    public ElytraAttachmentRecipe(ResourceLocation id) {
        super(id);
    }

    private static void mergeEnchantments(ItemStack source, ItemStack destination) {
        Map mapSource = EnchantmentHelper.m_44831_((ItemStack)source);
        Map mapDestination = EnchantmentHelper.m_44831_((ItemStack)destination);
        for (Enchantment enchantment : mapSource.keySet()) {
            int srcLevel;
            if (enchantment == null || !enchantment.m_6081_(destination)) continue;
            int destLevel = mapDestination.getOrDefault(enchantment, 0);
            srcLevel = destLevel == (srcLevel = ((Integer)mapSource.get(enchantment)).intValue()) ? srcLevel + 1 : Math.max(srcLevel, destLevel);
            for (Enchantment destEnch : mapDestination.keySet()) {
                if (enchantment == destEnch || destEnch.m_44695_(enchantment)) continue;
                return;
            }
            if (srcLevel > enchantment.m_6586_()) {
                srcLevel = enchantment.m_6586_();
            }
            mapDestination.put(enchantment, srcLevel);
        }
        EnchantmentHelper.m_44865_((Map)mapDestination, (ItemStack)destination);
        EnchantmentHelper.m_44865_(new HashMap(), (ItemStack)source);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        ItemStack itemstack = ItemStack.f_41583_;
        ItemStack elytra = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack currentStack = inv.m_8020_(i);
            if (currentStack.m_41619_()) continue;
            if (ElytraAttachmentRecipe.isValid(currentStack)) {
                if (!itemstack.m_41619_() || ElytraTag.hasUpgrade(currentStack)) {
                    return false;
                }
                itemstack = currentStack;
                continue;
            }
            if (!elytra.m_41619_() || !(currentStack.m_41720_() instanceof ElytraItem)) {
                return false;
            }
            elytra = currentStack;
        }
        return !itemstack.m_41619_() && !elytra.m_41619_();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack itemstack = ItemStack.f_41583_;
        ItemStack elytra = ItemStack.f_41583_;
        for (int k = 0; k < inv.m_6643_(); ++k) {
            ItemStack currentStack = inv.m_8020_(k);
            if (currentStack.m_41619_()) continue;
            if (ElytraAttachmentRecipe.isValid(currentStack)) {
                if (!itemstack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                itemstack = currentStack.m_41777_();
                itemstack.m_41764_(1);
                continue;
            }
            if (!(currentStack.m_41720_() instanceof ElytraItem)) {
                return ItemStack.f_41583_;
            }
            elytra = currentStack.m_41777_();
        }
        if (!itemstack.m_41619_() && !elytra.m_41619_()) {
            if (ColytraConfig.SERVER.colytraMode.get() != ColytraConfig.ColytraMode.NORMAL) {
                ElytraAttachmentRecipe.mergeEnchantments(elytra, itemstack);
                itemstack.m_41742_(elytra.m_41610_() + itemstack.m_41610_());
                Component name = elytra.m_41786_();
                boolean hasCustomName = elytra.m_41788_();
                elytra = new ItemStack((ItemLike)Items.f_42741_);
                if (hasCustomName) {
                    elytra.m_41714_(name);
                }
            }
            itemstack.m_41784_().m_128365_("colytra:ElytraUpgrade", (Tag)elytra.m_41739_(new CompoundTag()));
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return CRAFTING_ATTACH_ELYTRA;
    }

    private static boolean isValid(ItemStack stack) {
        ColytraConfig.PermissionMode permissionMode = (ColytraConfig.PermissionMode)((Object)ColytraConfig.SERVER.permissionMode.get());
        boolean isBlacklist = permissionMode == ColytraConfig.PermissionMode.BLACKLIST;
        return isBlacklist != VALID_ITEMS.contains(stack.m_41720_()) && Mob.m_147233_((ItemStack)stack) == EquipmentSlot.CHEST && !(stack.m_41720_() instanceof ElytraItem);
    }
}

