/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.colytra.common;

import com.illusivesoulworks.colytra.common.ColytraConfig;
import com.illusivesoulworks.colytra.platform.Services;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;

public class ElytraTag {
    public static final String ELYTRA_TAG = "colytra:ElytraUpgrade";

    public static boolean hasUpgrade(ItemStack stack) {
        return stack.m_41737_(ELYTRA_TAG) != null;
    }

    public static ItemStack getElytra(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(ELYTRA_TAG);
        return tag != null ? ItemStack.m_41712_((CompoundTag)tag) : ItemStack.f_41583_;
    }

    public static void setElytra(ItemStack chestStack, ItemStack elytraStack) {
        chestStack.m_41784_().m_128365_(ELYTRA_TAG, (Tag)elytraStack.m_41739_(new CompoundTag()));
    }

    public static void damageElytra(LivingEntity livingEntity, ItemStack chestStack, ItemStack elytraStack, int amount) {
        ColytraConfig.ColytraMode colytraMode = (ColytraConfig.ColytraMode)((Object)ColytraConfig.SERVER.colytraMode.get());
        if (colytraMode == ColytraConfig.ColytraMode.NORMAL) {
            elytraStack.m_41622_(amount, livingEntity, damager -> damager.m_21166_(EquipmentSlot.CHEST));
        } else if (colytraMode == ColytraConfig.ColytraMode.UNISON) {
            if (Services.PLATFORM.hasEnergy(chestStack)) {
                Services.PLATFORM.extractEnergy(chestStack);
            } else {
                chestStack.m_41622_(amount, livingEntity, damager -> damager.m_21166_(EquipmentSlot.CHEST));
            }
        }
        ElytraTag.setElytra(chestStack, elytraStack);
    }

    public static boolean isUseable(ItemStack chestStack, ItemStack elytraStack) {
        if (elytraStack.m_41619_()) {
            return false;
        }
        ColytraConfig.ColytraMode colytraMode = (ColytraConfig.ColytraMode)((Object)ColytraConfig.SERVER.colytraMode.get());
        if (colytraMode == ColytraConfig.ColytraMode.NORMAL) {
            return elytraStack.m_41720_() instanceof ElytraItem && ElytraItem.m_41140_((ItemStack)elytraStack);
        }
        if (colytraMode == ColytraConfig.ColytraMode.UNISON) {
            if (Services.PLATFORM.hasEnergy(chestStack)) {
                return Services.PLATFORM.canExtractEnergy(chestStack);
            }
            return !chestStack.m_41763_() || chestStack.m_41773_() < chestStack.m_41776_() - 1;
        }
        return true;
    }
}

