/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.colytra.common;

import com.illusivesoulworks.colytra.common.crafting.ElytraAttachmentRecipe;
import com.illusivesoulworks.colytra.platform.Services;
import com.illusivesoulworks.spectrelib.config.SpectreConfigSpec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.tuple.Pair;

public class ColytraConfig {
    public static final SpectreConfigSpec SERVER_SPEC;
    public static final Server SERVER;
    private static final String CONFIG_PREFIX = "gui.colytra.config.";

    public static void reload() {
        ElytraAttachmentRecipe.VALID_ITEMS.clear();
        ((List)ColytraConfig.SERVER.permissionList.get()).forEach(id -> {
            Item item = Services.PLATFORM.getItem(ResourceLocation.m_135820_((String)id));
            if (item != null) {
                ElytraAttachmentRecipe.VALID_ITEMS.add(item);
            }
        });
    }

    static {
        Pair specPair = new SpectreConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (SpectreConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final SpectreConfigSpec.EnumValue<PermissionMode> permissionMode;
        public final SpectreConfigSpec.ConfigValue<List<? extends String>> permissionList;
        public final SpectreConfigSpec.EnumValue<ColytraMode> colytraMode;
        public final SpectreConfigSpec.IntValue energyUsage;

        public Server(SpectreConfigSpec.Builder builder) {
            builder.push("general");
            this.permissionMode = builder.comment("Sets whether the permission list is a blacklist or whitelist").translation("gui.colytra.config.permissionMode").defineEnum("permissionMode", (Enum)PermissionMode.BLACKLIST);
            this.permissionList = builder.comment("List of items by registry name to be blacklisted/whitelisted based on Permission Mode").translation("gui.colytra.config.permissionList").defineList("permissionList", new ArrayList(), s -> s instanceof String);
            this.colytraMode = builder.comment("Sets how the elytra chestplates will behave\nNORMAL: Elytras will exist separately from the chestplate, able to be separated later\nUNISON: Elytras will fuse completely with the chestplate, unable to be separated\nPERFECT: Elytras will fuse completely with the chestplate and flying will not use durability").translation("gui.colytra.config.colytraMode").defineEnum("colytraMode", (Enum)ColytraMode.NORMAL);
            this.energyUsage = builder.comment("How much energy per second elytra flight uses if Unison mode is active and the chestplate uses energy").translation("gui.colytra.config.energyUsage").defineInRange("energyUsage", 1000, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static enum ColytraMode {
        NORMAL,
        UNISON,
        PERFECT;

    }

    public static enum PermissionMode {
        BLACKLIST,
        WHITELIST;

    }
}

