/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flowerpatch.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mrbysco.flowerpatch.FlowerPatch;
import com.mrbysco.flowerpatch.block.FlowerPatchBlock;
import com.mrbysco.flowerpatch.block.PatchBlock;
import com.mrbysco.flowerpatch.registry.PatchRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PatchDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_236039_(event.includeServer(), (DataProvider)new Loots(generator));
            PatchBlockTags provider = new PatchBlockTags(generator, helper);
            generator.m_236039_(event.includeServer(), (DataProvider)provider);
            generator.m_236039_(event.includeServer(), (DataProvider)new PatchItemTags(generator, provider, helper));
        }
        if (event.includeClient()) {
            generator.m_236039_(event.includeClient(), (DataProvider)new Language(generator));
            generator.m_236039_(event.includeClient(), (DataProvider)new BlockModels(generator, helper));
            generator.m_236039_(event.includeClient(), (DataProvider)new BlockStates(generator, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(PatchBlockLoot::new, (Object)LootContextParamSets.f_81421_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)name, (LootTable)table));
        }

        public static class PatchBlockLoot
        extends BlockLoot {
            protected void addTables() {
                for (RegistryObject registryObject : PatchRegistry.BLOCKS.getEntries()) {
                    Object object = registryObject.get();
                    if (!(object instanceof PatchBlock)) continue;
                    PatchBlock patch = (PatchBlock)object;
                    Block patchBlock = (Block)registryObject.get();
                    this.m_124175_(patchBlock, block -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)PatchBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)patch.getPatchDelegate().get())).m_230984_(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), value -> SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)value.intValue())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)patchBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)patch.getProperty(), value.intValue()))))))));
                }
            }

            protected Iterable<Block> getKnownBlocks() {
                return PatchRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    public static class PatchBlockTags
    extends BlockTagsProvider {
        public PatchBlockTags(DataGenerator generator, @Nullable ExistingFileHelper existingFileHelper) {
            super(generator, "flowerpatch", existingFileHelper);
        }

        protected void m_6577_() {
            for (RegistryObject registryObject : PatchRegistry.BLOCKS.getEntries()) {
                Object object = registryObject.get();
                if (!(object instanceof FlowerPatchBlock)) continue;
                FlowerPatchBlock flowerPatchBlock = (FlowerPatchBlock)object;
                this.m_206424_(BlockTags.f_13041_).m_126582_((Object)flowerPatchBlock);
            }
            this.m_206424_(FlowerPatch.BONEMEAL_ABLE_FLOWERS).m_126584_((Object[])new Block[]{Blocks.f_50111_, Blocks.f_50112_, Blocks.f_50113_, Blocks.f_50114_, Blocks.f_50115_, Blocks.f_50116_, Blocks.f_50117_, Blocks.f_50118_, Blocks.f_50119_, Blocks.f_50120_, Blocks.f_50121_, Blocks.f_50071_});
        }
    }

    public static class PatchItemTags
    extends ItemTagsProvider {
        public PatchItemTags(DataGenerator dataGenerator, BlockTagsProvider blockTagsProvider, ExistingFileHelper existingFileHelper) {
            super(dataGenerator, blockTagsProvider, "flowerpatch", existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(FlowerPatch.BONEMEAL).m_126582_((Object)Items.f_42499_);
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(DataGenerator gen) {
            super(gen, "flowerpatch", "en_us");
        }

        protected void addTranslations() {
            for (RegistryObject registryObject : PatchRegistry.BLOCKS.getEntries()) {
                Object object = registryObject.get();
                if (!(object instanceof PatchBlock)) continue;
                PatchBlock patchBlock = (PatchBlock)object;
                this.addBlock((Supplier)registryObject, I18n.m_118938_((String)patchBlock.getPatchDelegate().get().m_7705_(), (Object[])new Object[0]) + " Patch");
            }
        }
    }

    private static class BlockModels
    extends BlockModelProvider {
        public BlockModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "flowerpatch", helper);
        }

        protected void registerModels() {
            for (RegistryObject registryObject : PatchRegistry.BLOCKS.getEntries()) {
                if (!(registryObject.get() instanceof PatchBlock)) continue;
                this.generatePatchModels((Block)registryObject.get());
            }
        }

        protected void generatePatchModels(Block block) {
            this.crossBlock(block);
        }

        private void crossBlock(Block block) {
            this.patchBlock(block, 2);
            this.patchBlock(block, 3);
            this.patchBlock(block, 4);
        }

        private BlockModelBuilder patchBlock(Block block, int flowers) {
            String path = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_" + flowers;
            return (BlockModelBuilder)((BlockModelBuilder)this.singleTexture(path, this.modLoc("block/patch" + flowers), "cross", this.mcLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((PatchBlock)block).getPatchDelegate().get()).m_135815_()))).renderType("cutout");
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "flowerpatch", helper);
        }

        protected void registerStatesAndModels() {
            for (RegistryObject registryObject : PatchRegistry.BLOCKS.getEntries()) {
                if (!(registryObject.get() instanceof PatchBlock)) continue;
                this.generatePatchState((Block)registryObject.get());
            }
        }

        protected void generatePatchState(Block block) {
            ModelFile.ExistingModelFile patchModel2 = this.models().getExistingFile(this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_2"));
            ModelFile.ExistingModelFile patchModel3 = this.models().getExistingFile(this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_3"));
            ModelFile.ExistingModelFile patchModel4 = this.models().getExistingFile(this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_4"));
            PatchBlock patchBlock = (PatchBlock)block;
            this.getVariantBuilder(block).partialState().with((Property)patchBlock.getProperty(), (Comparable)Integer.valueOf(2)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)patchModel2), new ConfiguredModel((ModelFile)patchModel2, 0, 90, false), new ConfiguredModel((ModelFile)patchModel2, 0, 180, false), new ConfiguredModel((ModelFile)patchModel2, 0, 270, false)}).partialState().with((Property)patchBlock.getProperty(), (Comparable)Integer.valueOf(3)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)patchModel3), new ConfiguredModel((ModelFile)patchModel3, 0, 90, false), new ConfiguredModel((ModelFile)patchModel3, 0, 180, false), new ConfiguredModel((ModelFile)patchModel3, 0, 270, false)}).partialState().with((Property)patchBlock.getProperty(), (Comparable)Integer.valueOf(4)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)patchModel4), new ConfiguredModel((ModelFile)patchModel4, 0, 90, false), new ConfiguredModel((ModelFile)patchModel4, 0, 180, false), new ConfiguredModel((ModelFile)patchModel4, 0, 270, false)});
        }
    }
}

