/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import stepsword.mahoutsukai.util.JobType;
import stepsword.mahoutsukai.util.MahouJobs;

public class NodeNetworkUtil {
    public static void buildNetworkIterative(UUID uuid, ArrayList<BlockPos> toExplore, HashSet<BlockPos> explored, BlockPos pos, Level level, int distance, int maxIters, Predicate<BlockEntity> predicate, Consumer<HashSet<BlockPos>> callback) {
        System.out.println(level.m_46467_());
        if (toExplore == null) {
            toExplore = new ArrayList();
        }
        if (explored == null) {
            explored = new HashSet();
        }
        if (pos != null && !explored.contains(pos)) {
            toExplore.add(pos);
        }
        boolean cont = true;
        for (int i = 0; i < maxIters && (cont = NodeNetworkUtil.explore(toExplore, explored, level, distance, predicate)); ++i) {
        }
        if (cont) {
            MahouJobs.addJob(uuid, new JobType.NodeNetworkJob(uuid, toExplore, explored, pos, level, distance, maxIters, predicate, callback));
        } else {
            callback.accept(NodeNetworkUtil.verifyNetwork(level, explored, predicate));
        }
    }

    public static boolean explore(ArrayList<BlockPos> toExplore, HashSet<BlockPos> explored, Level level, int distance, Predicate<BlockEntity> pred) {
        if (toExplore.size() == 0) {
            return false;
        }
        BlockPos explore = toExplore.remove(0);
        ChunkAccess pp = level.m_46865_(explore.m_7918_(distance, 0, distance));
        ChunkAccess mm = level.m_46865_(explore.m_7918_(-distance, 0, -distance));
        int maxx = pp.m_7697_().f_45578_;
        int maxz = pp.m_7697_().f_45579_;
        int minx = mm.m_7697_().f_45578_;
        int minz = mm.m_7697_().f_45579_;
        for (int i = minx; i < maxx + 1; ++i) {
            for (int j = minz; j < maxz + 1; ++j) {
                LevelChunk chunk = level.m_6325_(i, j);
                Map map = chunk.m_62954_();
                Set s = map.keySet();
                for (BlockPos p : s) {
                    BlockEntity te;
                    if (explored.contains(p) || explore.equals((Object)p) || p.m_123341_() >= explore.m_123341_() + distance || p.m_123341_() <= explore.m_123341_() - distance || p.m_123343_() >= explore.m_123343_() + distance || p.m_123343_() <= explore.m_123343_() - distance || !pred.test(te = (BlockEntity)map.get(p)) || toExplore.contains(p)) continue;
                    toExplore.add(p);
                }
            }
        }
        explored.add(explore);
        return true;
    }

    public static HashSet<BlockPos> verifyNetwork(Level level, HashSet<BlockPos> network, Predicate<BlockEntity> pred) {
        return new HashSet<BlockPos>(network.stream().filter(te -> pred.test(level.m_7702_(te))).collect(Collectors.toSet()));
    }
}

