/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.displacement;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;

public class OrderedDisplacementMahoujinTileEntity
extends MahoujinTileEntity
implements BlockEntityTicker<OrderedDisplacementMahoujinTileEntity> {
    private int tickCounter = 0;
    private int receivingTickCounter = 0;
    public static String TELEPORTER_ID_TAG = "MAHOUTSUKAI_TELEPORTER_ID";
    private long teleporter_id;

    public OrderedDisplacementMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.orderedDisplacement.get(), p, bs);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128356_(TELEPORTER_ID_TAG, this.teleporter_id);
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.teleporter_id = compound.m_128454_(TELEPORTER_ID_TAG);
        super.m_142466_(compound);
    }

    public long getTeleporterId() {
        return this.teleporter_id;
    }

    public void setTeleporterId(long t) {
        this.teleporter_id = t;
    }

    public void setReceivingTickCounter(int t) {
        this.receivingTickCounter = t;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, OrderedDisplacementMahoujinTileEntity blockEntity) {
        if (!level.f_46443_) {
            if (this.receivingTickCounter <= 0) {
                if (this.tickCounter == MTConfig.ORDERED_DISPLACEMENT_BLOCK_CYCLE) {
                    BlockPos target;
                    List lst = level.m_45976_(Entity.class, new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 1)));
                    if (!lst.isEmpty() && (target = this.getTarget()) != null) {
                        Player caster = this.getCaster();
                        for (Entity entityIn : lst) {
                            boolean nearbyBatteriesGaveMana;
                            if (entityIn.m_20163_() || !(nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.f_58858_, level, this.getCasterUUID(), MTConfig.ORDERED_DISPLACEMENT_MANA_COST)) && (caster == null || PlayerManaManager.drainMana(caster, MTConfig.ORDERED_DISPLACEMENT_MANA_COST, false, false) != MTConfig.ORDERED_DISPLACEMENT_MANA_COST)) continue;
                            MahouTsukaiTeleporter.teleport(entityIn, (double)target.m_123341_() + 0.5, target.m_123342_(), (double)target.m_123343_() + 0.5, EffectUtil.getDimension(entityIn.f_19853_));
                            BlockEntity te = level.m_7702_(target);
                            if (!(te instanceof OrderedDisplacementMahoujinTileEntity)) continue;
                            OrderedDisplacementMahoujinTileEntity mte = (OrderedDisplacementMahoujinTileEntity)te;
                            mte.setReceivingTickCounter(MTConfig.ORDERED_DISPLACEMENT_RECEIVE_COOLDOWN);
                        }
                    }
                    this.tickCounter = 0;
                }
                ++this.tickCounter;
            } else {
                --this.receivingTickCounter;
            }
        }
    }

    public BlockPos getTarget() {
        int radius = MTConfig.ORDERED_DISPLACEMENT_RADIUS;
        ChunkPos cpa = new ChunkPos(this.f_58858_.m_7918_(-radius, -radius, -radius));
        ChunkPos cpb = new ChunkPos(this.f_58858_.m_7918_(radius, radius, radius));
        HashSet<BlockPos> poss = new HashSet<BlockPos>();
        for (int i = cpa.f_45578_; i < cpb.f_45578_ + 1; ++i) {
            for (int j = cpa.f_45579_; j < cpb.f_45579_ + 1; ++j) {
                LevelChunk c = this.f_58857_.m_6325_(i, j);
                poss.addAll(c.m_62954_().entrySet().stream().filter(a -> a.getValue() instanceof OrderedDisplacementMahoujinTileEntity).collect(Collectors.toMap(x -> (BlockPos)x.getKey(), x -> (BlockEntity)x.getValue())).keySet());
            }
        }
        BlockPos target = null;
        long targetID = -1L;
        BlockPos backupTarget = null;
        long lowestID = -1L;
        for (BlockPos z : poss) {
            OrderedDisplacementMahoujinTileEntity mte;
            BlockEntity te = this.f_58857_.m_7702_(z);
            if (!(te instanceof OrderedDisplacementMahoujinTileEntity) || this.f_58858_.equals((Object)z) || !(mte = (OrderedDisplacementMahoujinTileEntity)te).getCasterUUID().equals(this.getCasterUUID()) || radius < Math.abs(z.m_123341_() - this.f_58858_.m_123341_()) || radius < Math.abs(z.m_123343_() - this.f_58858_.m_123343_())) continue;
            if ((targetID == -1L || mte.getTeleporterId() < targetID) && mte.getTeleporterId() > this.getTeleporterId()) {
                targetID = mte.getTeleporterId();
                target = z;
            }
            if (mte.getTeleporterId() >= lowestID && lowestID != -1L) continue;
            lowestID = mte.getTeleporterId();
            backupTarget = z;
        }
        if (targetID < this.getTeleporterId()) {
            return backupTarget;
        }
        return target;
    }
}

