/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.tile.SingleUseMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class BoundaryMahoujinTileEntity
extends SingleUseMahoujinTileEntity
implements BlockEntityTicker<BoundaryMahoujinTileEntity> {
    private static final String SWITCH_ON = "SWITCH_ON";
    private static final int TICKS_PER_SECOND = 20;
    public HashSet<UUID> entitiesInBarrier = null;
    private boolean switchOn = false;
    private boolean performBarrierFunction = false;
    private int tickCounter = 0;
    private int manaTickCounter = 0;
    private boolean livingOnly = true;

    public BoundaryMahoujinTileEntity(BlockPos p, BlockState bs) {
        super(p, bs);
        this.livingOnly = true;
    }

    public BoundaryMahoujinTileEntity(boolean l, BlockPos p, BlockState bs) {
        super(p, bs);
        this.livingOnly = l;
    }

    public BoundaryMahoujinTileEntity(BlockEntityType type, BlockPos p, BlockState bs) {
        super(type, p, bs);
        this.livingOnly = true;
    }

    public BoundaryMahoujinTileEntity(BlockEntityType type, boolean livingOnly, BlockPos p, BlockState bs) {
        this(type, p, bs);
        this.livingOnly = livingOnly;
    }

    public int getManaCost() {
        return 0;
    }

    public int getManaCycle() {
        return 20;
    }

    public int getBarrierCycle() {
        return 20;
    }

    public int getBarrierRadius() {
        return 10;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128379_(SWITCH_ON, this.switchOn);
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.switchOn = compound.m_128471_(SWITCH_ON);
        super.m_142466_(compound);
    }

    public void toggle(Player e) {
        if (ContractMahoujinTileEntity.isImmuneToSpell(this.f_58857_, this.getCasterUUID(), (Entity)e) || this.isFay()) {
            if (this.isFay()) {
                this.setCaster(e);
            }
            this.performBarrierFunction = this.switchOn = !this.switchOn;
            this.manaTickCounter = 0;
            this.tickCounter = 0;
            this.sendUpdates();
        }
    }

    public boolean getSwitchOn() {
        return this.switchOn;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, BoundaryMahoujinTileEntity blockEntity) {
        if (!level.f_46443_) {
            if (this.manaTickCounter == this.getManaCycle() * 20) {
                boolean nearbyBatteriesGaveMana;
                IMahou mahou;
                this.manaTickCounter = 0;
                Player caster = this.getCaster();
                boolean redstoneSwitchOn = this.shouldIPerformBarrier();
                if (caster != null && redstoneSwitchOn && (mahou = Utils.getPlayerMahou(caster)) != null && caster.f_19853_.m_46467_() - mahou.getCancelTime() < (long)(this.getManaCycle() * 20 * 3)) {
                    this.toggle(caster);
                }
                boolean bl = nearbyBatteriesGaveMana = redstoneSwitchOn && PlayerManaManager.getManaFromBatteriesFirst(this.f_58858_, level, this.getCasterUUID(), this.getManaCost());
                if (!nearbyBatteriesGaveMana && caster == null && redstoneSwitchOn) {
                    redstoneSwitchOn = false;
                    this.manaTickCounter = 0;
                    this.tickCounter = 0;
                    this.sendUpdates();
                }
                this.performBarrierFunction = !redstoneSwitchOn ? false : (!nearbyBatteriesGaveMana ? PlayerManaManager.drainMana(caster, this.getManaCost(), false, true, true, true) == this.getManaCost() : true);
                level.m_46717_(this.f_58858_, level.m_8055_(this.f_58858_).m_60734_());
            }
            if (this.tickCounter == this.getBarrierCycle()) {
                this.tickCounter = 0;
                if (this.performBarrierFunction) {
                    AABB aabb = new AABB((double)(this.f_58858_.m_123341_() - this.getBarrierRadius()), (double)(this.f_58858_.m_123342_() - this.getBarrierRadius()), (double)(this.f_58858_.m_123343_() - this.getBarrierRadius()), (double)(this.f_58858_.m_123341_() + this.getBarrierRadius()), (double)(this.f_58858_.m_123342_() + this.getBarrierRadius()), (double)(this.f_58858_.m_123343_() + this.getBarrierRadius()));
                    if (this.livingOnly) {
                        List entities = this.f_58857_.m_6443_(LivingEntity.class, aabb, Entity::m_6084_);
                        this.doBarrier(entities);
                        this.entitiesInBarrier = new HashSet(entities.stream().map(Entity::m_20148_).collect(Collectors.toCollection(HashSet::new)));
                    } else {
                        List entities = this.f_58857_.m_6443_(Entity.class, aabb, Entity::m_6084_);
                        this.doBarrierNonLiving(entities);
                    }
                } else {
                    this.doNotBarrier();
                }
            }
            ++this.tickCounter;
            ++this.manaTickCounter;
        }
    }

    public void doBarrier(List<LivingEntity> lst) {
    }

    public void doNotBarrier() {
    }

    public boolean shouldIPerformBarrier() {
        boolean powered = this.f_58857_.m_46753_(this.f_58858_);
        if (this.getCasterUUID() == null) {
            return false;
        }
        if (powered) {
            return !this.switchOn;
        }
        return this.switchOn;
    }

    public void doBarrierNonLiving(List<Entity> lst) {
    }

    public void pickupOrToggle(Level worldIn, Player playerIn) {
        BlockEntity te;
        if (!worldIn.f_46443_ && (te = worldIn.m_7702_(this.f_58858_)) instanceof BoundaryMahoujinTileEntity) {
            BoundaryMahoujinTileEntity mte = (BoundaryMahoujinTileEntity)te;
            if (!mte.hasCloth()) {
                mte.toggle(playerIn);
            } else if (this.f_58857_ != null) {
                this.f_58857_.m_46597_(this.f_58858_, EffectUtil.AIR);
            }
        }
    }
}

