/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class RipperInvisiblePacket {
    int entityids;
    boolean invisible;

    public RipperInvisiblePacket() {
    }

    public RipperInvisiblePacket(int e, boolean b) {
        this.entityids = e;
        this.invisible = b;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityids = buf.readInt();
        this.invisible = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityids);
        buf.writeBoolean(this.invisible);
    }

    public static void encode(RipperInvisiblePacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static RipperInvisiblePacket decode(FriendlyByteBuf buf) {
        RipperInvisiblePacket msg = new RipperInvisiblePacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(RipperInvisiblePacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.updateInvisible(message);
        context.get().setPacketHandled(true);
    }
}

