/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RhoAiasMahoujinEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final String TAG_LOOK_VEC = "MAHOUTSUKAI_LOOK_VEC";
    public static final int loadUpTime = 20;
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 1.0E-4, 1.0E-4, 1.0E-4);
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<CompoundTag> LOOK_VEC = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.m_135353_(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public UUID casterUUID = null;
    public static final String entityName = "rho_aias_mahoujin_entity";

    public RhoAiasMahoujinEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public RhoAiasMahoujinEntity(Level world) {
        super((EntityType)ModEntities.RHO_AIAS.get(), world);
        this.f_19811_ = true;
    }

    public RhoAiasMahoujinEntity(Level world, Player caster) {
        this(world);
        this.casterUUID = caster.m_20148_();
        this.f_19804_.m_135381_(CASTER_UUID, Optional.of(this.casterUUID));
    }

    public RhoAiasMahoujinEntity(Level world, Player caster, float r, float g, float b, float a, float r2, float g2, float b2, float size) {
        this(world);
        this.casterUUID = caster.m_20148_();
        this.f_19804_.m_135381_(CASTER_UUID, Optional.of(this.casterUUID));
        this.setColor(r, g, b, a, r2, g2, b2);
        this.angleForPlayer(caster);
        this.sizer(size);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_R2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_A, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DISTANCE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LOOK_VEC, (Object)new CompoundTag());
        this.f_19804_.m_135372_(CASTER_UUID, Optional.empty());
    }

    public float getSphereMidRadius() {
        float sphereMidRadius = 7.8f;
        return sphereMidRadius;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20334_(0.0, 0.0, 0.0);
        try {
            if (this.casterUUID == null) {
                this.casterUUID = (UUID)((Optional)this.f_19804_.m_135370_(CASTER_UUID)).get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.f_19859_ = this.f_19857_;
        if (this.f_19859_ < 0.0f) {
            this.f_19859_ += 360.0f;
        }
        this.setRotationYaw(this.getRotationYaw() + this.getRotationSpeed());
        this.f_19857_ = this.getRotationYaw();
        this.f_19858_ = this.getRotationPitch();
        this.m_19915_(this.f_19857_, this.f_19858_);
        if (!this.f_19853_.f_46443_) {
            this.setLife(this.getLife() + 1);
            if (this.casterUUID == null) {
                this.m_146870_();
            } else {
                Player caster = this.f_19853_.m_46003_(this.casterUUID);
                if (caster == null || !caster.m_6084_()) {
                    this.m_146870_();
                }
            }
            if (this.getLife() >= MTConfig.RHO_AIAS_LIFE) {
                this.m_146870_();
            }
        }
        this.projectileDeletion();
        this.collideWithNearbyEntities();
    }

    public boolean m_6087_() {
        return false;
    }

    public void m_6123_(Player entityIn) {
        if (!entityIn.m_20148_().equals(this.casterUUID)) {
            // empty if block
        }
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        this.f_19804_.m_135381_(COLOR_R2, (Object)Float.valueOf(r2));
        this.f_19804_.m_135381_(COLOR_G2, (Object)Float.valueOf(g2));
        this.f_19804_.m_135381_(COLOR_B2, (Object)Float.valueOf(b2));
        this.f_19804_.m_135381_(COLOR_A, (Object)Float.valueOf(a));
    }

    protected void m_20101_() {
    }

    @Nullable
    public AABB m_20191_() {
        return ZERO_AABB;
    }

    public float[] getColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_A)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_R2)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G2)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B2)).floatValue()};
    }

    public void angleForPlayer(Player user) {
        Vec3 vec = user.m_20154_().m_82541_().m_82490_(5.0);
        this.setLookV(user.m_20154_().m_82541_());
        Vec3 eyes = user.m_20299_(1.0f);
        this.m_6034_(eyes.f_82479_ + vec.f_82479_, eyes.f_82480_ + vec.f_82480_, eyes.f_82481_ + vec.f_82481_);
        double theta = Math.asin(vec.f_82480_ / 5.0);
        theta = RhoAiasMahoujinEntity.fromRad(theta);
        this.setRotationPitch((float)(90.0 - theta));
        this.setRotationRoll(360.0f - user.f_19857_);
    }

    public static double fromRad(double rad) {
        return rad * 57.2957795131;
    }

    public void setCasterUUID(UUID uuid) {
        this.casterUUID = uuid;
    }

    public void sizer(float s) {
        this.setCircleSize(s);
    }

    protected void collideWithNearbyEntities() {
        float size = this.getCircleSize();
        AABB maabb = new AABB(this.m_20185_() - (double)size, this.m_20186_() - (double)size, this.m_20189_() - (double)size, this.m_20185_() + (double)size, this.m_20186_() + (double)size, this.m_20189_() + (double)size);
        List list = this.f_19853_.m_6249_((Entity)this, maabb.m_82400_(2.0), Entity::m_6084_);
        if (!list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                int collide;
                Entity entity = (Entity)list.get(l);
                try {
                    if (MTConfig.RHO_AIAS_SNEAK_BOOP && entity.m_20148_().equals(((Optional)this.f_19804_.m_135370_(CASTER_UUID)).get()) && !entity.m_20163_()) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((collide = this.doesItCollide(entity)) == 3 || collide == 1) {
                    this.collideWithEntity(entity);
                    continue;
                }
                if (collide != 0) continue;
            }
        }
    }

    public int doesItCollide(Entity entity) {
        AABB aabb = entity.m_20191_();
        boolean flag = false;
        boolean flag1 = false;
        if (aabb != null) {
            Vec3 a1 = new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_);
            Vec3 a2 = new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82293_);
            Vec3 a3 = new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82290_);
            Vec3 a4 = new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
            Vec3 b1 = new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82290_);
            Vec3 b2 = new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82293_);
            Vec3 b3 = new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82290_);
            Vec3 b4 = new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
            int f1 = this.whereIsPoint(a1);
            int f2 = this.whereIsPoint(a2);
            int f3 = this.whereIsPoint(a3);
            int f4 = this.whereIsPoint(a4);
            int f5 = this.whereIsPoint(b1);
            int f6 = this.whereIsPoint(b2);
            int f7 = this.whereIsPoint(b3);
            int f8 = this.whereIsPoint(b4);
            flag = f1 == 1 || f2 == 1 || f3 == 1 || f4 == 1 || f5 == 1 || f6 == 1 || f7 == 1 || f8 == 1;
            boolean bl = flag1 = f1 == 2 || f2 == 2 || f3 == 2 || f4 == 2 || f5 == 2 || f6 == 2 || f7 == 2 || f8 == 2;
        }
        if (flag && flag1) {
            return 3;
        }
        if (flag) {
            return 1;
        }
        if (flag1) {
            return 2;
        }
        return 0;
    }

    public void projectileDeletion() {
        if (!this.f_19853_.f_46443_) {
            int radius = MTConfig.RHO_AIAS_KILL_RANGE;
            double posX = this.m_20185_();
            double posY = this.m_20186_();
            double posZ = this.m_20189_();
            AABB paabb = new AABB(posX - (double)radius, posY - (double)radius, posZ - (double)radius, posX + (double)radius, posY + (double)radius, posZ + (double)radius);
            List<? extends String> killList = MTConfig.RHO_AIAS_ENTITY_KILL_LIST;
            List<? extends String> collideList = MTConfig.RHO_AIAS_COLLIDE_KILL_LIST;
            if (killList.size() > 0) {
                HashSet<? extends String> set = new HashSet<String>(killList);
                HashSet<? extends String> set2 = new HashSet<String>(collideList);
                List lst = this.f_19853_.m_45976_(Entity.class, paabb);
                for (Entity e : lst) {
                    int z;
                    if (e instanceof Player || e instanceof RhoAiasMahoujinEntity || Utils.getRegistryKey(e) == null) continue;
                    String regname = Utils.getRegistryName(e);
                    if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                        System.out.println("found entity near Rho Aias:" + regname);
                    }
                    if (set.contains(regname.toString())) {
                        Vec3 v = e.m_20184_();
                        Vec3 p = e.m_20182_();
                        if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                            System.out.println("found entity on kill list:" + regname + ":pos:" + p.toString() + ":vel:" + v.toString());
                        }
                        if (this.isPointInRadiusOfCircle(p.m_82549_(v)) && !this.isPointInRadiusOfCircle(p)) {
                            e.m_146870_();
                        }
                        if (!this.isPointInRadiusOfCircle(p.m_82549_(v.m_82490_(-1.0))) && this.isPointInRadiusOfCircle(p)) {
                            e.m_146870_();
                        }
                    }
                    if (!set2.contains(regname) || (z = this.doesItCollide(e)) != 1 && z != 3) continue;
                    e.m_146870_();
                }
            }
        }
    }

    protected void collideWithEntity(Entity entityIn) {
        if (entityIn instanceof Arrow) {
            Arrow arrow = (Arrow)entityIn;
            if (arrow.m_37282_() == null || !arrow.m_37282_().m_20148_().equals(this.casterUUID)) {
                arrow.m_20334_(0.0, 0.0, 0.0);
                arrow.f_36697_ = 3;
                arrow.f_19857_ = this.getRotationYaw();
                arrow.f_19858_ = this.getRotationPitch();
                arrow.f_19864_ = true;
            }
        } else if (entityIn instanceof Projectile) {
            Projectile throwable = (Projectile)entityIn;
            Entity thrower = throwable.m_37282_();
            if (thrower == null || !thrower.m_20148_().equals(this.casterUUID)) {
                throwable.m_20256_(new Vec3(-throwable.m_20184_().f_82479_, -throwable.m_20184_().f_82480_, -throwable.m_20184_().f_82481_));
                if (entityIn instanceof AbstractHurtingProjectile) {
                    AbstractHurtingProjectile e = (AbstractHurtingProjectile)throwable;
                    e.f_36813_ = -e.f_36813_;
                    e.f_36814_ = -e.f_36814_;
                    e.f_36815_ = -e.f_36815_;
                }
                if (this.casterUUID != null && this.f_19853_.m_46003_(this.casterUUID) != null) {
                    throwable.f_37244_ = this.casterUUID;
                }
            }
        } else if (entityIn instanceof LivingEntity && this.getLookV() != null) {
            Vec3 v = this.getLookV();
            this.boop(entityIn, 1.0f, -v.f_82479_, -v.f_82480_, -v.f_82481_);
        }
    }

    private void boop(Entity entity, float strength, double x, double y, double z) {
        entity.f_19812_ = true;
        float f = Mth.m_14116_((float)((float)(x * x + z * z + y * y)));
        Vec3 motion = this.m_20184_();
        double motionX = motion.m_7096_();
        double motionY = motion.m_7098_();
        double motionZ = motion.m_7094_();
        motionX /= 2.0;
        motionZ /= 2.0;
        motionY /= 2.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.f_19864_ = true;
        if (entity.m_20096_()) {
            motionY /= 2.0;
            if ((motionY += (double)strength) > (double)0.4f) {
                motionY = 0.4f;
            }
        }
        entity.m_20334_(motionX, motionY, motionZ);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setRotationYaw(compound.m_128457_(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.m_128457_(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.m_128457_(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.m_128457_(TAG_ROTATION_SPEED));
        this.setCircleSize(compound.m_128457_(TAG_CIRCLE_SIZE));
        this.setLife(compound.m_128451_(TAG_LIFE));
        this.casterUUID = compound.m_128342_(TAG_CASTER);
        this.setColor(compound.m_128457_(TAG_COLOR_R), compound.m_128457_(TAG_COLOR_G), compound.m_128457_(TAG_COLOR_B), compound.m_128457_(TAG_COLOR_A), compound.m_128457_(TAG_COLOR_R2), compound.m_128457_(TAG_COLOR_G2), compound.m_128457_(TAG_COLOR_B2));
        this.setDistance(compound.m_128457_(TAG_DISTANCE));
        CompoundTag look = compound.m_128469_(TAG_LOOK_VEC);
        this.setLookV(new Vec3(look.m_128459_("x"), look.m_128459_("y"), look.m_128459_("z")));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.m_128350_(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.m_128350_(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.m_128350_(TAG_ROTATION_SPEED, this.getRotationSpeed());
        compound.m_128350_(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.m_128405_(TAG_LIFE, this.getLife());
        compound.m_128362_(TAG_CASTER, this.casterUUID);
        float[] colors = this.getColor();
        compound.m_128350_(TAG_COLOR_R, colors[0]);
        compound.m_128350_(TAG_COLOR_G, colors[1]);
        compound.m_128350_(TAG_COLOR_B, colors[2]);
        compound.m_128350_(TAG_COLOR_A, colors[3]);
        compound.m_128350_(TAG_COLOR_R2, colors[4]);
        compound.m_128350_(TAG_COLOR_G2, colors[5]);
        compound.m_128350_(TAG_COLOR_B2, colors[6]);
        compound.m_128350_(TAG_DISTANCE, this.getDistance());
        Vec3 look = this.getLookV();
        CompoundTag looknbt = new CompoundTag();
        looknbt.m_128347_("x", look.f_82479_);
        looknbt.m_128347_("y", look.f_82480_);
        looknbt.m_128347_("z", look.f_82481_);
        compound.m_128365_(TAG_LOOK_VEC, (Tag)looknbt);
    }

    public boolean isPointInRadiusOfCircle(Vec3 pos) {
        Vec3 sphereMid = this.getSphereMid();
        double distance = pos.m_82554_(sphereMid);
        return distance < (double)this.getSphereMidRadius();
    }

    public boolean isPointInShieldRectangle(Vec3 pos) {
        float xside = 4.0f;
        float yside = 6.0f;
        float zside = 6.0f;
        Vec3 rotatedpos = this.rotateAroundOrigin(pos, EffectUtil.toRad(90.0f - this.getRotationPitch()), EffectUtil.toRad(-this.getRotationRoll() + 90.0f), 0.0f);
        return rotatedpos.f_82479_ > this.m_20185_() - (double)xside && rotatedpos.f_82479_ < this.m_20185_() + 0.5 && rotatedpos.f_82480_ > this.m_20186_() - (double)yside && rotatedpos.f_82480_ < this.m_20186_() + (double)yside && rotatedpos.f_82481_ > this.m_20189_() - (double)zside && rotatedpos.f_82481_ < this.m_20189_() + (double)zside;
    }

    public Vec3 getSphereMid() {
        Vec3 sphereMid = this.m_20182_().m_82546_(this.getLookV().m_82541_().m_82490_((double)this.getSphereMidRadius() - 0.5));
        return sphereMid;
    }

    public int whereIsPoint(Vec3 pos) {
        if (!this.isPointInShieldRectangle(pos)) {
            return 0;
        }
        if (this.isPointInRadiusOfCircle(pos)) {
            return 1;
        }
        return 2;
    }

    public Vec3 rotateAroundOrigin(Vec3 pos, float pitch, float roll, float yaw) {
        Vec3 rho = this.m_20182_();
        return rho.m_82549_(this.rotateRoll(pos.m_82546_(rho).m_82524_(roll), pitch));
    }

    public Vec3 rotateRoll(Vec3 v, float roll) {
        float f = Mth.m_14089_((float)roll);
        float f1 = Mth.m_14031_((float)roll);
        double d0 = v.f_82479_ * (double)f + v.f_82480_ * (double)f1;
        double d1 = v.f_82480_ * (double)f - v.f_82479_ * (double)f1;
        double d2 = v.f_82481_;
        return new Vec3(d0, d1, d2);
    }

    public AABB m_6921_() {
        return bb;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getRotationYaw() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.f_19804_.m_135381_(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.f_19804_.m_135381_(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.f_19804_.m_135381_(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.f_19804_.m_135381_(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.f_19804_.m_135370_(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.f_19804_.m_135381_(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(int l) {
        this.f_19804_.m_135381_(LIFE, (Object)l);
    }

    public float getDistance() {
        return ((Float)this.f_19804_.m_135370_(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.f_19804_.m_135381_(DISTANCE, (Object)Float.valueOf(d));
    }

    public Vec3 getLookV() {
        CompoundTag nbt = (CompoundTag)this.f_19804_.m_135370_(LOOK_VEC);
        return new Vec3(nbt.m_128459_("x"), nbt.m_128459_("y"), nbt.m_128459_("z"));
    }

    public void setLookV(Vec3 v) {
        if (v != null) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("x", v.f_82479_);
            nbt.m_128347_("y", v.f_82480_);
            nbt.m_128347_("z", v.f_82481_);
            this.f_19804_.m_135381_(LOOK_VEC, (Object)nbt);
        }
    }
}

