/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.butterfly;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.entity.butterfly.SerializableBlockBreak;
import stepsword.mahoutsukai.entity.butterfly.SerializableBlockPlace;
import stepsword.mahoutsukai.entity.butterfly.SerializableHit;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ButterflyEntity
extends Entity {
    public static final String entityName = "butterfly_entity";
    private static final String TAG_SIZE = "MAHOUTSUKAI_SIZE";
    private static final String TAG_RANDOM_SEED = "MAHOUTSUKAI_RANDOM_SEED";
    private static final String TAG_PLACE_BLOCK = "MAHOUTSUKAI_PLACE_BLOCK";
    private static final String TAG_BREAK_BLOCK = "MAHOUTSUKAI_BREAK_BLOCK";
    private static final String TAG_HIT = "MAHOUTSUKAI_HIT";
    private static final String TAG_DYING = "MAHOUTSUKAI_DYING";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_EFFECT = "MAHOUTSUKAI_EFFECT";
    public EFFECT effect = EFFECT.NONE;
    boolean colorstarted = false;
    int dying = 0;
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> RANDOM_SEED = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DYING = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> CASTER = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private AABB zero = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public AABB aabb;
    public BlockPos origPos;
    public BlockPos origPos1;
    public float angle = 0.0f;
    public float prevangle = 0.0f;
    public float wingspeed = 0.0f;
    public float topstop = 89.0f;
    public float bottomstop = -29.0f;
    public float defaultSize = 0.3f;
    public Random rng;
    public float[][] colors = new float[6][4];
    public float[][] targets = new float[6][4];
    SerializableBlockPlace placeBlock;
    SerializableBlockBreak breakBlock;
    SerializableHit hit;

    public ButterflyEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public ButterflyEntity(Level world) {
        super((EntityType)ModEntities.BUTTERFLY.get(), world);
        this.f_19811_ = true;
    }

    public ButterflyEntity(Level world, Player caster, int seed, float size) {
        this(world);
        this.setCasterUUID(caster.m_20148_());
        this.setSize(size);
        this.setSeed(seed);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(this.defaultSize));
        this.f_19804_.m_135372_(RANDOM_SEED, (Object)812389532);
        this.f_19804_.m_135372_(DYING, (Object)false);
        this.f_19804_.m_135372_(CASTER, Optional.empty());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.f_19859_ = this.f_19857_;
            if (this.rng == null) {
                this.rng = new Random(this.getSeed());
            }
            if (this.getSize() == 0.0f) {
                this.setSize(this.defaultSize);
            }
            if (!this.getDying()) {
                this.initColor();
                this.flap();
                this.colorUpdate(1.0f, true);
            } else {
                if (this.dying == 0) {
                    for (int i = 0; i < this.targets.length; ++i) {
                        this.targets[i][0] = 255.0f;
                        this.targets[i][1] = 255.0f;
                        this.targets[i][2] = 255.0f;
                    }
                }
                this.prevangle = this.angle;
                ++this.dying;
                this.colorUpdate(10.0f, false);
            }
        } else {
            if (this.getDying()) {
                ++this.dying;
                if (this.dying > 25) {
                    this.m_146870_();
                }
            }
            if (this.origPos == null) {
                this.origPos = this.m_20183_();
                this.origPos1 = this.origPos.m_7918_(1, 1, 1);
            }
            this.move();
        }
    }

    public void move() {
        this.f_19858_ = -30.0f;
        this.f_19857_ %= 360.0f;
        Vec3 motion = this.m_20184_();
        double motionX = motion.f_82479_;
        double motionY = motion.f_82480_;
        double motionZ = motion.f_82481_;
        Vec3 pos = this.m_20182_();
        motionX = -0.01 * this.m_20154_().f_82479_;
        motionZ = 0.01 * this.m_20154_().f_82481_;
        if (pos.m_7096_() - (double)this.origPos.m_123341_() < 0.1 || pos.m_7094_() - (double)this.origPos.m_123343_() < 0.1 || (double)this.origPos1.m_123341_() - pos.m_7096_() < 0.1 || (double)this.origPos1.m_123343_() - pos.m_7094_() < 0.1) {
            Vec3 v = EffectUtil.fromBlockPos(this.origPos).m_82520_(0.5, 0.5, 0.5);
            Vec3 moveTo = v.m_82546_(this.m_20182_());
            float yawto = EffectUtil.toDegrees((float)Math.atan2(moveTo.f_82479_, moveTo.f_82481_));
            float diff = this.rotateTowards(yawto);
            this.f_19857_ += diff;
            this.f_19857_ = Mth.m_14177_((float)this.f_19857_);
        }
        if (pos.m_7098_() - (double)this.origPos.m_123342_() < 0.1) {
            motionY = 0.02;
        } else {
            if ((double)this.origPos1.m_123342_() - pos.m_7098_() < 0.1) {
                motionY = -0.02;
            } else if (ServerHandler.tickCounter % 30L == 0L) {
                motionY = (double)this.f_19796_.m_188501_() * 0.04 - 0.02;
            }
            if (!this.getDying()) {
                List lst;
                if (this.aabb == null && this.origPos != null && this.origPos1 != null) {
                    double n = 0.25;
                    this.aabb = new AABB((double)this.origPos.m_123341_() + n, (double)this.origPos.m_123342_() + n, (double)this.origPos.m_123343_() + n, (double)this.origPos1.m_123341_() - n, (double)this.origPos1.m_123342_() - n, (double)this.origPos1.m_123343_() - n);
                }
                if ((lst = this.f_19853_.m_45976_(Entity.class, this.aabb)).size() > 0) {
                    Entity e;
                    Iterator iterator = lst.iterator();
                    while (iterator.hasNext() && ((e = (Entity)iterator.next()) == this || !this.collide(e))) {
                    }
                }
            }
        }
        this.m_20334_(motionX, motionY, motionZ);
        Vec3 newpos = this.m_20182_().m_82549_(this.m_20184_());
        this.m_6034_(newpos.f_82479_, newpos.f_82480_, newpos.f_82481_);
    }

    public float rotateTowards(float yaw) {
        return Math.abs((yaw - this.f_19857_) % 360.0f) < 10.0f ? this.f_19796_.m_188501_() * 2.0f - 1.0f : 5.0f;
    }

    public void startDying() {
        this.setDying(true);
    }

    public void initColor() {
        if (!this.colorstarted) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.colors[i][j] = this.rng.nextInt(255);
                    this.targets[i][j] = this.colors[i][j];
                }
            }
            this.colorstarted = true;
        }
    }

    public void colorUpdate(float step, boolean reroll) {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                float f = this.colors[i][j];
                float f1 = this.targets[i][j];
                if (f == f1) {
                    if (!reroll) continue;
                    this.targets[i][j] = this.rng.nextInt(255);
                    continue;
                }
                if (f > f1) {
                    float[] fArray = this.colors[i];
                    int n = j;
                    fArray[n] = fArray[n] - Math.min(step, f - f1);
                    continue;
                }
                if (!(f < f1)) continue;
                float[] fArray = this.colors[i];
                int n = j;
                fArray[n] = fArray[n] + Math.min(step, f1 - f);
            }
        }
    }

    public void flap() {
        this.prevangle = this.angle;
        float wingrange = 120.0f;
        float fastestFlap = 5.0f;
        float slowestFlap = 15.0f;
        float slowestSpeed = wingrange / slowestFlap;
        float fastestSpeed = wingrange / fastestFlap;
        this.angle += this.wingspeed;
        if (this.angle <= this.bottomstop || this.wingspeed == 0.0f) {
            this.wingspeed = this.rng.nextFloat() * (fastestSpeed - slowestSpeed) + slowestSpeed;
            this.topstop = 90.0f - this.rng.nextFloat() * 12.0f;
        }
        if (this.angle >= this.topstop) {
            this.wingspeed = -(this.rng.nextFloat() * (fastestSpeed - slowestSpeed) + slowestSpeed);
            this.bottomstop = -30.0f + this.rng.nextFloat() * 6.0f;
        }
        this.angle = this.correctAngle(this.angle, -30.0f, 90.0f);
    }

    public float correctAngle(float f, float bottom, float top) {
        float ret = f % (top - bottom);
        if (ret > top) {
            ret = top;
        }
        if (ret < bottom) {
            ret = bottom;
        }
        return ret;
    }

    public void setPlaceEffect(BlockPos pos, Direction direction, BlockState state, ItemStack stack) {
        this.effect = EFFECT.PLACE;
        this.placeBlock = new SerializableBlockPlace();
        this.placeBlock.loc = pos;
        this.placeBlock.state = state;
        this.placeBlock.stack = stack;
        this.origPos = pos.m_121945_(direction);
        this.origPos1 = this.origPos.m_7918_(1, 1, 1);
        this.m_6034_((double)this.origPos.m_123341_() + 0.5, (double)this.origPos.m_123342_() + 0.5, (double)this.origPos.m_123343_() + 0.5);
    }

    public void setBreakEffect(BlockPos pos, Direction direction, BlockState state) {
        this.effect = EFFECT.BREAK;
        this.breakBlock = new SerializableBlockBreak();
        this.breakBlock.loc = pos;
        this.breakBlock.state = state;
        this.origPos = pos.m_121945_(direction);
        this.origPos1 = this.origPos.m_7918_(1, 1, 1);
        this.m_6034_((double)this.origPos.m_123341_() + 0.5, (double)this.origPos.m_123342_() + 0.5, (double)this.origPos.m_123343_() + 0.5);
    }

    public void setHitEffect(Player player, ItemStack stack, ItemStack offstack) {
        this.effect = EFFECT.HIT;
        this.hit = new SerializableHit();
        this.hit.stack = stack;
        this.hit.offstack = offstack;
        this.hit.initialPosition = player.m_20182_();
        this.hit.effects = new ArrayList<MobEffectInstance>(player.m_21220_());
        this.hit.knockback = new Vec3((double)Mth.m_14031_((float)(player.f_19857_ * ((float)Math.PI / 180))), 0.0, (double)(-Mth.m_14089_((float)(player.f_19857_ * ((float)Math.PI / 180)))));
        this.hit.knockbackStrength = this.getKnockBackStrength(player);
        this.hit.cooled = this.getCooledAttackStrength(player);
        this.hit.fire = this.getFireModifier(player);
        this.hit.rotyaw = player.f_19857_;
        this.hit.rotpit = player.f_19858_;
        this.origPos = new BlockPos(player.m_20299_(1.0f).m_82549_(player.m_20154_().m_82492_(0.0, player.m_20154_().f_82480_, 0.0)));
        this.origPos1 = this.origPos.m_7918_(1, 1, 1);
        this.m_6034_((double)this.origPos.m_123341_() + 0.5, (double)this.origPos.m_123342_() + 0.5, (double)this.origPos.m_123343_() + 0.5);
    }

    public float getKnockBackStrength(Player player) {
        boolean flag;
        int i = EnchantmentHelper.m_44894_((LivingEntity)player);
        float f2 = player.m_36403_(0.5f);
        boolean bl = flag = f2 > 0.9f;
        if (player.m_20142_() && flag) {
            ++i;
        }
        return (float)i * 0.5f;
    }

    public int getFireModifier(Player player) {
        return EnchantmentHelper.m_44914_((LivingEntity)player);
    }

    public float getCooledAttackStrength(Player player) {
        return player.m_36403_(0.5f);
    }

    public void attackTargetEntityWithCurrentItem(FakePlayer player, Entity targetEntity) {
        player.m_21008_(InteractionHand.MAIN_HAND, this.hit.stack);
        player.m_21008_(InteractionHand.OFF_HAND, this.hit.offstack);
        player.m_21204_().m_22178_(this.hit.stack.m_41638_(EquipmentSlot.MAINHAND));
        player.f_20922_ = 1000;
        if (!ForgeHooks.onPlayerAttackTarget((Player)player, (Entity)targetEntity)) {
            return;
        }
        if (targetEntity.m_6097_() && !targetEntity.m_7313_((Entity)player)) {
            float f = (float)player.m_21133_(Attributes.f_22281_);
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)this.hit.stack, (MobType)((LivingEntity)targetEntity).m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)this.hit.stack, (MobType)MobType.f_21640_);
            float f2 = this.hit.cooled;
            f1 *= f2;
            player.m_36334_();
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                f += f1;
                int j = this.hit.fire;
                if (targetEntity instanceof LivingEntity && j > 0 && !targetEntity.m_6060_()) {
                    targetEntity.m_20254_(1);
                }
                Vec3 Vec32 = targetEntity.m_20184_();
                boolean flag5 = targetEntity.m_6469_(DamageSource.m_19344_((Player)player), f);
                targetEntity.f_19802_ = 0;
                if (this.hit.knockbackStrength > 0.0f && targetEntity instanceof LivingEntity) {
                    ((LivingEntity)targetEntity).m_147240_((double)this.hit.knockbackStrength, this.hit.knockback.f_82479_, this.hit.knockback.f_82481_);
                }
                if (targetEntity instanceof ServerPlayer && targetEntity.f_19864_) {
                    ((ServerPlayer)targetEntity).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
                    targetEntity.f_19864_ = false;
                    targetEntity.m_20256_(Vec32);
                }
                player.m_21335_(targetEntity);
                EnchantmentHelper.m_44896_((LivingEntity)player, (Entity)targetEntity);
                if (targetEntity instanceof LivingEntity && j > 0) {
                    targetEntity.m_20254_(j * 4);
                }
            }
        }
    }

    public boolean triggerEffect(Entity e) {
        if (this.effect == EFFECT.PLACE) {
            if (this.placeBlock != null && this.placeBlock.loc != null && this.f_19853_ != null && this.getCasterUUID() != null) {
                if (!Utils.isBlockAir(this.f_19853_, this.placeBlock.loc) || !EffectUtil.tryChangeBlockState(false, this.placeBlock.loc, this.placeBlock.state, this.f_19853_, this.f_19853_.m_46003_(this.getCasterUUID()), this.getCasterUUID())) {
                    this.m_19983_(this.placeBlock.stack);
                }
                this.startDying();
                return true;
            }
        } else if (this.effect == EFFECT.BREAK) {
            if (this.breakBlock != null && this.breakBlock.loc != null && this.f_19853_ != null && this.getCasterUUID() != null) {
                boolean z;
                if (this.f_19853_.m_8055_(this.breakBlock.loc).equals(this.breakBlock.state) && (z = EffectUtil.tryChangeBlockState(false, this.breakBlock.loc, Blocks.f_50016_.m_49966_(), this.f_19853_, this.f_19853_.m_46003_(this.getCasterUUID()), this.getCasterUUID()))) {
                    Block.m_49950_((BlockState)this.breakBlock.state, (Level)this.f_19853_, (BlockPos)this.breakBlock.loc);
                }
                this.startDying();
                return true;
            }
        } else if (this.effect == EFFECT.HIT && e instanceof LivingEntity && this.hit.stack != null) {
            SafeFakePlayer fake = new SafeFakePlayer((ServerLevel)this.f_19853_, "butterfly");
            fake.m_6034_(this.hit.initialPosition.f_82479_, this.hit.initialPosition.f_82480_, this.hit.initialPosition.f_82481_);
            fake.m_20343_(this.hit.initialPosition.f_82479_, this.hit.initialPosition.f_82480_, this.hit.initialPosition.f_82481_);
            fake.f_19857_ = this.hit.rotyaw;
            fake.f_19858_ = this.hit.rotpit;
            try {
                if (this.hit.effects != null && this.hit.effects.size() > 0) {
                    for (MobEffectInstance ei : this.hit.effects) {
                        if (ei.m_19544_() == ModEffects.FORESIGHT.get()) continue;
                        fake.m_7292_(ei);
                    }
                }
                this.attackTargetEntityWithCurrentItem(fake, e);
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
            this.startDying();
        }
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    protected void m_20101_() {
    }

    public boolean m_20145_() {
        return !Minecraft.m_91087_().f_91074_.m_20148_().equals(this.getCasterUUID());
    }

    public void setCasterUUID(UUID uuid) {
        this.f_19804_.m_135381_(CASTER, Optional.of(uuid));
    }

    public UUID getCasterUUID() {
        return ((Optional)this.f_19804_.m_135370_(CASTER)).orElse(UUID.randomUUID());
    }

    public boolean collide(Entity e) {
        if (!(this.f_19853_.f_46443_ || this.getCasterUUID() != null && e.m_20148_().equals(this.getCasterUUID()) || e instanceof ButterflyEntity || ContractMahoujinTileEntity.isImmuneToSpell(this.f_19853_, this.getCasterUUID(), e))) {
            return this.triggerEffect(e);
        }
        return false;
    }

    protected void m_7378_(CompoundTag compound) {
        this.setSize(compound.m_128457_(TAG_SIZE));
        this.setSeed(compound.m_128451_(TAG_RANDOM_SEED));
        this.setDying(compound.m_128471_(TAG_DYING));
        if (compound.m_128403_(TAG_CASTER)) {
            this.setCasterUUID(compound.m_128342_(TAG_CASTER));
        }
        if (this.placeBlock == null) {
            this.placeBlock = new SerializableBlockPlace();
        }
        if (compound.m_128441_(TAG_PLACE_BLOCK)) {
            this.placeBlock.read(compound.m_128469_(TAG_PLACE_BLOCK));
        }
        if (this.breakBlock == null) {
            this.breakBlock = new SerializableBlockBreak();
        }
        if (compound.m_128441_(TAG_BREAK_BLOCK)) {
            this.breakBlock.read(compound.m_128469_(TAG_BREAK_BLOCK));
        }
        if (this.hit == null) {
            this.hit = new SerializableHit();
        }
        if (compound.m_128441_(TAG_HIT)) {
            this.hit.read(compound.m_128469_(TAG_HIT));
        }
        if (compound.m_128441_(TAG_EFFECT) && compound.m_128451_(TAG_EFFECT) < EFFECT.values().length) {
            this.effect = EFFECT.values()[compound.m_128451_(TAG_EFFECT)];
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_(TAG_SIZE, this.getSize());
        compound.m_128405_(TAG_RANDOM_SEED, this.getSeed());
        compound.m_128379_(TAG_DYING, this.getDying());
        if (this.getCasterUUID() != null) {
            compound.m_128362_(TAG_CASTER, this.getCasterUUID());
        }
        if (this.placeBlock != null) {
            compound.m_128365_(TAG_PLACE_BLOCK, (Tag)this.placeBlock.write());
        }
        if (this.breakBlock != null) {
            compound.m_128365_(TAG_BREAK_BLOCK, (Tag)this.breakBlock.write());
        }
        if (this.hit != null) {
            compound.m_128365_(TAG_HIT, (Tag)this.hit.write());
        }
        compound.m_128405_(TAG_EFFECT, this.effect.ordinal());
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setSize(float f) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(f));
    }

    public int getSeed() {
        return (Integer)this.f_19804_.m_135370_(RANDOM_SEED);
    }

    public void setSeed(int f) {
        this.f_19804_.m_135381_(RANDOM_SEED, (Object)f);
    }

    public boolean getDying() {
        return (Boolean)this.f_19804_.m_135370_(DYING);
    }

    public void setDying(boolean f) {
        this.f_19804_.m_135381_(DYING, (Object)f);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum EFFECT {
        HIT,
        SHOOT,
        PLACE,
        BREAK,
        NONE;

    }
}

