/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block;

import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.BlockTileEntity;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.networking.ChunkMahouPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.tile.FogProjectorTileEntity;
import stepsword.mahoutsukai.util.ChunkDim;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.FogProjectorValues;
import stepsword.mahoutsukai.util.Utils;

public class FogProjector
extends BlockTileEntity<FogProjectorTileEntity> {
    public static final AABB boundingBox = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AABB boundingBoxE = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static HashSet<ChunkDim> projectors = new HashSet();

    public FogProjector() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60955_(), "fog_projector");
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult resulr) {
        if (world.m_7702_(pos) instanceof FogProjectorTileEntity) {
            FogProjectorTileEntity te = (FogProjectorTileEntity)world.m_7702_(pos);
            if (player.m_21205_().m_41720_() != Items.f_42398_ && world.f_46443_) {
                MahouTsukaiMod.proxy.openFogProjectorGUI(world, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static void fogProjectorRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        if (world.m_7702_(pos) instanceof FogProjectorTileEntity) {
            FogProjectorTileEntity te = (FogProjectorTileEntity)world.m_7702_(pos);
            if (!world.f_46443_ && player.m_21205_().m_41720_() == Items.f_42398_) {
                if (player.m_20163_()) {
                    CompoundTag nbt = FogProjectorTileEntity.getProjectorNBT(player.m_21205_());
                    if (nbt != null && te != null) {
                        FogProjectorValues pv = new FogProjectorValues();
                        pv.read(nbt);
                        te.set_particle_fog_size(pv.get_particle_fog_size());
                        te.set_particle_fog_color_r(pv.get_particle_fog_color_r());
                        te.set_particle_fog_color_g(pv.get_particle_fog_color_g());
                        te.set_particle_fog_color_b(pv.get_particle_fog_color_b());
                        te.set_particle_fog_color_a(pv.get_particle_fog_color_a());
                        te.set_particle_fog_thickness(pv.get_particle_fog_thickness());
                        te.set_particle_fog_speed(pv.get_particle_fog_speed());
                        te.set_particle_fog_random_x(pv.get_particle_fog_random_x());
                        te.set_particle_fog_random_y(pv.get_particle_fog_random_y());
                        te.set_particle_fog_random_z(pv.get_particle_fog_random_z());
                        te.set_particle_fog_direction_x(pv.get_particle_fog_direction_x());
                        te.set_particle_fog_direction_y(pv.get_particle_fog_direction_y());
                        te.set_particle_fog_direction_z(pv.get_particle_fog_direction_z());
                        te.set_particle_fog_shaders(pv.get_particle_fog_shaders());
                        te.set_particle_fog_frequency_num(pv.get_particle_fog_frequency_num());
                        te.set_particle_fog_frequency_ticks(pv.get_particle_fog_frequency_ticks());
                        te.set_camera_fog_radius(pv.get_camera_fog_radius());
                        te.set_camera_fog_color_r(pv.get_camera_fog_color_r());
                        te.set_camera_fog_color_g(pv.get_camera_fog_color_g());
                        te.set_camera_fog_color_b(pv.get_camera_fog_color_b());
                        te.set_camera_fog_strength(pv.get_camera_fog_strength());
                        te.set_camera_fog_toggle(pv.get_camera_fog_toggle());
                        te.sendUpdates();
                    }
                } else {
                    FogProjectorTileEntity.setProjectorNBT(player.m_21205_(), te);
                }
            }
        }
    }

    @Override
    public Class<FogProjectorTileEntity> getTileEntityClass() {
        return FogProjectorTileEntity.class;
    }

    @Nullable
    public FogProjectorTileEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new FogProjectorTileEntity(blockPos, blockState);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState state2, boolean v1) {
        if (!world.f_46443_) {
            IChunkMahou chunkMahou;
            ChunkAccess c = world.m_46865_(pos);
            if (c instanceof LevelChunk && (chunkMahou = Utils.getChunkMahou((LevelChunk)c)) != null && chunkMahou.getFogProjectors() != null) {
                chunkMahou.getFogProjectors().remove((Object)pos);
            }
            if (projectors == null) {
                projectors = new HashSet();
            }
            projectors.add(new ChunkDim(c.m_7697_(), EffectUtil.getDimension(world)));
        }
        super.m_6810_(state, world, pos, state2, v1);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.f_46443_) {
            IChunkMahou chunkMahou;
            ChunkAccess c = world.m_46865_(pos);
            if (c instanceof LevelChunk && (chunkMahou = Utils.getChunkMahou((LevelChunk)c)) != null && chunkMahou.getFogProjectors() != null) {
                chunkMahou.getFogProjectors().add((Object)pos);
            }
            if (projectors == null) {
                projectors = new HashSet();
            }
            projectors.add(new ChunkDim(c.m_7697_(), EffectUtil.getDimension(world)));
        }
        super.m_6807_(state, world, pos, oldState, isMoving);
    }

    public static void fogUpdateTick(TickEvent.LevelTickEvent event) {
        if (!event.level.f_46443_ && event.phase == TickEvent.Phase.END && event.level.m_46467_() % 4L == 0L) {
            for (ChunkDim p : projectors) {
                ServerLevel world = EffectUtil.getNewDimensionByName((ServerLevel)event.level, p.dim);
                LevelChunk c = world.m_6325_(p.pos.f_45578_, p.pos.f_45579_);
                IChunkMahou chunkMahou = Utils.getChunkMahou(c);
                if (chunkMahou == null) continue;
                PacketHandler.sendTrackingBlock(p.pos.m_45615_(), (Level)EffectUtil.getNewDimensionByName((ServerLevel)event.level, p.dim), new ChunkMahouPacket(chunkMahou.getFogProjectors(), p.pos.f_45578_, p.pos.f_45579_, 1));
            }
            projectors.clear();
        }
    }
}

