/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.proxy;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.proxy.ClientProxyComponent;
import org.cyclops.cyclopscore.proxy.CommonProxyComponent;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDataClient;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnosticsPartOverlayRenderer;
import org.cyclops.integrateddynamics.core.network.diagnostics.http.DiagnosticsWebServer;
import org.cyclops.integrateddynamics.proxy.CommonProxy;

public class ClientProxy
extends ClientProxyComponent {
    public static DiagnosticsWebServer DIAGNOSTICS_SERVER;
    private static final String KEYBINDING_CATEGORY_NAME = "key.categories.integrateddynamics";
    public static final KeyMapping FOCUS_LP_SEARCH;
    public static final KeyMapping FOCUS_LP_RENAME;

    public ClientProxy() {
        super((CommonProxyComponent)new CommonProxy());
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onPreTextureStitch);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onPostTextureStitch);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedOut);
    }

    public ModBase getMod() {
        return IntegratedDynamics._instance;
    }

    public void registerEventHooks() {
        super.registerEventHooks();
        MinecraftForge.EVENT_BUS.register((Object)NetworkDiagnosticsPartOverlayRenderer.getInstance());
    }

    public void registerKeyBindings(IKeyRegistry keyRegistry, RegisterKeyMappingsEvent event) {
        super.registerKeyBindings(keyRegistry, event);
        event.register(FOCUS_LP_SEARCH);
        event.register(FOCUS_LP_RENAME);
    }

    public void onPreTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            event.addSprite(SlotVariable.VARIABLE_EMPTY);
        }
    }

    public void onPostTextureStitch(TextureStitchEvent.Post event) {
        if (event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            event.getAtlas().m_118316_(SlotVariable.VARIABLE_EMPTY);
        }
    }

    public void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        if (DIAGNOSTICS_SERVER != null) {
            IntegratedDynamics.clog("Stopping diagnostics server...");
            NetworkDiagnosticsPartOverlayRenderer.getInstance().clearPositions();
            NetworkDataClient.clearNetworkData();
            DIAGNOSTICS_SERVER.deinitialize();
            DIAGNOSTICS_SERVER = null;
            IntegratedDynamics.clog("Stopped diagnostics server");
        }
    }

    static {
        FOCUS_LP_SEARCH = new KeyMapping("key.integrateddynamics.logic_programmer_focus_search", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.ALT, InputConstants.Type.KEYSYM, 70, KEYBINDING_CATEGORY_NAME);
        FOCUS_LP_RENAME = new KeyMapping("key.integrateddynamics.logic_programmer_open_rename", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.ALT, InputConstants.Type.KEYSYM, 82, KEYBINDING_CATEGORY_NAME);
    }
}

