/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.event.PartVariableDrivenVariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.panel.PartTypePanelVariableDriven;

public class ContainerPartPanelVariableDriven<P extends PartTypePanelVariableDriven<P, S>, S extends PartTypePanelVariableDriven.State<P, S>>
extends ContainerMultipart<P, S> {
    private static final int SLOT_X = 79;
    private static final int SLOT_Y = 8;
    private final int readValueId = this.getNextValueId();
    private final int readColorId = this.getNextValueId();
    private final int readErrorsId = this.getNextValueId();

    public ContainerPartPanelVariableDriven(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (Container)new SimpleContainer(packetBuffer.readInt()), Optional.empty(), Optional.empty(), (PartTypePanelVariableDriven)PartHelpers.readPart(packetBuffer));
    }

    public ContainerPartPanelVariableDriven(int id, Inventory playerInventory, Container inventory, Optional<PartTarget> target, Optional<IPartContainer> partContainer, P partType) {
        super(RegistryEntries.CONTAINER_PART_DISPLAY, id, playerInventory, inventory, target, partContainer, partType);
        if (inventory instanceof SimpleInventory) {
            ((SimpleInventory)inventory).addDirtyMarkListener((IDirtyMarkListener)this);
        }
        this.addInventory(inventory, 0, 80, 14, 1, 1);
        this.addPlayerInventory(this.player.m_150109_(), 8, 46);
    }

    protected Slot createNewSlot(Container inventory, int index, int x, int y) {
        if (inventory instanceof SimpleInventory) {
            return new SlotVariable(inventory, index, x, y);
        }
        return super.createNewSlot(inventory, index, x, y);
    }

    public void m_38946_() {
        super.m_38946_();
        if (!this.player.f_19853_.m_5776_()) {
            MutableComponent readValue = Component.m_237113_((String)"");
            int readValueColor = 0;
            if (!NetworkHelpers.shouldWork()) {
                readValue = Component.m_237113_((String)"SAFE-MODE");
            } else {
                IValue value = ((PartTypePanelVariableDriven.State)this.getPartState().get()).getDisplayValue();
                if (value != null) {
                    readValue = value.getType().toCompactString(value);
                    readValueColor = value.getType().getDisplayColor();
                }
            }
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readValueId, (MutableComponent)readValue);
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readColorId, (int)readValueColor);
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readErrorsId, ((PartTypePanelVariableDriven.State)this.getPartState().get()).getGlobalErrors());
        }
    }

    @Override
    public void onDirty() {
        if (!this.player.f_19853_.m_5776_()) {
            PartTypePanelVariableDriven.State partState = (PartTypePanelVariableDriven.State)this.getPartState().get();
            partState.onVariableContentsUpdated((PartTypePanelVariableDriven)this.getPartType(), this.getTarget().get());
            LazyOptional<INetwork> optionalNetwork = NetworkHelpers.getNetwork(this.getTarget().get().getCenter());
            if (!this.getContainerInventory().m_7983_()) {
                NetworkHelpers.getPartNetwork(optionalNetwork).ifPresent(partNetwork -> {
                    try {
                        INetwork network = (INetwork)optionalNetwork.orElse(null);
                        IVariable variable = partState.getVariable(network, (IPartNetwork)partNetwork);
                        MinecraftForge.EVENT_BUS.post(new PartVariableDrivenVariableContentsUpdatedEvent<PartTypePanelVariableDriven, PartTypePanelVariableDriven.State>(network, (IPartNetwork)partNetwork, this.getTarget().get(), (PartTypePanelVariableDriven)this.getPartType(), partState, this.player, variable, variable != null ? (IValue)variable.getValue() : null));
                    }
                    catch (EvaluationException evaluationException) {
                        // empty catch block
                    }
                });
            }
            optionalNetwork.ifPresent(network -> network.getEventBus().post(new VariableContentsUpdatedEvent((INetwork)network)));
        }
    }

    public void m_6877_(Player player) {
        if (this.inventory instanceof SimpleInventory) {
            ((SimpleInventory)this.inventory).removeDirtyMarkListener((IDirtyMarkListener)this);
        }
    }

    public Component getReadValue() {
        return ValueNotifierHelpers.getValueTextComponent((IValueNotifier)this, (int)this.readValueId);
    }

    public int getReadValueColor() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.readColorId);
    }

    public List<MutableComponent> getReadErrors() {
        return ValueNotifierHelpers.getValueTextComponentList((IValueNotifier)this, (int)this.readErrorsId);
    }
}

