/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.cyclopscore.ingredient.recipe.IngredientRecipeHelpers;
import org.cyclops.cyclopscore.ingredient.recipe.RecipeHandlerRecipeType;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class RecipeHandlerSqueezer
extends RecipeHandlerRecipeType<Container, RecipeSqueezer> {
    public RecipeHandlerSqueezer(Supplier<Level> worldSupplier) {
        super(worldSupplier, RegistryEntries.RECIPETYPE_SQUEEZER, (Set)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK}), (Set)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK, IngredientComponent.FLUIDSTACK}));
    }

    @Nullable
    protected Container getRecipeInputContainer(IMixedIngredients input) {
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.m_6836_(0, (ItemStack)input.getInstances(IngredientComponent.ITEMSTACK).get(0));
        return inventory;
    }

    @Nullable
    protected Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> getRecipeInputIngredients(RecipeSqueezer recipe) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        inputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{IngredientRecipeHelpers.getPrototypesFromIngredient((Ingredient)recipe.getInputIngredient())}));
        return inputs;
    }

    @Nullable
    protected IMixedIngredients getRecipeOutputIngredients(RecipeSqueezer recipe) {
        IdentityHashMap outputIngredients = Maps.newIdentityHashMap();
        List outputItems = recipe.getOutputItems().stream().filter(i -> i.getChance() == 1.0f).map(RecipeSqueezer.IngredientChance::getIngredientFirst).collect(Collectors.toList());
        if (!outputItems.isEmpty()) {
            outputIngredients.put(IngredientComponent.ITEMSTACK, outputItems);
        }
        if (!recipe.getOutputFluid().isEmpty()) {
            outputIngredients.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{recipe.getOutputFluid()}));
        }
        if (outputIngredients.isEmpty()) {
            return null;
        }
        return new MixedIngredients((Map)outputIngredients);
    }

    public boolean isValidSizeInput(IngredientComponent<?, ?> ingredientComponent, int size) {
        return ingredientComponent == IngredientComponent.ITEMSTACK && size == 1;
    }
}

