/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.IngredientChannelAdapter;

public class IngredientChannelAdapterWrapperSlotted<T, M>
implements IIngredientComponentStorageSlotted<T, M> {
    private final IngredientChannelAdapter<T, M> channel;
    private final Int2IntMap cacheChannelSlots;

    public IngredientChannelAdapterWrapperSlotted(IngredientChannelAdapter<T, M> channel, Int2IntMap cacheChannelSlots) {
        this.channel = channel;
        this.cacheChannelSlots = cacheChannelSlots;
    }

    protected static int getIngredientComponentStorageSize(IIngredientComponentStorage<?, ?> storage) {
        if (storage instanceof IIngredientComponentStorageSlotted) {
            return ((IIngredientComponentStorageSlotted)storage).getSlots();
        }
        return Iterators.size((Iterator)storage.iterator()) + 1;
    }

    public int getSlots() {
        int slots = this.cacheChannelSlots.getOrDefault(this.channel.getChannel(), -1);
        if (slots != -1) {
            return slots;
        }
        slots = 0;
        IPositionedAddonsNetworkIngredients<T, M> network = this.channel.getNetwork();
        boolean hasDisabledPosition = false;
        for (PartPos pos : network.getPositions()) {
            if (!pos.getPos().isLoaded()) continue;
            if (network.isPositionDisabled(pos)) {
                hasDisabledPosition = true;
                continue;
            }
            network.disablePosition(pos);
            IIngredientComponentStorage<T, M> storage = network.getPositionedStorage(pos);
            slots = Helpers.addSafe((int)slots, (int)IngredientChannelAdapterWrapperSlotted.getIngredientComponentStorageSize(storage));
            network.enablePosition(pos);
        }
        if (!hasDisabledPosition) {
            this.cacheChannelSlots.put(this.channel.getChannel(), slots);
        }
        return slots;
    }

    protected Triple<IIngredientComponentStorage<T, M>, Integer, PartPos> getStorageAndRelativeSlot(int slot) {
        IPositionedAddonsNetworkIngredients<T, M> network = this.channel.getNetwork();
        for (PartPos pos : network.getPositions()) {
            if (!pos.getPos().isLoaded() || network.isPositionDisabled(pos)) continue;
            network.disablePosition(pos);
            IIngredientComponentStorage<T, M> storage = network.getPositionedStorage(pos);
            int storageSize = IngredientChannelAdapterWrapperSlotted.getIngredientComponentStorageSize(storage);
            network.enablePosition(pos);
            if (slot < storageSize) {
                return Triple.of(storage, (Object)slot, (Object)pos);
            }
            slot -= storageSize;
        }
        return Triple.of(null, (Object)-1, null);
    }

    public T getSlotContents(int slotAbsolute) {
        Triple<IIngredientComponentStorage<T, M>, Integer, PartPos> storageAndSlot = this.getStorageAndRelativeSlot(slotAbsolute);
        IIngredientComponentStorage storage = (IIngredientComponentStorage)storageAndSlot.getLeft();
        int slotRelative = (Integer)storageAndSlot.getMiddle();
        PartPos pos = (PartPos)storageAndSlot.getRight();
        if (storage == null) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
        if (storage instanceof IIngredientComponentStorageSlotted) {
            return (T)((IIngredientComponentStorageSlotted)storage).getSlotContents(slotRelative);
        }
        try {
            Object ingredient = Iterators.get((Iterator)storage.iterator(), (int)slotRelative);
            PositionedAddonsNetworkIngredientsFilter<Object> filter = this.channel.getNetwork().getPositionedStorageFilter(pos);
            if (filter != null && !filter.testView(ingredient)) {
                return (T)this.getComponent().getMatcher().getEmptyInstance();
            }
            return (T)ingredient;
        }
        catch (IndexOutOfBoundsException e) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
    }

    public long getMaxQuantity(int slotAbsolute) {
        Triple<IIngredientComponentStorage<T, M>, Integer, PartPos> storageAndSlot = this.getStorageAndRelativeSlot(slotAbsolute);
        IIngredientComponentStorage storage = (IIngredientComponentStorage)storageAndSlot.getLeft();
        int slotRelative = (Integer)storageAndSlot.getMiddle();
        if (storage == null) {
            return 0L;
        }
        if (storage instanceof IIngredientComponentStorageSlotted) {
            return ((IIngredientComponentStorageSlotted)storage).getMaxQuantity(slotRelative);
        }
        return Helpers.castSafe((long)this.getComponent().getMatcher().getMaximumQuantity());
    }

    public T insert(int slotAbsolute, @Nonnull T ingredient, boolean simulate) {
        Triple<IIngredientComponentStorage<T, M>, Integer, PartPos> storageAndSlot = this.getStorageAndRelativeSlot(slotAbsolute);
        IIngredientComponentStorage storage = (IIngredientComponentStorage)storageAndSlot.getLeft();
        int slotRelative = (Integer)storageAndSlot.getMiddle();
        PartPos pos = (PartPos)storageAndSlot.getRight();
        if (storage == null) {
            return ingredient;
        }
        PositionedAddonsNetworkIngredientsFilter<T> filter = this.channel.getNetwork().getPositionedStorageFilter(pos);
        if (filter != null && !filter.testInsertion(ingredient)) {
            return ingredient;
        }
        if (storage instanceof IIngredientComponentStorageSlotted) {
            return (T)((IIngredientComponentStorageSlotted)storage).insert(slotRelative, ingredient, simulate);
        }
        return (T)storage.insert(ingredient, simulate);
    }

    public T extract(int slotAbsolute, long maxQuantity, boolean simulate) {
        Object extractedSimulated;
        Triple<IIngredientComponentStorage<T, M>, Integer, PartPos> storageAndSlot = this.getStorageAndRelativeSlot(slotAbsolute);
        IIngredientComponentStorage storage = (IIngredientComponentStorage)storageAndSlot.getLeft();
        int slotRelative = (Integer)storageAndSlot.getMiddle();
        PartPos pos = (PartPos)storageAndSlot.getRight();
        if (storage == null) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
        PositionedAddonsNetworkIngredientsFilter<Object> filter = this.channel.getNetwork().getPositionedStorageFilter(pos);
        if (filter != null && !simulate && !filter.testExtraction(extractedSimulated = storage instanceof IIngredientComponentStorageSlotted ? ((IIngredientComponentStorageSlotted)storage).extract(slotRelative, maxQuantity, simulate) : storage.extract(maxQuantity, simulate))) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
        Object extracted = storage instanceof IIngredientComponentStorageSlotted ? ((IIngredientComponentStorageSlotted)storage).extract(slotRelative, maxQuantity, simulate) : storage.extract(maxQuantity, simulate);
        if (filter != null && simulate && !filter.testExtraction(extracted)) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
        return (T)extracted;
    }

    public IngredientComponent<T, M> getComponent() {
        return this.channel.getComponent();
    }

    public Iterator<T> iterator() {
        return this.channel.iterator();
    }

    public Iterator<T> iterator(@Nonnull T prototype, M matchCondition) {
        return this.channel.iterator(prototype, matchCondition);
    }

    public long getMaxQuantity() {
        return this.channel.getMaxQuantity();
    }

    public T insert(@Nonnull T ingredient, boolean simulate) {
        return this.channel.insert(ingredient, simulate);
    }

    public T extract(@Nonnull T prototype, M matchCondition, boolean simulate) {
        return this.channel.extract(prototype, matchCondition, simulate);
    }

    public T extract(long maxQuantity, boolean simulate) {
        return this.channel.extract(maxQuantity, simulate);
    }
}

