/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;

public class ItemBlockEnergyContainerAutoSupply
extends ItemBlockEnergyContainer {
    public ItemBlockEnergyContainerAutoSupply(Block block, Item.Properties builder) {
        super(block, builder);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)this.isActivated(itemStack), (String)(this.m_5524_() + ".info.auto_supply"));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        return new InteractionResultHolder(InteractionResult.PASS, (Object)this.toggleActivation(player.m_21120_(hand), world, player));
    }

    public static void autofill(IEnergyStorage source, Level world, Entity entity) {
        int tickAmount;
        if (entity instanceof Player && !world.m_5776_() && (tickAmount = source.extractEnergy(Integer.MAX_VALUE, true)) > 0) {
            Player player = (Player)entity;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack held = player.m_21120_(hand);
                ItemStack filled = ItemBlockEnergyContainerAutoSupply.tryFillContainerForPlayer(source, held, tickAmount, player);
                if (filled.m_41619_()) continue;
                player.m_21008_(hand, filled);
            }
        }
    }

    public static ItemStack tryFillContainerForPlayer(IEnergyStorage source, ItemStack held, int tickAmount, Player player) {
        return held.getCapability(CapabilityEnergy.ENERGY, null).map(target -> {
            int moved = target.receiveEnergy(source.extractEnergy(target.receiveEnergy(tickAmount, true), false), false);
            if (moved > 0) {
                return held;
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int itemSlot, boolean par5) {
        if (this.isActivated(itemStack)) {
            itemStack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(energyStorage -> ItemBlockEnergyContainerAutoSupply.autofill(energyStorage, world, entity));
        }
        super.m_6883_(itemStack, world, entity, itemSlot, par5);
    }

    public ItemStack toggleActivation(ItemStack itemStack, Level world, Player player) {
        if (player.m_36341_()) {
            if (!world.m_5776_()) {
                ItemStack activated = itemStack.m_41777_();
                activated.m_41721_(1 - activated.m_41773_());
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    public boolean isActivated(ItemStack itemStack) {
        return itemStack.m_41773_() == 1;
    }

    public boolean m_5812_(ItemStack itemStack) {
        return this.isActivated(itemStack);
    }
}

