/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.core.evaluate.operator.CurriedOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public class ValueHelpers {
    public static IValueType[] from(IVariable ... variables) {
        IValueType[] valueTypes = new IValueType[variables.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            IVariable variable = variables[i];
            valueTypes[i] = variable == null ? null : variable.getType();
        }
        return valueTypes;
    }

    public static IValueType<?>[] from(IVariableFacade ... variableFacades) {
        IValueType[] valueTypes = new IValueType[variableFacades.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            IVariableFacade variableFacade = variableFacades[i];
            valueTypes[i] = variableFacade == null ? null : variableFacade.getOutputType();
        }
        return valueTypes;
    }

    public static Component[] from(IValueType<?> ... valueTypes) {
        Component[] names = new Component[valueTypes.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            IValueType<?> valueType = valueTypes[i];
            names[i] = Component.m_237115_((String)valueType.getTranslationKey());
        }
        return names;
    }

    public static boolean areValuesEqual(@Nullable IValue v1, @Nullable IValue v2) {
        return v1 == null && v2 == null || v1 != null && v2 != null && v1.equals(v2);
    }

    public static boolean correspondsTo(IValueType t1, IValueType t2) {
        return t1.correspondsTo(t2) || t2.correspondsTo(t1);
    }

    public static IValue evaluateOperator(IOperator operator, IValue ... values) throws EvaluationException {
        IVariable[] variables = new IVariable[values.length];
        for (int i = 0; i < variables.length; ++i) {
            IValue value = values[i];
            variables[i] = new Variable<IValue>(value.getType(), value);
        }
        return ValueHelpers.evaluateOperator(operator, variables);
    }

    public static IValue evaluateOperator(IOperator operator, IVariable ... variables) throws EvaluationException {
        int requiredLength = operator.getRequiredInputLength();
        if (requiredLength == variables.length) {
            return operator.evaluate(variables);
        }
        if (variables.length > requiredLength) {
            IVariable[] acceptableVariables = (IVariable[])ArrayUtils.subarray((Object[])variables, (int)0, (int)requiredLength);
            IVariable[] remainingVariables = (IVariable[])ArrayUtils.subarray((Object[])variables, (int)requiredLength, (int)variables.length);
            IValue result = ValueHelpers.evaluateOperator(operator, acceptableVariables);
            if (result.getType() != ValueTypes.OPERATOR) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.currying_overflow", (Object[])new Object[]{Component.m_237115_((String)operator.getTranslationKey()), requiredLength, variables.length, Component.m_237115_((String)result.getType().getTranslationKey())}));
            }
            IOperator nextOperator = ((ValueTypeOperator.ValueOperator)result).getRawValue();
            return ValueHelpers.evaluateOperator(nextOperator, remainingVariables);
        }
        return ValueTypeOperator.ValueOperator.of(new CurriedOperator(operator, variables));
    }

    public static Tag serializeRaw(IValue value) {
        return value.getType().serialize(value);
    }

    public static CompoundTag serialize(IValue value) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("valueType", value.getType().getUniqueName().toString());
        tag.m_128365_("value", ValueHelpers.serializeRaw(value));
        return tag;
    }

    public static IValue deserialize(CompoundTag tag) {
        IValueType valueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(tag.m_128461_("valueType")));
        if (valueType == null) {
            return null;
        }
        return ValueHelpers.deserializeRaw(valueType, tag.m_128423_("value"));
    }

    public static <T extends IValue> T deserializeRaw(IValueType<T> valueType, Tag valueString) {
        return valueType.deserialize(valueString);
    }

    public static <T extends IValue> String toString(T value) {
        return value.getType().toString(value);
    }

    public static <T extends IValue> T parseString(IValueType<T> valueType, String value) throws EvaluationException {
        return valueType.parseString(value);
    }

    public static void validatePredicateOutput(IOperator predicate, IValue result) throws EvaluationException {
        if (!(result instanceof ValueTypeBoolean.ValueBoolean)) {
            MutableComponent error = Component.m_237110_((String)"operator.integrateddynamics.error.wrong_predicate", (Object[])new Object[]{predicate.getLocalizedNameFull(), Component.m_237115_((String)result.getType().getTranslationKey()), Component.m_237115_((String)ValueTypes.BOOLEAN.getTranslationKey())});
            throw new EvaluationException(error);
        }
    }

    public static Pair<MutableComponent, Integer> getSafeReadableValue(@Nullable IVariable variable) {
        MutableComponent readValue = Component.m_237113_((String)"");
        int readValueColor = 0;
        if (!NetworkHelpers.shouldWork()) {
            readValue = Component.m_237113_((String)"SAFE-MODE");
        } else if (variable != null) {
            try {
                Object value = variable.getValue();
                readValue = value.getType().toCompactString(value);
                readValueColor = value.getType().getDisplayColor();
            }
            catch (NullPointerException | PartStateException | EvaluationException e) {
                readValue = Component.m_237113_((String)"ERROR");
                readValueColor = Helpers.RGBToInt((int)255, (int)0, (int)0);
            }
        }
        return Pair.of((Object)readValue, (Object)readValueColor);
    }

    public static ResourceLocation createResourceLocationInEvaluation(String value) throws EvaluationException {
        try {
            return new ResourceLocation(value);
        }
        catch (ResourceLocationException e) {
            throw new EvaluationException(Component.m_237113_((String)e.getMessage()));
        }
    }
}

