/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenScrolling;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiHolder;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeString;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerActivateElementPacket;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerLabelPacket;
import org.cyclops.integrateddynamics.proxy.ClientProxy;

public class ContainerScreenLogicProgrammerBase<C extends ContainerLogicProgrammerBase>
extends ContainerScreenScrolling<C> {
    public static final int BOX_HEIGHT = 18;
    private static final Rectangle ITEM_POSITION = new Rectangle(19, 18, 56, 17);
    protected final SubGuiHolder subGuiHolder = new SubGuiHolder();
    private final boolean hasLabeller;
    protected RenderPattern operatorConfigPattern = null;
    protected SubGuiOperatorInfo operatorInfoPattern = null;
    protected boolean firstInit = true;
    protected int relativeStep = -1;

    public ContainerScreenLogicProgrammerBase(C container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        ((ContainerLogicProgrammerBase)((Object)container)).setGui(this);
        this.hasLabeller = playerInventory.m_36063_(new ItemStack((ItemLike)RegistryEntries.ITEM_LABELLER));
    }

    protected Rectangle getScrollRegion() {
        return new Rectangle(this.f_97735_ + 19, this.f_97736_ + 18, 57, 178);
    }

    public void m_7856_() {
        super.m_7856_();
        this.subGuiHolder.init(this.f_97735_, this.f_97736_);
        if (this.firstInit) {
            this.setSearchFieldFocussed(true);
            this.firstInit = false;
        }
    }

    public void m_181908_() {
        super.m_181908_();
        this.subGuiHolder.tick();
    }

    protected int getScrollX() {
        return 5;
    }

    protected int getScrollY() {
        return 18;
    }

    protected int getScrollHeight() {
        return 178;
    }

    protected int getBaseXSize() {
        return 256;
    }

    protected int getBaseYSize() {
        return 240;
    }

    protected int getSearchX() {
        return 6;
    }

    protected int getSearchWidth() {
        return 70;
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integrateddynamics", "textures/gui/logic_programmer.png");
    }

    protected float colorSmoothener(float color, boolean hover) {
        return 1.0f - (1.0f - color) / (hover ? 2.0f : 4.0f);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.subGuiHolder.renderBg(matrixStack, this.f_97735_, this.f_97736_, this.getMinecraft().f_90987_, this.f_96547_, partialTicks, mouseX, mouseY);
        this.f_96547_.m_92763_(matrixStack, (Component)Component.m_237115_((String)"gui.integrateddynamics.logicprogrammer.filter"), (float)(this.f_97735_ + this.offsetX + 5), (float)(this.f_97736_ + this.offsetY + 208), Helpers.RGBToInt((int)80, (int)80, (int)80));
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.m_6262_();
        int boxHeight = 18;
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            Triple rgb = Helpers.intToRGB((int)element.getColor());
            boolean hover = LogicProgrammerElementTypes.areEqual(container.getActiveElement(), element) || this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY));
            RenderSystem.m_157429_((float)this.colorSmoothener(((Float)rgb.getLeft()).floatValue(), hover), (float)this.colorSmoothener(((Float)rgb.getMiddle()).floatValue(), hover), (float)this.colorSmoothener(((Float)rgb.getRight()).floatValue(), hover), (float)1.0f);
            RenderHelpers.bindTexture((ResourceLocation)this.texture);
            this.m_93228_(matrixStack, this.f_97735_ + this.offsetX + ContainerScreenLogicProgrammerBase.ITEM_POSITION.x, this.f_97736_ + this.offsetY + ContainerScreenLogicProgrammerBase.ITEM_POSITION.y + boxHeight * i, 19, 18, ContainerScreenLogicProgrammerBase.ITEM_POSITION.width, ContainerScreenLogicProgrammerBase.ITEM_POSITION.height);
            if (hover) {
                this.m_93228_(matrixStack, this.f_97735_ + this.offsetX + ContainerScreenLogicProgrammerBase.ITEM_POSITION.x, this.f_97736_ + this.offsetY + ContainerScreenLogicProgrammerBase.ITEM_POSITION.y + boxHeight * i, 0, 240, 3, 16);
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String aspectName = element.getSymbol();
            RenderHelpers.drawScaledCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (String)aspectName, (int)(this.f_97735_ + this.offsetX + (hover ? 22 : 21)), (int)(this.f_97736_ + this.offsetY + 26 + boxHeight * i), (int)53, (int)Helpers.RGBToInt((int)40, (int)40, (int)40));
        }
    }

    protected Rectangle getElementPosition(ContainerLogicProgrammerBase container, int i, boolean absolute) {
        return new Rectangle(ContainerScreenLogicProgrammerBase.ITEM_POSITION.x + this.offsetX + (absolute ? this.f_97735_ : 0), ContainerScreenLogicProgrammerBase.ITEM_POSITION.y + 18 * i + this.offsetY + (absolute ? this.f_97736_ : 0), ContainerScreenLogicProgrammerBase.ITEM_POSITION.width, ContainerScreenLogicProgrammerBase.ITEM_POSITION.height);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        this.subGuiHolder.drawGuiContainerForegroundLayer(matrixStack, this.f_97735_, this.f_97736_, this.getMinecraft().f_90987_, this.f_96547_, mouseX, mouseY);
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.m_6262_();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            if (!this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY))) continue;
            LinkedList lines = Lists.newLinkedList();
            element.loadTooltip(lines);
            this.drawTooltip(lines, matrixStack, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    protected void onActivateElement(ILogicProgrammerElement<RenderPattern, ContainerScreenLogicProgrammerBase<?>, ContainerLogicProgrammerBase> element) {
        this.operatorInfoPattern = new SubGuiOperatorInfo(element);
        this.subGuiHolder.addSubGui(this.operatorInfoPattern);
        this.operatorInfoPattern.init(this.f_97735_, this.f_97736_);
        this.operatorConfigPattern = (RenderPattern)element.createSubGui(88, 18, 160, 87, this, (ContainerLogicProgrammerBase)this.m_6262_());
        this.subGuiHolder.addSubGui(this.operatorConfigPattern);
        this.operatorConfigPattern.init(this.f_97735_, this.f_97736_);
    }

    protected void onDeactivateElement(ILogicProgrammerElement element) {
        this.subGuiHolder.clear();
    }

    public boolean handleElementActivation(ILogicProgrammerElement element) {
        boolean activate = false;
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.m_6262_();
        ILogicProgrammerElement newActive = null;
        this.onDeactivateElement(element);
        if (container.getActiveElement() != element) {
            activate = true;
            newActive = element;
            if (element != null) {
                this.onActivateElement(element);
            }
        }
        container.setActiveElement(newActive, this.operatorConfigPattern == null ? 0 : this.operatorConfigPattern.getX(), this.operatorConfigPattern == null ? 0 : this.operatorConfigPattern.getY());
        if (newActive != null) {
            ILogicProgrammerElementType type = newActive.getType();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerActivateElementPacket(type.getUniqueName(), type.getName(newActive)));
        } else {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerActivateElementPacket(new ResourceLocation(""), new ResourceLocation("")));
        }
        return activate;
    }

    protected void setSearchFieldFocussed(boolean focused) {
        this.getSearchField().m_5755_(focused);
    }

    protected boolean isSearchFieldFocussed() {
        return this.getSearchField().m_93696_();
    }

    protected boolean selectPageElement(int elementId) {
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.m_6262_();
        if (elementId < 0) {
            this.handleElementActivation(container.getActiveElement());
            return false;
        }
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i) || elementId-- != 0) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            if (container.getActiveElement() != element) {
                this.handleElementActivation(element);
            }
            return true;
        }
        return false;
    }

    protected boolean handleKeyCode(int keyCode, int scanCode) {
        InputConstants.Key inputCode = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode != 340 && keyCode != 344) {
            boolean isElementFocused;
            ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.m_6262_();
            int pageSize = container.getPageSize();
            int stepModifier = MinecraftHelpers.isShifted() ? pageSize - 1 : 1;
            boolean bl = isElementFocused = container.getActiveElement() != null && container.getActiveElement().isFocused(this.operatorConfigPattern);
            if (ClientProxy.FOCUS_LP_SEARCH.isActiveAndMatches(inputCode)) {
                this.setSearchFieldFocussed(true);
                return true;
            }
            if (isElementFocused && ClientProxy.FOCUS_LP_RENAME.isActiveAndMatches(inputCode) && this.hasLabeller()) {
                this.operatorInfoPattern.onButtonEditClick();
                return true;
            }
            if (263 == keyCode && !isElementFocused && this.isSearchFieldFocussed()) {
                this.setSearchFieldFocussed(this.isSearchFieldFocussed());
                return true;
            }
            if (!isElementFocused && 264 == keyCode) {
                if (!this.selectPageElement(this.relativeStep += stepModifier)) {
                    this.relativeStep -= stepModifier;
                    if (this.relativeStep > 0) {
                        this.getScrollbar().scrollRelative((double)(-stepModifier));
                        this.selectPageElement(this.relativeStep);
                    }
                }
                return true;
            }
            if (!isElementFocused && 265 == keyCode) {
                if (this.relativeStep < 0 || !this.selectPageElement(this.relativeStep -= stepModifier)) {
                    this.getScrollbar().scrollRelative((double)stepModifier);
                    this.relativeStep = 0;
                    this.selectPageElement(0);
                }
                return true;
            }
            if (!(isElementFocused || 262 != keyCode && 258 != keyCode && 257 != keyCode && 335 != keyCode)) {
                if (container.getActiveElement() != null) {
                    container.getActiveElement().setFocused(this.operatorConfigPattern, true);
                    this.setSearchFieldFocussed(false);
                }
                return true;
            }
        }
        return false;
    }

    public boolean m_5534_(char keyCode, int scanCode) {
        return this.subGuiHolder.charTyped(keyCode, scanCode) || this.handleKeyCode(keyCode, scanCode) || super.m_5534_(keyCode, scanCode);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode != 256 && (this.subGuiHolder.keyPressed(keyCode, scanCode, modifiers) || this.handleKeyCode(keyCode, scanCode))) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.subGuiHolder.mouseClicked(mouseX, mouseY, mouseButton);
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.m_6262_();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            if (!this.isPointInRegion(this.getElementPosition(container, i, false), new Point((int)mouseX, (int)mouseY))) continue;
            boolean activated = this.handleElementActivation(element);
            int n = this.relativeStep = activated ? i : -1;
            if (!activated) continue;
            container.getActiveElement().setFocused(this.operatorConfigPattern, true);
            this.setSearchFieldFocussed(false);
            return true;
        }
        if (super.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isSearchFieldFocussed() && container.getActiveElement() != null && container.getActiveElement().isFocused(this.operatorConfigPattern)) {
            container.getActiveElement().setFocused(this.operatorConfigPattern, false);
            return true;
        }
        return false;
    }

    protected void label(String label) {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerLabelPacket(label));
    }

    protected boolean hasLabeller() {
        return this.hasLabeller;
    }

    public class SubGuiOperatorInfo
    extends GuiElementValueTypeString.SubGuiValueTypeInfo<RenderPattern, ContainerScreenLogicProgrammerBase<?>, ContainerLogicProgrammerBase> {
        private WidgetTextFieldExtended searchField;
        private ButtonText button;

        public SubGuiOperatorInfo(IGuiInputElement<RenderPattern, ContainerScreenLogicProgrammerBase<?>, ContainerLogicProgrammerBase> element) {
            super(ContainerScreenLogicProgrammerBase.this, (ContainerLogicProgrammerBase)ContainerScreenLogicProgrammerBase.this.m_6262_(), element, 88, 106, 139, 20);
            this.button = null;
            if (ContainerScreenLogicProgrammerBase.this.hasLabeller()) {
                this.button = new ButtonText(0, 0, 6, 10, (Component)Component.m_237115_((String)"gui.integrateddynamics.button.edit"), (Component)Component.m_237113_((String)"E"), button -> this.onButtonEditClick(), true);
                this.buttonList.add(this.button);
            }
            int searchWidth = 113;
            this.searchField = new WidgetTextFieldExtended(ContainerScreenLogicProgrammerBase.this.f_96547_, 0, 0, searchWidth, 11, (Component)Component.m_237115_((String)"gui.cyclopscore.search"));
            this.searchField.m_94199_(64);
            this.searchField.m_94182_(true);
            this.searchField.m_94194_(false);
            this.searchField.m_94202_(0xFFFFFF);
            this.searchField.m_94190_(true);
            this.searchField.m_94144_("");
            this.searchField.m_93674_(searchWidth);
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            int searchX = 90;
            int searchY = 110;
            this.searchField.f_93620_ = guiLeft + searchX;
            this.searchField.f_93621_ = guiTop + searchY;
            if (ContainerScreenLogicProgrammerBase.this.hasLabeller()) {
                this.button.f_93620_ = guiLeft + 220;
                this.button.f_93621_ = guiTop + 111;
            }
        }

        @Override
        protected boolean showError() {
            return ((ContainerLogicProgrammerBase)this.container).canWriteActiveElementPre();
        }

        @Override
        protected Component getLastError() {
            return ((ContainerLogicProgrammerBase)this.container).getLastError();
        }

        @Override
        protected ResourceLocation getTexture() {
            return ContainerScreenLogicProgrammerBase.this.texture;
        }

        @Override
        public boolean charTyped(char typedChar, int keyCode) {
            if (!this.searchField.m_93696_() || !this.searchField.m_5534_(typedChar, keyCode)) {
                return super.charTyped(typedChar, keyCode);
            }
            ContainerScreenLogicProgrammerBase.this.label(this.searchField.m_94155_());
            return true;
        }

        @Override
        public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
            if (this.searchField.m_93696_() && typedChar != 256) {
                this.searchField.m_7933_(typedChar, keyCode, modifiers);
                ContainerScreenLogicProgrammerBase.this.label(this.searchField.m_94155_());
                return true;
            }
            return super.keyPressed(typedChar, keyCode, modifiers);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            if (this.searchField.m_94213_() && this.searchField.m_6375_(mouseX, mouseY, mouseButton)) {
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public void renderBg(PoseStack matrixStack, int guiLeft, int guiTop, TextureManager textureManager, Font font, float partialTicks, int mouseX, int mouseY) {
            super.renderBg(matrixStack, guiLeft, guiTop, textureManager, font, partialTicks, mouseX, mouseY);
            Minecraft.m_91087_().f_91068_.m_90926_(true);
            this.searchField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }

        public void onButtonEditClick() {
            this.searchField.m_94194_(!this.searchField.m_94213_());
            if (this.searchField.m_94213_()) {
                this.searchField.m_5755_(true);
                ContainerScreenLogicProgrammerBase.this.label(this.searchField.m_94155_());
            } else {
                ContainerScreenLogicProgrammerBase.this.label("");
            }
        }
    }
}

