/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class PartTarget {
    private final PartPos center;
    private final PartPos target;

    public static PartTarget fromCenter(DimPos pos, @Nullable Direction side) {
        return PartTarget.of(PartPos.of(pos, side), PartPos.of(DimPos.of((ResourceKey)pos.getLevelKey(), (BlockPos)(side == null ? pos.getBlockPos() : pos.getBlockPos().m_121945_(side))), side == null ? null : side.m_122424_()));
    }

    public static PartTarget fromCenter(PartPos pos) {
        return PartTarget.fromCenter(pos.getPos(), pos.getSide());
    }

    public static PartTarget fromCenter(Level world, BlockPos pos, Direction side) {
        return PartTarget.fromCenter(DimPos.of((Level)world, (BlockPos)pos), side);
    }

    public static PartTarget of(PartPos center, PartPos target) {
        return new PartTarget(center, target);
    }

    public PartPos getCenter() {
        return this.center;
    }

    public PartPos getTarget() {
        return this.target;
    }

    private PartTarget(PartPos center, PartPos target) {
        this.center = center;
        this.target = target;
    }

    public PartTarget forTargetSide(Direction targetSide) {
        return new PartTarget(this.center, PartPos.of(this.target.getPos(), targetSide));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartTarget)) {
            return false;
        }
        PartTarget that = (PartTarget)o;
        if (!this.center.equals(that.center)) {
            return false;
        }
        return this.target.equals(that.target);
    }

    public int hashCode() {
        int result = this.center.hashCode();
        result = 31 * result + this.target.hashCode();
        return result;
    }

    public String toString() {
        return "PartTarget{center=" + this.center + ", target=" + this.target + "}";
    }
}

