/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.Objects;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.HerbJar;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;

public class MixingCauldronRenderer
implements BlockEntityRenderer<MixingCauldronTile> {
    public static final float CORNERS = (float)MixingCauldron.SHAPE.m_83288_(Direction.Axis.X) + 0.1875f;
    public static final float MIN_Y = 0.25f;
    public static final float MAX_Y = 0.9375f;

    public void render(MixingCauldronTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tileEntityIn.m_58904_().m_8055_(tileEntityIn.m_58899_()).m_155947_() || !(tileEntityIn.m_58904_().m_7702_(tileEntityIn.m_58899_()) instanceof MixingCauldronTile)) {
            return;
        }
        float craftPercent = 0.0f;
        if (!Objects.requireNonNull(tileEntityIn.m_58904_()).m_8055_(tileEntityIn.getPos()).m_155947_() || !(tileEntityIn.m_58904_().m_7702_(tileEntityIn.m_58899_()) instanceof MixingCauldronTile)) {
            return;
        }
        craftPercent = (float)((Integer)tileEntityIn.m_58904_().m_8055_(tileEntityIn.getPos()).m_61143_((Property)MixingCauldron.CRAFT_DELAY)).intValue() / 100.0f;
        float dist = Math.abs(tileEntityIn.fluidRenderLevel - (float)tileEntityIn.getFluidStack().getAmount()) / 1000.0f;
        tileEntityIn.fluidRenderLevel = HexereiUtil.moveTo(tileEntityIn.fluidRenderLevel, tileEntityIn.getFluidStack().getAmount(), (25.0f + 50.0f * dist) * partialTicks);
        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, (BlockState)((BlockState)((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).m_49966_().m_61124_((Property)HerbJar.GUI_RENDER, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HerbJar.DYED, (Comparable)Boolean.valueOf(tileEntityIn.dyeColor != 4337438 && tileEntityIn.dyeColor != 0)), null, tileEntityIn.getDyeColor());
        float fillPercentage = 0.0f;
        boolean flag = false;
        FluidStack fluidStack = tileEntityIn.getFluidInTank(0);
        if (tileEntityIn.renderedFluid != null) {
            fluidStack = tileEntityIn.renderedFluid;
            flag = true;
        }
        if (!fluidStack.isEmpty()) {
            matrixStackIn.m_85836_();
            fillPercentage = Math.min(1.0f, (flag ? tileEntityIn.fluidRenderLevel : (float)fluidStack.getAmount()) / (float)tileEntityIn.getTankCapacity(0));
            if (fluidStack.getFluid().m_205067_(Tags.Fluids.GASEOUS)) {
                MixingCauldronRenderer.renderFluid(matrixStackIn, bufferIn, fluidStack, fillPercentage, 1.0f, combinedLightIn, tileEntityIn);
            } else {
                MixingCauldronRenderer.renderFluid(matrixStackIn, bufferIn, fluidStack, 1.0f, fillPercentage, combinedLightIn, tileEntityIn);
            }
            matrixStackIn.m_85849_();
        }
        float height = 0.25f + 0.6875f * fillPercentage;
        for (int i = 0; i < 8; ++i) {
            ItemStack item = tileEntityIn.getItemStackInSlot(i);
            if (item.m_41619_()) continue;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, (double)(height + 0.00390625f), 0.5);
            double itemRotationOffset = 0.8 * (double)i + (double)(craftPercent * (20.0f * craftPercent));
            if (fillPercentage > 0.0f) {
                matrixStackIn.m_85837_(0.0 + Math.sin(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f), Math.sin(Math.PI * (double)Hexerei.getClientTicks() / 30.0 + (double)(i * 20)) / 10.0 * 0.2, 0.0 + Math.cos(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f));
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)((double)((float)(45 * i) - 1.0f) + 2.0 * Math.sin((tileEntityIn.degrees + (float)(i * 20)) / 40.0f))));
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_((float)(82.5 + 5.0 * Math.cos((tileEntityIn.degrees + (float)(i * 22)) / 40.0f))));
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_((float)(-2.5 + 5.0 * Math.cos((tileEntityIn.degrees + (float)(i * 24)) / 40.0f))));
                matrixStackIn.m_85841_(1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f);
            } else {
                matrixStackIn.m_85837_(0.0 + Math.sin(itemRotationOffset) / 3.5, 0.0, 0.0 + Math.cos(itemRotationOffset) / 3.5);
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)(45 * i)));
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(85.0f));
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(-2.5f));
            }
            matrixStackIn.m_85841_(0.4f, 0.4f, 0.4f);
            this.renderItem(item, partialTicks, matrixStackIn, bufferIn, combinedLightIn);
            matrixStackIn.m_85849_();
        }
        ItemStack item2 = new ItemStack((ItemLike)tileEntityIn.getItemInSlot(8));
        if (!item2.m_41619_()) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, (double)(height + 0.00390625f), 0.5);
            if (fillPercentage > 0.0f) {
                matrixStackIn.m_85837_(0.0, Math.sin(Math.PI * (double)Hexerei.getClientTicks() / 60.0 + 20.0) / 10.0 * 0.2, 0.0);
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)(44.0 + 2.0 * Math.sin((tileEntityIn.degrees + 20.0f) / 40.0f)) - craftPercent * craftPercent * 720.0f));
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_((float)(82.5 + 5.0 * Math.cos((tileEntityIn.degrees + 22.0f) / 40.0f))));
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_((float)(-2.5 + 5.0 * Math.cos((tileEntityIn.degrees + 24.0f) / 40.0f))));
            } else {
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(45.0f - craftPercent * craftPercent * 720.0f));
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(85.0f));
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(-2.5f));
            }
            matrixStackIn.m_85841_(0.4f, 0.4f, 0.4f);
            this.renderItem(item2, partialTicks, matrixStackIn, bufferIn, combinedLightIn);
            matrixStackIn.m_85849_();
        }
        tileEntityIn.degrees += 1.0f;
        if (tileEntityIn.getItemInSlot(9) == ModItems.BLOOD_SIGIL.get() && tileEntityIn.getItemInSlot(9).m_5456_() == ModItems.BLOOD_SIGIL.get()) {
            matrixStackIn.m_85836_();
            this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BLOOD_SIGIL.get()).m_49966_());
            matrixStackIn.m_85849_();
        }
    }

    private static void renderFluid(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, FluidStack fluidStack, float alpha, float heightPercentage, int combinedLight, MixingCauldronTile tileEntityIn) {
        VertexConsumer vertexBuilder = renderTypeBuffer.m_6299_(RenderType.m_110472_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack));
        Color color2 = new Color(BiomeColors.m_108811_((BlockAndTintGetter)tileEntityIn.m_58904_(), (BlockPos)new BlockPos(tileEntityIn.getPos().m_123341_(), tileEntityIn.getPos().m_123342_(), tileEntityIn.getPos().m_123343_())));
        int color = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
        alpha *= (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        if (tileEntityIn.getFluidStack().isFluidEqual(new FluidStack((Fluid)Fluids.f_76193_, 1))) {
            red = (float)color2.getRed() / 255.0f;
            green = (float)color2.getGreen() / 255.0f;
            blue = (float)color2.getBlue() / 255.0f;
        }
        MixingCauldronRenderer.renderQuads(matrixStack.m_85850_().m_85861_(), vertexBuilder, sprite, red, green, blue, alpha, heightPercentage, combinedLight);
    }

    public static void renderFluidGUI(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, FluidStack fluidStack, float alpha, float heightPercentage, int combinedLight) {
        VertexConsumer vertexBuilder = renderTypeBuffer.m_6299_(RenderType.m_110472_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack));
        int color = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        MixingCauldronRenderer.renderQuads(matrixStack.m_85850_().m_85861_(), vertexBuilder, sprite, red, green, blue, alpha *= (float)(color >> 24 & 0xFF) / 255.0f, heightPercentage, combinedLight);
    }

    public static void renderFluidBlockGUI(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, FluidStack fluidStack, float alpha, int combinedLight) {
        VertexConsumer vertexBuilder = renderTypeBuffer.m_6299_(RenderType.m_110472_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack));
        int color = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        MixingCauldronRenderer.renderQuadsBlock(matrixStack.m_85850_().m_85861_(), vertexBuilder, sprite, red, green, blue, alpha *= (float)(color >> 24 & 0xFF) / 255.0f, combinedLight);
    }

    private static void renderQuads(Matrix4f matrix, VertexConsumer vertexBuilder, TextureAtlasSprite sprite, float r, float g, float b, float alpha, float heightPercentage, int light) {
        float height = 0.25f + 0.6875f * heightPercentage;
        float minU = sprite.m_118367_((double)(CORNERS * 16.0f));
        float maxU = sprite.m_118367_((double)((1.0f - CORNERS) * 16.0f));
        float minV = sprite.m_118393_((double)(CORNERS * 16.0f));
        float maxV = sprite.m_118393_((double)((1.0f - CORNERS) * 16.0f));
        vertexBuilder.m_85982_(matrix, CORNERS, height, CORNERS).m_85950_(r, g, b, alpha).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, CORNERS, height, 1.0f - CORNERS).m_85950_(r, g, b, alpha).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 1.0f - CORNERS, height, 1.0f - CORNERS).m_85950_(r, g, b, alpha).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 1.0f - CORNERS, height, CORNERS).m_85950_(r, g, b, alpha).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void renderQuadsBlock(Matrix4f matrix, VertexConsumer vertexBuilder, TextureAtlasSprite sprite, float r, float g, float b, float alpha, int light) {
        float height = 0.75f;
        float minU = sprite.m_118367_((double)(CORNERS * 16.0f));
        float maxU = sprite.m_118367_((double)((1.0f - CORNERS) * 16.0f));
        float minV = sprite.m_118393_((double)(CORNERS * 16.0f));
        float maxV = sprite.m_118393_((double)((1.0f - CORNERS) * 16.0f));
        vertexBuilder.m_85982_(matrix, CORNERS / 5.0f, height, CORNERS / 5.0f).m_85950_(r, g, b, alpha).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).m_85950_(r, g, b, alpha).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 1.0f - CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).m_85950_(r, g, b, alpha).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 1.0f - CORNERS / 5.0f, height, CORNERS / 5.0f).m_85950_(r, g, b, alpha).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        float shading = 0.75f;
        vertexBuilder.m_85982_(matrix, CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(minU, minV).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, CORNERS / 5.0f, height, CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(minU, maxV).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, CORNERS / 5.0f, 0.0f, CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(maxU, maxV).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, CORNERS / 5.0f, 0.0f, 1.0f - CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(maxU, minV).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        shading = 0.45f;
        vertexBuilder.m_85982_(matrix, 1.0f - CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, CORNERS / 5.0f, 0.0f, 1.0f - CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 1.0f - CORNERS / 5.0f, 0.0f, 1.0f - CORNERS / 5.0f).m_85950_(r * shading, g * shading, b * shading, alpha).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
    }

    private void renderItem(ItemStack stack, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, null);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BlockState state, RenderType renderType, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, renderType, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, RenderType renderType, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    for (RenderType rt : bakedmodel.getRenderTypes(p_110913_, RandomSource.m_216335_((long)42L), modelData)) {
                        dispatcher.m_110937_().renderModel(p_110914_.m_85850_(), p_110915_.m_6299_(renderType != null ? renderType : RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, rt);
                    }
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().m_108829_(stack, ItemTransforms.TransformType.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

