/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.util;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import potionstudios.byg.BYG;
import potionstudios.byg.mixin.access.StructureTemplatePoolAccess;
import potionstudios.byg.util.GSONUtil;

public class JigsawUtil {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));

    public static void addBYGBuildingsToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry) {
        JigsawUtil.addLegacyBuildingToPool(new ResourceLocation("village/plains/houses"), "byg:minecraft/village/plains/houses/plains_forager_1", 2, templatePoolRegistry, processorListRegistry);
        JigsawUtil.addLegacyBuildingToPool(new ResourceLocation("village/taiga/houses"), "byg:minecraft/village/taiga/houses/taiga_forager_1", 2, templatePoolRegistry, processorListRegistry);
    }

    private static void addLegacyBuildingToPool(ResourceLocation poolRL, String nbtPieceRL, int weight, Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry) {
        JigsawUtil.addBuildingToPool(poolRL, nbtPieceRL, weight, templatePoolRegistry, processorListRegistry, StructurePoolElement::m_210512_);
    }

    /*
     * WARNING - void declaration
     */
    private static void addBuildingToPool(ResourceLocation poolRL, String nbtPieceRL, int weight, Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, BiFunction<String, Holder<StructureProcessorList>, Function<StructureTemplatePool.Projection, ? extends SinglePoolElement>> construction) {
        void var10_12;
        Holder emptyProcessorList = processorListRegistry.m_206081_(EMPTY_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            BYG.logWarning(String.format("Ignoring pool \"%s\" bc it's not available.", poolRL.toString()));
            return;
        }
        ArrayList<Pair<StructurePoolElement, Integer>> listOfPieceEntries = new ArrayList<Pair<StructurePoolElement, Integer>>(((StructureTemplatePoolAccess)pool).byg_getRawTemplates());
        for (Pair pair : listOfPieceEntries) {
            JsonElement jsonElement = (JsonElement)StructurePoolElement.f_210468_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((StructurePoolElement)pair.getFirst())).result().orElseThrow();
            String location = GSONUtil.readFirstField("location", String.class, jsonElement);
            if (!nbtPieceRL.equals(location)) continue;
            BYG.logInfo(String.format("Not appending structure pool element \"%s\" because it is already specified via data packs for this pool \"%s\".", nbtPieceRL, poolRL.toString()));
            return;
        }
        StructurePoolElement piece = (StructurePoolElement)construction.apply(nbtPieceRL, (Holder<StructureProcessorList>)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        boolean bl = false;
        while (var10_12 < weight) {
            ((StructureTemplatePoolAccess)pool).byg_getTemplates().add((Object)piece);
            ++var10_12;
        }
        listOfPieceEntries.add((Pair<StructurePoolElement, Integer>)new Pair((Object)piece, (Object)weight));
        ((StructureTemplatePoolAccess)pool).byg_setRawTemplates(listOfPieceEntries);
    }
}

