/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class Boulder
extends Feature<NoisySphereConfig> {
    protected static FastNoise fastNoise;
    protected long seed;

    public Boulder(Codec<NoisySphereConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoisySphereConfig> featurePlaceContext) {
        BlockPos origin = featurePlaceContext.m_159777_();
        RandomSource random = featurePlaceContext.m_225041_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        final WorldGenLevel level = featurePlaceContext.m_159774_();
        boolean place = this.place(new Application(){

            @Override
            public void apply(BlockPos pos, BlockState state) {
                level.m_7731_(pos, state, 2);
            }

            @Override
            public boolean isOccupied(BlockPos blockPos) {
                return false;
            }
        }, level.m_7328_(), random, origin, (NoisySphereConfig)featurePlaceContext.m_159778_());
        for (Holder spawningFeature : ((NoisySphereConfig)featurePlaceContext.m_159778_()).spawningFeatures()) {
            ((PlacedFeature)spawningFeature.m_203334_()).m_226357_(level, chunkGenerator, random, origin);
        }
        return place;
    }

    public void fillList(final Long2ObjectMap<BlockState> positions, long seed, RandomSource random, BlockPos origin, NoisySphereConfig config) {
        this.place(new Application(){

            @Override
            public void apply(BlockPos pos, BlockState state) {
                positions.put(pos.m_121878_(), (Object)state);
            }

            @Override
            public boolean isOccupied(BlockPos blockPos) {
                return positions.containsKey(blockPos.m_121878_());
            }
        }, seed, random, origin, config);
    }

    public boolean place(Application application, long seed, RandomSource random, BlockPos origin, NoisySphereConfig config) {
        this.setSeed(seed);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutable);
        int stackHeight = config.stackHeight().m_214085_(random);
        NoisySphereConfig.RadiusSettings radiusSettings = config.radiusSettings();
        int xRadius = radiusSettings.xRadius().m_214085_(random) / 2;
        int yRadius = radiusSettings.yRadius().m_214085_(random) / 2;
        int zRadius = radiusSettings.zRadius().m_214085_(random) / 2;
        fastNoise.SetFrequency(config.noiseFrequency());
        double xRadiusSquared = xRadius * xRadius;
        double yRadiusSquared = yRadius * yRadius;
        double zRadiusSquared = zRadius * zRadius;
        for (int stackIDX = 0; stackIDX < stackHeight; ++stackIDX) {
            for (int x = -xRadius; x <= xRadius; ++x) {
                for (int z = -zRadius; z <= zRadius; ++z) {
                    for (int y = yRadius; y >= -yRadius; --y) {
                        double threshold;
                        double equationResult;
                        mutable2.m_122190_((Vec3i)mutable).m_122184_(x, y, z);
                        if (application.isOccupied((BlockPos)mutable2) || (equationResult = (double)(x * x) / xRadiusSquared + (double)(y * y) / yRadiusSquared + (double)(z * z) / zRadiusSquared) >= (threshold = 1.0 + 0.7 * (double)fastNoise.GetNoise(mutable2.m_123341_(), mutable2.m_123342_(), mutable2.m_123343_()))) continue;
                        BlockState state = config.blockProvider().m_213972_(random, (BlockPos)mutable2);
                        application.apply((BlockPos)mutable2, state);
                    }
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }

    public static interface Application {
        public void apply(BlockPos var1, BlockState var2);

        public boolean isOccupied(BlockPos var1);
    }
}

